
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <alloc.h>


#include "externs.h"

extern unsigned _ovrbuffer = 0x20;

unsigned getheapsize( void )
{
    struct farheapinfo hi;
    unsigned total_memory;

    hi.ptr = NULL;
    printf( "   Size   Status\n" );
    printf( "   ----   ------\n" );

    while( farheapwalk( &hi ) == _HEAPOK )
    {
      printf( "%7u    %s\n", hi.size, hi.in_use ? "used" : "free" );

      if (hi.in_use)
       total_memory += hi.size;
    }

    return total_memory;
}



extern unsigned _ovrbuffer;

extern void _OVREXIT();
extern void _OVRINIT();
extern void _OvrPrepare();


/*************************************************************************/
/*                                                                       */
/* Command line interpreter main line function                           */
/*                                                                       */
/* Commands:                                                             */
/*                                                                       */
/* VIEW           - view a file named                                    */
/* ADDEMUP        - add a list of numbers                                */
/* HELP           - display help for all commands or one if named        */
/* ADD_STUDENT    - add a student name and id to link list structure     */
/* SHOW_STUDENTS  - display all students in link list structure          */
/* DELETE_STUDENT - delete a student from link structure                 */
/* FIND ID        - find a student by id number                          */
/* FIND STUDENT   - find a student by name                               */
/*                                                                       */
/*************************************************************************/


void main(void)
{
 char *tokens[20];
 int total_tokens;
 int index;
 FP function;
 int commands=0;
 int not_done=1;


 clrscr(); /* clear screen */


 printf("\nReal time interpeter 1.0\n\n");



 help(1,NULL);                  /* call intial help menu for command disply */

 cmd_line=(char *)malloc(255);  /* declare and allocate mem for commmad line */

 do
 {
  printf("\nOK[%d]>",commands);

  gets(cmd_line);

  not_done=strcmp("exit",cmd_line);
  total_tokens=parse(tokens);

  if (total_tokens<=20)
  {
   if(total_tokens && not_done)
   {
    printf("calling search function...\n");
    function=search(tokens[0]);
    printf("the function address is: %Fp\n", function);

    if (function==NULL)         /* check if command not found */
     error(etable[2]);          /* if so call error with proper message */
    else
     function(total_tokens,tokens);
   }
  }
  else
   error(etable[8]);
  commands++;
 } while (not_done);

 free(cmd_line);

 error(etable[3]); /* exit interpeter */
}
