/*********************************************************************/
/***     A UTILITY PROGRAM TO PROVIDE INTERRUPT VECTOR LISTINGS   ***/
/***         ALSO LOCATES OPTIONAL ROMS INSTALLED IN SYSTEM       ***/
/***                                                              ***/
/********************************************************************/
#include (string.h)
#include (stdlib.h)

struct vector {              /*global structure to store vectors*/
	unsigned int seg;
	unsigned int off;
} interrupt [256];          /*global array of actual vectors   */

******************************************************************/

main(argc, argv)
int argc;
char *argv[];
{
   int num,trgt1,trgt2;
   unsigned int far *ptr;  /* far pointer used to "peek" memory*/
   void listgrp(), listall(); /* void function declarations */
   for (num=0; num <= 255; num++) {  /* begin by reading all vectors */
     ptr = num * 4;
     interrupt [num].seg = *(ptr+1);
     interrupt [num].off = *ptr;
}
if (argc == 1)             /* if no args, list all vectors */
     listall();
else if (argc == 2) {     /* need either help or one vector */
  if ((! strcmpi(argv[1],"help"))||(! strcmpi[1], "?"))){
    puts("\nINTERRUPT - copyright 1986 by Andrew Fried\n");
    puts("Available Commands :\n");
    puts("\INT\"    Print listing of all interrupt vectors to STDOUT.");
    puts("\"INT n\"  Display single vector (n=decimal).");
    puts("\"INT n n\" Display range of vectors (n=decimal).");
    puts("\INT ?\" or \"INT ?" or "\INT help\"  print out this help list
            ing.");
    puts("\nNote: You may use the DOS \">\" command to redirect program
            output.");
   }
   else{
     trgt1 = atoi (arg[1]);
     listgrp(trgt1, trgt1);
   }
}
else if (argc == 3) {
     trgt1 = atoi(argv[1]);
     trgt2 = atoi(argv[2]);
     listgrp(trgt1,trgt2);
   }
}
/********************************************************************/

void listall()              /* produces full vector listing       */
{
   int num, r1,r2,r3;

   puts("    INTERRUPT VECTOR LISTING UTILITY                 ");

   for(num=0; num < 85; num++) {
     r1 = num * 3;
     r2 = r1 + 1;
     r3 = r2 + 1;
     printf("%03d [0x%02X] %04X:%04X     %03d [0x%02X] %04X:%04X  %03d
              [0x%02X] %04X:%04X\n",
         r1,r1, interrupt[r1].seg,interrupr[r1].off,
         r2,r2, interrupt[r2].seg,interrupt[r2].off,
         r3,r3, interrupt[r3].seg,interrupt[r3].off;
}
   printf("%s%03d [0x02X] %04X:%04X\n",
     "                            ",
     255,255, interrupt[255].seg,interrupt[255].off|);
   romcheck();           /* locate any rom signatures  */

/*******************************************************************/

void listgrp(start,stop)
int start, stop;
{

   int loop;

   if ((start<0 || (stop>255)||(start>stop))
     puts("Vector out of range! Program aborted...\n");
   else
     for(loop=start; loop(=stop; loop++)
       printf("%03d [0x%02X] %04X:%04X\n", loop,loop,interrupt[loop].
           seg,interrupt[loop].off);
}

/*********************************************************************/

romcheck()
{
   int count=0;
   unsigned long memloc;
   unsigned int far *ptr;

   for (memloc=0xC800000; memloc <=0F400000; memloc+=0x800000){
       ptr = memloc;
       if (*ptr==0xAA55) {
        count++;
        printf("\nROM BIOS Signature found at %041X:%041x...\n",
              memloc)>16,memloc&0xFFFF);
      }
   }
   if (count == 0)
     puts("\nNo ROM BIOS Signatures found in memory from C800:0000
             to F400:0000.\n");
   else
     printf("\nROMCHECK located a total of %d ROM Signature(s).\n",
             count);
      return(count);
  }

/********************************************************************/
                                                                                                    