/*
	INTOPOST.C

	Rex Jaechke, "C Users Journal" mach 92.
*/

#include <ctype.h>

void push(int);
int pop(void);

/*--------------------------------------------------------------------------

FUNCTION: intopost - converts infix to postfix

A.	Push a ( on the stack. This sentinel allows us to detect when we
	have flushed out the stack on completion in step 1.

--- Perform steps B through H for each character in the infix string ---

B.	Ignore white space.

C.	Pass alphabetic characters through to postfix list.

D.	Push any ( on the stack. These sentinels allows us to detect when
	have flushed out the stack when handling ) and operators.

E.	Have a ) so pop off the stack and put into postfix list until a (
	is popped. Discard the (.

F	Have a * or /. Pop off any operators of equal or higher precedence
	and put them into postfix list. If a ( or lower precedence operator
	(such as + or -) is popped, put it back and stop looking.
	Push new * or /.

G.	Have a + or -. Pop off any operators of equal or higher precedence
	(that includes all of them) and put them into postfix list. If a (
	is popped, put it back and stop looking. Push new + or -.

H.	Report unknown character on input.

--------

I.	Have processed all input characters. New flush stack until we find
	the matchint ( put there in step A.

J.	Terminate the postfix list.

--------------------------------------------------------------------------*/

void intopost(const char *infix, char *postfix)
{
	int	st;

/*A*/	push('(');
	while (*infix != '\0') {

#ifdef TRACE
printf("*infix: %c\n", *infix);
#endif

/*B*/		if (isspace(*infix)) {
			;
		}
/*C*/		else if (isalpha(*infix)) {
			*postfix++ = *infix;
		}
/*D*/		else if (*infix == '(') {
			push('(');
		}
/*E*/		else if (*infix == ')') {
			while ((st = pop()) != '(')
				*postfix++ = st;
		}
/*F*/		else if (*infix == '*' || *infix == '/') {
			while (1) {
				if ((st = pop()) == '(' || st == '+'
				    || st == '-') {
					push(st);
					break;
				}
				*postfix++ = st;
			}
			push(*infix);
		}
/*G*/		else if (*infix == '+' || *infix == '-') {
			while (1) {
				if ((st = pop()) == '(') {
					push(st);
					break;
				}
				*postfix++ = st;
			}
			push(*infix);
		}
/*H*/		else {
			printf("Unknown input character %c\n", *infix);
		}
		++infix;
		continue;
	}
/*I*/	while ((st = pop()) != '(')
		*postfix++ = st;

/*J*/	*postfix = '\0';
}

/* Fil Slut : INTOPOST.C */
