/***********************************************************************
Intermediate Programmer tutorial #001
Copyright (c) 1995 by Jouni Miettunen

Critical Error (0x24) handler sample program

To test the program run it 4 times:
1) put formatted non-write-protected diskette in drive A:
2) put formatted write-protected diskette in drive A:
3) remove diskette from drive A: (press control-C to exit)
4) put unformatted diskette into drive A:

***********************************************************************/

#include <dos.h>
#include <stdio.h>

int	my_handler	( int, int, int, int		);

static char	*int24_message[] = {
	"Write protect",
	"Unknown unit",
	"Drive not ready",
	"Unknown command",
	"Data error (CRC)",
	"Bad request",
	"Seek error",
	"Unknown media type",
	"Sector not found",
	"Printer out of paper",
	"Write fault",
	"Read fault",
	"General failure",
	"reserved",
	"reserved",
	"Invalid disk change"
};

/* main ***************************************************************/
/* the main program ***************************************************/
/**********************************************************************/
int main(void)
{
FILE	*fp;

puts("Please make sure there is no disk in disk drive A:");
puts("and press any key to continue...");
if (!getch()) getch();

harderr(my_handler);

puts("Trying to create a file on disk drive A: ...");
fp = fopen("a:filename.$$$","wb");	// w == create/overwrite file
if (fp) {
	puts("File creation was successful!");
	fclose(fp);
	remove("a:filename.$$$");
}
puts("End of the program.");

return (0);

} /* int main */

#pragma argsused
/* my_handler *********************************************************/
/* my own 0x24 function ***********************************************/
/**********************************************************************/
int my_handler(
	int 	error,
	int	ax,
	int	bp,
	int	si
	)
{
char	buffer[81];
int	disk,
	id,
	result;

// device error
if (ax<0) {
	sprintf(buffer,"Error: Device error number %d.\r\n$",error);
	bdosptr(0x09,buffer,0);
	hardretn(2);	// abort
}

// disk error
else {
	disk = (ax & 0xff); id = (error & 0xff);

	switch (id) {
	case 0:
		result = 0;	// ignore and continue
		sprintf(buffer,"Error %d: drive %c write protected.\r\n$",
		id, disk + 'A');
		break;
	case 2:
		result = 1;	// retry == Control-C (0x23) handler
		sprintf(buffer,"Error %d: drive %c not ready.\r\n$",
		id, disk + 'A');
		break;
	default:
		result = 2;	// abort
		sprintf(buffer,"Error %d: %s (drive %c).\r\n$",
		id, int24_message[id], disk + 'A');
		break;
	}
}

bdosptr(0x09,buffer,0);	// avoid printf, use DOS system calls
return (result);

} /* int my_handler */

/**********************************************************************/
/*************************** A HAPPY END ******************************/
/**********************************************************************/

