/*
 * Program to display the equipment configuration installed in
 * an IBM/PC or compatable system.
 *
 * This demonstrates the use of inline assembly language routines,
 * which are used to obtain information from the IBM/PC BIOS.
 *
 * Copyright 1989,1990 Dave Dunfield
 * All rights reserved.
 */
#include \mc\stdio.h

/* Video adapter display text */
	char *ivmode[] = { "Unknown", "Color-40", "Color-80", "Monochrome" };

/*
 * Main program to display the equipment installed in an IBM/PC
 */
main()
{
	int equip, hdrives, i;

	equip = get_equip();
	hdrives = 0;
	for(i=0x80; i < (0x80+26); ++i) {
		if(!test_drive(i))
			++hdrives; }
	printf("Base system memory=%uK\n", get_mem());
	printf("Math co-processor%sinstalled\n", (equip & 2) ? " " : " not ");
	printf("Game adaptor%sinstalled\n", (equip & 0x1000) ? " " : " not ");
	printf("Startup video is %s\n", ivmode[(equip >> 4) & 3]);
	printf("%u Floppy disk drive(s)\n", (equip & 1) && (((equip >> 6) & 3) + 1));
	printf("%u Hard disk drive(s)\n", hdrives);
	printf("%u Serial port(s)\n", (equip >> 9) & 7);
	printf("%u Parallel port(s)\n", (equip >> 14) & 3);
}

/*
 * Get the equipment configuration from BIOS
 */
get_equip()
{ ;
#asm
		INT		11h			; Get equipment
#endasm
}

/*
 * Get size of installed memory from BIOS
 */
get_mem()
{ ;
#asm
		INT		12h			; Get memory size
#endasm
}

/*
 * Test for existance of a hard drive
 */
test_drive(drive)
{ ;
#asm
		MOV		DL,4[BP]	; Get drive id
		MOV		AH,10h		; Drive status function
		INT		13h			; Ask BIOS
		MOV		AL,AH		; Get value
		XOR		AH,AH		; Zero high
#endasm
}
