/*
 * This function draws a very crude "robot" face on the PC video
 * screen, using block characters on an 80x25 matrix. In addition
 * to entertaining children, it shows some simple techniques for
 * drawing lines, boxes and circles, which could be applied to
 * higher resolution graphics modes.
 *
 * Copyright 1990 Dave Dunfield
 * All rights reserved.
 */

#include \mc\stdio.h		/* Standard I/O definitions */
#include \mc\video.h		/* Video	I/O definitions */

#define	PCHR	0xDB

/*
 * Main program, draw the face
 */
main()
{
	int i;

	vopen();
	vcursor_off();
	box(1, 0, 77, 24);
	for(i=1; i < 5; ++i) {
		circle(17, 8, i);
		circle(60, 8, i); }
	circle(17, 8, 6);
	circle(60, 8, 6);
	line(38, 9, 42, 13);
	line(38, 9, 34, 13);
	line(35, 13, 41, 13);
	box(24, 18, 53, 21);
	vgetc();
	vcursor_line();
	vclscr();
}

/*
 * Draw a line from point (x1, y1) to (x2, y2)
 */
line(x1, y1, x2, y2)
	int x1, y1, x2, y2;
{
	int i, w, h;

	/* If 'X' is greater, increment through 'X' coordinate */
	if((w = abs(x1 - x2)) >= (h = abs(y1 - y2))) {
		if(x1 > x2) {
			i = x1;
			x1 = x2;
			x2 = i;
			i = y1;
			y1 = y2;
			y2 = i; }
		h = y2 - y1;

		for(i=0; i < w; ++i) {
			vgotoxy(x1+i, y1+((i*h) / w));
			vputc(PCHR); } }
	/* If 'Y' is greater, increment through 'Y' coordinate */
	else {
		if(y1 > y2) {
			i = x1;
			x1 = x2;
			x2 = i;
			i = y1;
			y1 = y2;
			y2 = i; }
		w = x2 - x1;
		for(i=0; i < h; ++i) {
			vgotoxy(x1+((i*w)/h), y1+i);
			vputc(PCHR); } }

	vgotoxy(x2, y2);
	vputc(PCHR);
}

/*
 * Draw a box with opposite corners (x1, y1) to (x2, y2)
 */
box(x1, y1, x2, y2)
	int x1, y1, x2, y2;
{
	line(x1, y1, x2, y1);
	line(x1, y1, x1, y2);
	line(x2, y1, x2, y2);
	line(x1, y2, x2, y2);
}

/*
 * Draw a circle about point (x, y) of radus (r)
 */
circle(x, y, r)
	int x, y, r;
{
	int i, j, k, rs, lj;

	rs = (lj = r)*r;
	for(i=0; i <= r; ++i) {
		j = k = sqrt(rs - (i*i));
		do {
			vgotoxy(x+i, y+j); vputc(PCHR);
			vgotoxy(x+i, y-j); vputc(PCHR);
			vgotoxy(x-i, y+j); vputc(PCHR);
			vgotoxy(x-i, y-j); vputc(PCHR); }
		while(++j < lj);
		lj = k; }
}
