/************************* BigArray.hpp *******************************
  This is the header that contains the class definition for BigArray.
***********************************************************************/

#ifndef __BIGARRAY_H
#define __BIGARRAY_H

extern "C" {
    #include "memory.h"
};

class BigArray {

	private:

	long            offset;		//  currently accessed byte in array
	long            Item;       //  currently accessed item in array
	int             step;		//  Size of step to take
	unsigned        Line;       //  Currently accessed line from buffer

	byte            status;     //  Error indicator

	mem_hand        Handle;		//  handle of this array
	unsigned        Lines;		//  number of lines in array
	unsigned        Width;		//  size of each line in array
	long            Items;      //  Number of items in array
	unsigned long   ArraySize;	//  total array size
	byte far       *LineBuf;    //  pointer to current line of array

	public:

    /***    Constructor defaults to using Extended, then Expanded,
            then Conventional, then Virtual

            Defaults to an array of bytes, but can be called with
            an optional second parameter declaring the size of
            each element, eg:

            BigArray MyArray(1000,sizeof(mystruct))
    ***/
    BigArray( long          NElements,
	          unsigned int  ElementSize=1,
	          char         *AllocStrategy="XECV");

    /***    Destructor is simple enough
    ***/
	~BigArray();

	/***    Check to see if error - should be called for
	        each attempted allocation
	***/
	int     OK(void);

	/***    Report on type of memory allocated
	***/
	char   *Type(void);

    /***    Return a pointer to the current element.
            This can then be cast to the data type being allocated,

            structptr = (struct mystruct *)*MyArray

            or used to store a new value:

            (struct mystruct *)*MyArray->MyElement = 45;
    /**/
	byte * operator*(void);

    /***    Return a pointer to the given element, and positions
            the array there.

            This can then be cast to the data type being allocated,

            structptr = (struct mystruct *)MyArray[1042];

            or used to store a new value:

            (struct mystruct *)MyArray[1042]->MyElement = 6;
    /**/
	byte * operator[](unsigned long i);

    /***    Increment and Decrement the current element
            (Advances ElementSize bytes at a time)
            Returns false on error
    ***/
	int  operator++(void);
	int  operator--(void);

	/***    Logical status indicator - returns status after last
	        operation
	***/
	int operator!(void);

	/***    Feed in bytes sequentially, and pull out bytes sequentially.

	        Note that after a ++, -- or [] operation, the array
	        will be positioned at the first byte of the given element,
	        and subsequent << >> ops will move from here one byte at
	        a time.

	        The Current Element will only be changed once you have moved
	        ElementSize bytes in this fashion.

	        Both return -1 on error
	***/
	int  operator<<(byte);
    int  operator>>(byte &recipient);
};

#endif  /* __BIGARRAY_H */
