/***    Mem_Demo.cpp

        Demonstration of the BigArray Class, which is a "wrapper" around
        the MeMMaN XMS/EMS/Virtual Memory manager.

        Illustrates the Use of BigArray to declare a large array of structures
        in "Extra" memory, and demonstrates the operator overloads.
***/

extern "C" {
    #include <string.h>
    #include <stdio.h>
    #include <dos.h>
}

#include <iostream.h>

#include "bigarray.hpp"

/***    Define a new data type to be stored in the BigArray
***/
typedef struct {
    char name[80];
    int  age;
} MyType;

demo(char *Strat) {
    int i;

    /***    Allocate an array of 16K of these, which is 1.28MB
    ***/
    BigArray Monster(16384L,sizeof(MyType),Strat);
    BigArray Baby(128L,sizeof(MyType),Strat);

    /***    We *must* test if it succeeded
    ***/
    if (!Monster) {
        cout << "Couldn't allocate the monster!" << endl;
        return 0;
    } else {
	    cout << "Monster allocated OK from " << Monster.Type() << " Memory" << endl;
	    cout << "Size of buffer = " << (16384L*sizeof(MyType)) << " bytes!!" << endl;
	}

	/***    Test the second array we tried to allocate
	***/
	if (!Baby && *Strat=='V') {
	    cout << "Couldn't allocate two buffers because this is the shareware demo" << endl;
	}

	/***    Now write a few selected entries
	***/
    for (i=0; i<16384; i+=64) {
        sprintf( ((MyType *)Monster[i])->name,
                  "This is entry %d in the BigArray Monster!!",i );

        ((MyType *)Monster[i])->age = i % 100; // Best not get carried away!
	}

	/***    Now stream out a few characters from the array:
	***/

	Monster[0];    // Position the array

	for (i=0;i<128;i++) Monster++;   // Step back and
	for (i=0;i<64;i++)  Monster--;   // forth a bit

    /***    Read from there 1 at a time
    ***/
    {
        byte c;
        while (-1!= (Monster >> c)) {
            cout << c;
            delay(50);
            if (!c) break;
        }
        cout << endl;
    }

	/***    Now stream a few into the array
	***/
	Monster[32];    // Position the array to reset the offset
    {
        char *p="This is what I wrote into index 32!";

        do { Monster << *p; } while (*p++);
    }

    /***    Write that out demonstrating the action of a plain *
    ***/
    cout << ((MyType *)*Monster)->name << endl;

}

main () {
    /***    Note that you can usually accept the default allocation
            strategy of "XECV" since this takes the best memory that
            is available, trying each in turn, keeping conventional
            free unless needed as a last resort.
    ***/

    cout << "Trying conventional.....";
    demo ("C");
    cout << "           (Not that surprising, really)" << endl;
    cout << "                -----------------------------------------------"<<endl;

    cout << "Trying XMS (Extended)...";
    demo ("X");
    cout << "           (Extended is the second fastest to conventional)" << endl;
    cout << "                -----------------------------------------------"<<endl;

    cout << "Trying EMS (Expanded)...";
    demo ("E");
    cout << "           (Expanded has the extra overhead of paging)" << endl;
    cout << "                -----------------------------------------------"<<endl;

    cout << "Trying Virtual (Disk)...";
    demo ("V");
    cout << "           (Virtual is super slow, but it's better than nothing!!)" << endl;
    cout << "                -----------------------------------------------"<<endl;

    cout << "                    Yer dead flash or what! (English slang)" << endl;
}
