/*====================================================================
  Rob Hamerling - Marklin Interface driver for DOS.

  Header file 'MARKLIN.H'

  Function definitions for OS/2 and DOS-versions of Marklin Interface driver.
  To be included in all programs using one of these drivers.

  Designed to be used with: -  IBM C/2 compiler (version 1.1)
                            -  MicroSoft C-compiler (version 6.00a +)
                            -  IBM C Set/2 compiler (OS/2 2.0: 32-bits)
                            -  and other compatible (ANSI) compilers

  Copyright (c) Rob Hamerling, 1991,92
  All Rights Reserved.
  ==================================================================== */

/* Functions Declarations */

void         mklclose(void);            /* close interface             */
int          mklflush(void);            /* await output complete       */
unsigned short int mklgetsn(short int); /* read sensor word            */
int          mklgo(short int);          /* GO and opt. (re-)start poll */
long int     mklmsecs(void);            /* get precise time (DOS only) */
void         mklopen(short int, short int); /* init. communications    */
void         mklpoll(short int);        /* start/stop polling          */
int          mklpurge(void);            /* purge output buffer         */
int          mklputc(unsigned short int);  /* transmit 1 or 2 chars    */
void         mklsleep(void);            /* release timeslice           */
long int     mklstats(short int);       /* get statistics counter      */
int          mklstop(void);             /* transmit STOP and block INT */
long int     mkltime(void);             /* get time ('tick' precision) */
void         mkltrace(int);             /* start/stop INT trace MKLAPI */

/* External Data Declarations */

/* extern unsigned long int mkltime;       REPLACED BY FUNCTION        */

/* Macro Declarations */

#define mklput1c(p)    mklputc( (int)(p)     & 0x00FF)  /* send 1 ch.  */
#define mklput2c(p,q)  mklputc(((int)(q)<<8) | (p))     /* send 2 ch.  */

