/* Murphy's Law display program   Version II */

/**********************************************************
*                                                         *
*       Author: Charles J.C. Lyall                        *
*               R.R. #2, Kingman                          *
*               Alberta, Canada                           *
*               T0B 2M0                                   *
*               Phone/Fax(403) 662-2119                   *
*               CompuServe 70674,313                      *
*                                                         *
*       Copyright (c) 1987 by Charles J.C. Lyall          *
*                                                         *
***********************************************************
*                                                         *
*       Revision History:                                 *
*                                                         *
*       February 22, 1987                      3.00       *
*         Original Version                                *
*       June 10, 1987                          3.01       *
*         Changed constant of multiplication used in      *
*         computing filepos from 79 to 257                *
*         Cleaned up code to handle boundary conditions   *
*         Added 3 lines of documentation describing       *
*         boundary conditions                             *
*                                                         *
*       June 29, 1987                          3.02       *
*         Routine made compatible with Borland            *
*         TURBO C compiler.  Added #define TURBOC         *
*         to handle conditional compiles                  *
*                                                         *
*       January 29, 1988                                  *
*         Minor documentation revisions.                  *
*                                                         *
*                                                         *
*       February 12, 1990                                 *
*         Changed output by character to output of a      *
*         zero terminated ASCII string because print      *
*         speed was too slow on an OS/2 LAN               *
*                                                         *
***********************************************************
*                                                         *
*       NOTICE:                                           *
*       This program may be copied by anyone              *
*       for their own amusement. Anyone discovering a     *
*       new fundamental law is requested to send it to    *
*       the author who collects such things.              *
*                                                         *
***********************************************************
*                                                         *
*       Brief Technical Note:                             *
*                                                         *
*       This routine is written in MicroSoft C with a     *
* switch allowing compilation by Borland TURBO C.         *
*                                                         *
*       The major problem with this version of MURPHY is  *
* that the text file is separate from the program. It is  *
* necessary to search for the text if the text is not in  *
* the current directory. The search for the text file has *
* three phases:                                           *
*                                                         *
*     - look in the current directory and failing that    *
*     - if MURPATH is defined in the environment, use it  *
*         as a full pathname and failing that             *
*     - search every directory in the path and failing    *
*         that                                            *
*     - complain bitterly and quit                        *
*                                                         *
*                                                         *
*       The rest of the code is disgustingly simple.      *
* This program has been used in some colleges as an       *
* example of how to document a program. To the hardened   *
* C programmer, it will therefore appear overdocumented.  *
*                                                         *
*       Tough.                                            *
***********************************************************
*                                                         *
*  A Note on Invoking the Program:                        *
*                                                         *
*  MURPHY ? or MURPHY HELP will generate a help message   *
*                                                         *
*  An alternative text file may be invoked in the         *
* following manner. Assume that you have a new file named *
* NEWFILE.TXT which you wish to have driven by MURPHY. If *
* this text file is hidden in C:\SECRET\HIDDEN, then it   *
* may be driven by MURPHY if you do the following: Type   *
*                                                         *
* set MURPATH=C:\secret\hidden\newfile.txt                *
*                                                         *
*   This defines MURPATH in the environment and MURPHY    *
* will look in the environment for MURPATH if it fails to *
* find MURPHY00.TXT in the current directory. When MURPHY *
* finds MURPATH in the environment, it will open the file *
* specified by the MURPATH variable.                      *
*                                                         *
***********************************************************
*                                                         *
*  A note on how to add laws and prepare your own data    *
*  file.                                                  *
*                                                         *
*  A proper data file for this program consists of an     *
*  at symbol (@) followed by one or more law entries      *
*  where a law entry is defined as text followed by an    *
*  at symbol.  In other words, the at symbols are used to *
*  delimit both the laws and the file.                    *
*                                                         *
*  For example:                                           *
*                                                         *
*  @                                                      *
*     text of law 1                                       *
*     more text of law 1                                  *
*  @                                                      *
*         text of law 2                                   *
*  @                                                      *
*     text of third and last law                          *
*  @                                                      *
*                                                         *
*  Thats all it takes!                                    *
***********************************************************
*                                                         *
*     A financial note:                                   *
*                                                         *
*     Should you want up to date versions of the text or  *
* the previous version (laws bound into program), they    *
* can be obtained either from myself or (in the case of   *
* the U of Alberta text files) from Peter Johnston.       *
* Please send a disk or disks in a re-usable mailer with  *
* return postage inside. Our American cousins can skip    *
* the postage because they can't buy Canadian stamps,     *
* and the Canadian Postal Service won't accept American   *
* stamps. I will gratefully accept $2 in US funds for     *
* return postage.                                         *  
*                                                         *
* Requests from outside North America should be           *
* accompanied by a reasonable estimate of return postage. *
* No reasonable estimate will be refused. Excess funds    *
* will be used to support younger programmers who ask all *
* sorts of reasonably intelligent questions.              *
*                                                         *
* No other donations are solicited. I did this one for    *
* the fun of it.                                          *
*                                                         *
**********************************************************/

/*      An historical look at Murphy's laws.

    The inability of humanity to forsee the consequences
of their actions has been known since ancient times.
About 400 BC, the last of classical Athens's great dramatists,
Euripides, wrote:

    What we look for does not come to pass.
    God finds a way for what none forsaw.

    Perhaps Aeschylus or Sophocles said it earlier. Still, 
even allowing for a clumsy translation, Euripides doesn't 
come close to the economy and precision of Murphy's Law 
which requires only seven words to establish the most 
fundamental truth concerning humanity and the universe.

         'If anything can go wrong, it will.'


	I do not believe that there ever was a Mr. Murphy.
There are many stories alleging his actual existence but
if he did exist, his lawyers would surely have sued each
and every one of the commercial publishers of Murphy's Laws.

The earliest extensive comment on the perversity of
the universe that I have found so far dates to
September 1864 when Katherine Child published "The
Total Depravity of Inanimate Things".  She complained
about "... the elusiveness of soap, the knottiness of strings,
the transitory nature of buttons, the inclination of
suspenders to twist and of hooks to forsake their lawful
eyes ...."  Clearly, she was a woman of vision born far
before her time -- she'd have been a great engineer!

    In British 'humour', the Irish are considered to be 
congenitally stupid; a music hall comedian can bring the 
house down by, "Did you hear about the Irish brain
surgeon...."  The original Murphyisms were observations on
human stupidity as such and hence would be attributed to
an Irishman and who would  be more Irish than Murphy?  The
metaphor of the actively malevolent universe came along in
later years (excepting, of course, the redoubtable Ms. Child)
although the maxim, "Toast always falls butter side down",
belongs to the earliest collections of Murphy's Laws.  In
Britain these observations are known as Sod's laws after
the Brit phrase for a well meaning idiot, a "poor sod".

        To my knowledge, the first collection of Murphy's
laws appeared in Astounding Science Fiction in the letters
to the editor column over a period of months in the late
1950s.  The editor, John W. Campbell Jr, encouraged this
and scientists and engineers dutifully submitted their
hard earned knowledge of the general perversity of the
universe to the delight and edification of the general
readership.

        Things became much more serious when the IEEE
(then the EEE) published "The Contributions of Edsel
Murphy to the Understanding of the Behavior of Inanimate
Objects" (EEE, Vol 15, No. 8, August 1967).  This dealt
at length with the application of Murphy's law to general
engineering, mathematics, prototyping and production, and
specifying.  The author was one Mr. D. L. Klipstein which 
explains why his name shows up so often.  Unfortunately, 
some law listings attribute all the laws listed in the article 
to Klipstein himself.  I have followed the attributions given
by Klipstein.

        I am not making this up!

        The computer age entered in 1981, when H.J. Kuhman,
one of the dwarves inhabiting the maze of twisty little
passages of Data General, built a program to display Murphy's
laws.  It was written in assembler which made it less
transportable than the Great Lakes.  Data General never
officially admitted that the program existed but every
salesman had a copy and soon almost every Eclipse and MV
installation ran MURPHY as part of the user start up
procedure.

        A version of Murphy exists on the University of
Alberta Amdahl mainframe using the MTS operating system.
A dump of the laws from this version is completely compatible
with this program. Dumps can be obtained from:

          Peter Johnston
          PSC Consulting Ltd.
          834 Geneva Crescent
          St. Albert, Alberta
          Canada T8N 0Z4

        Be warned that at the time of writing, February '87,
this file contains over 300,000 bytes of text and it is growing.
It will come in either backup or ZIP format.

        Peter Johnston will also supply the laws in
MacIntosh format for those who are so inclined.  Send him a
standard 3.5 inch disk in a reusable mailer and include
sufficient stamps for return.  You will have to write your
own program to drive it on the MacIntosh.

        This is the second version of MURPHY released into
the public domain.  The original version bound the code and
the laws together into one module which meant that as the
number of laws grew, so did the program size.  The early
version followed Kuhman's functionality and used the first
162 laws from his program.  This earlier version has been
cut off at 291 laws.  It has the advantage that the program
may be placed anyway on the DOS PATH and it will work.  The
current version, requires that the text file also appear on
the path or that a variable be set in the environment.

            This version was originally written to process
files of laws dumped from the University of Alberta
computer system.  MURPHY00.TXT as originally supplied contains
the same set of laws as the original PC version of MURPHY,
with many more additional laws tacked on as they were found.


	  MURPHY04.TXT is available on a separate disk.
It is a file of wisdom and aphorisms suitable for
installation on Local Area Networks and on machines used
by non-technical people.  The file is over 550,000 bytes
long and is available on request.  Send a re-useable
mailer and stamps (if in Canada) or money for return
postage.

      MURPHY05.TXT is a file of statements made by
people who really should have known better.  For example,
Einstein once said that no useful energy would ever
be extracted from the atom!

        In building the data files, I have gone to
considerable lengths to give credit where it is due.
Unlike some commercial publishers of Murphy's laws, I
have not simply ripped off someone else's work and then
put a copyright on it.  On the other hand, I have also
avoided the temptation to indulge in wholesale raiding
of authors who have created such aphorisms.  Some lists
completely rip off authors like Robert A. Heinlein.  I
took only two, gave credit, and recommend his books if
you want more.  Since the text files may be readily edited
by anyone, I am not responsible for their contents once the
files pass out of my immediate control.

        Parenthetically, may we note Lyall's law of reciprocal
copyright nastyness.  "Any publisher of Murphy's Laws who places
a copyright on his publication and attempts to obtain redress
in court for alleged violations will inevitably discover that he
has published at least one of the alleged violator's laws and is
in violation of the violator's copyright."  The first corollory
states: "Their lordships (judges to our American cousins) tend
to take a dim view of this!"

        Robert A. Heinlein was one of the leading figures
in American science fiction.  His aphorisms are in
"Time Enough For Love" as well as "The Notebooks of Lazarus
Long" as illustrated by D.F. Vassallo.
Any bookstore with a science fiction section will
carry Heinlein's books.

        Piet Hein has 5 books of Grooks that I know of,
although they may be out of print.  H.L. Mencken was a leading
iconoclast in the first half of the century.  His works
go in and out of print irregularly.  A master of the
shavian essay but lacking G.B. Shaw's searing
self-righteousness, Mencken made hamburger out of more
sacred cows than McDonalds ever will.

        Bob Edwards, who is extensively quoted, was a
Calgary journalist, crusader, moralist and drunkard of
the first rank.  His newspaper, the "Eye Opener", was so
outrageous that it was required reading all across Canada.
The "Society Column" of the Eye Opener was full of true
stories attributed to non-existent people and hilarious
stories about real people.  Edwards expected the reader to
sort it all out.  Consider the following "Social Note:"

     "The many friends of Peter F. Scratchley, the popular
oil broker, will be glad to learn that he is rapidly recovering
from a severe cold contracted while making a somewhat hasty
departure, via the window, from the elegant mansion of the
charming society matron, Mrs. J.T. Blinkbonny, at an early
hour last Saturday morning."
                         Summer Annual, 1922

     or:

     "Miss Maude de Vere of Drumheller arrived in the city Wednesday
and was run out of town the same night.  It is a pity that Miss
de Vere is not a racehorse, for she is very fast."
                         Eye Opener, August 20, 1921

      By today's standards, Edwards was a chauvinist and a bit of
a racist though he vented his intolerance on the English more
than anyone else.  In his day, this kind of racism was almost as
socially acceptable as anti-Americanism is among today's smart set.
Unlike them, Edwards was uncompromisingly honest, even about his
alcoholism and he campaigned tirelessly and occasionally successfully
against callous bureaucrats, dishonest politicians, and rapacious
corporations.

     One last "Society Note:"

     "Mr. Percy Redingot, who was recently caught in flagranto
deplunko with a careless dame, has gone east for his health.
Mr. Redingot has been suffering from his lungs for some time
past, but there is nothing wrong with his gall."
                              Eye Opener, Dec 6, 1919

        Murphy's military laws were collected over a
period of years from Canadian subalterns.

        David Gerrold is a science fiction writer and
wrote the script for the Star Trek episode "The Trouble With 
Tribbles".  His contributions came second hand.  I do not
have an original source.  The quotes in slightly modified
form have re-appeared in Gerrold's "War against the Chtorr"
trilogy.

        Dr. Edgar M. Horwood was the founder of geoprocessing
or computer based mapping.  He had a thoroughly tongue in cheek
attitude toward life in general and academia in particular.  Such
people deserve immortality.

        The quotations attributed to Stan Kelly-Bootle, Gershwin's
law, The Seven Catastrophes of Computing etc. are from:
        The Devil's DP Dictionary
        by Stan Kelly-Bootle
        McGraw-Hill Inc.
        ISBN 0-07-034022-6

        If you don't have a copy, get one.  Kelly-Bootle defines
sequential as "of or pertaining to just one damned thing after
another."

        Yup!

        Jon Bentley has two books which should be in every serious
programmer's library, Programming Pearls, and More Programming
Pearls.  They can be obtained from Addison-Wesley Publishing
Company.  Excerpts from the second book are included in
MURPHY00.TXT.

        Norman R. Augustine is president of Martin Marietta.  His
trenchant observations appear in "Augustine's Laws", a paperback
book.  I picked the included laws off a computer net.

		Spider Robinson is a science fiction author.  I have taken
a few quotes from "Off The Wall At Callahan's", ISBN 0-312-85661-X.
Robinson is a pun-aholic and is a master of the tales-told-in-a-bar
story.  If you like Murphy, you'll like Robinson.  His bar and brothel
stories are to be found in "Callahan's Crosstime Saloon", "Time Travellers
Strictly Cash", "Callahan's Secret", "Callahan and Company" (mid-1994),
"Callahan's Touch", "Callahan's Lady", and "Lady Slings The Booze"
(did I mention puns?).

		Recommended!

        Jon H. Myer contributed his nine laws in the April 1958
issue of Astounding Science Fiction.  Alma Hill's laws appeared
in the May 1958 issue.  H.B. Fyfe's contributions appeared in the
February 1958 issue.

        Kelvin Throop is a joint pseudonym used by the editors
and contributors to Analog Science Fact - Science Fiction.

        Wm. Brasington is a consultant in Houston, Texas.

		Several quotes were lifted from the ORACLE RDBMS Data
Administration Guide version 6.0 (October 1990).

		Frederick Winsors's "Space Child's Mother Goose" rhymes
were taken from the December 1956 edition of The Atlantic.  I
regret that the Murphy format does not permit the inclusion of
his masterpiece, "The Theory Jack Built."  Marian Parry's
whimsical drawings also cannot be reproduced.

        Laws attributed to Lyall or Charles J.C. Lyall are
original with yours truly and are copyright Charles J.C. Lyall.
Reproduction on a not for profit basis is permitted.  All other
rights are reserved.

        Murphy is normally included in the AUTOEXEC.BAT file
immediately before one or more lengthy startup procedures which
do not erase the screen.  This provides you with something to read
while the computer gets its house in order.

        "Serious people have few ideas.  People with ideas
         are never serious."
                                    Peter Valery

        Enjoy.

*/

/*	Other contributors include:
	J.T. "Mitch" Mitchell    Edmonton, Alberta
	J.A.E. Strong            Edmonton, Alberta
	Pat Strong               Edmonton, Alberta
	D.R.T. Reimer            Victoria, British Columbia
	Reg Jacklin              Calgary, Alberta
	Peter Johnston           St. Albert, Alberta
	Conrad Stenton           Midland, Ontario
	Graham Newton            Montreal, Quebec
	K.W. Tam                 Scarborough, Ontario
	William A. Brasington    Houston, Texas, USA
	W.A. Murphy (Really!)    St. John, New Brunswick
	Michael K. Smith         Dallas, Texas, USA
	Bev S.P. Bayer           Sydney, NSW, Australia
	Richard Patching         Calgary, Alberta
	Don Cayo                 Quispamsis, New Brunswick
	Richard E. Arndt         Sanford, Florida, USA
	William A. Porter        Palo Alto, California, USA
	L.J. Gaboury             Victoria, British Columbia
	R. Swanson               Austin, Texas, USA
	Don DeCuypere            Gloucester, Ontario
	David Gordon             Austin, Texas, USA
	Peter J. Otto            Stamford Con. USA
	Richard S. Mansfield     Camarillo, California, USA.
	Brian R. Timmins         Emsworth, Hants., U.K.
	Patricia Russell         Brighton, Ontario
	Pat Monteith             St. Albert, Alberta
	Arild Jensen             Keswick, Ontario
	Ingrid A.L. Brown        Brisbane, Qld., Australia
	John Hanlon              Chicago, Illinois, USA
	F.L. Ferreri             Maple Hts, Ohio, USA
	Dick Baker               Falls Church, Virginia, USA
	David Hoeben             Beltsville, Maryland, USA
	Jon Cereghino            Mountain View, California, USA
	Kent Anderson            Austin, Texas, USA
	Peter Skelton            Kingston, Ontario
	J.C. Himanga             Kingwood, Texas, USA
	Preston Petty            Camarillo, California, USA
	John F. Collins          San Francisco, California, USA
	Colin Meisch             Lausanne, Switzerland
	Rev. Brock Lupton        Oliver B.C.
	Dennis Kefallinos        Athens, Hellas (Greece)
	John Goodson             New Brunswick, New Jersey, USA
	Bill McKeown             Creston B.C.
	Ted Cloak                Albuqurque, New Mexico, USA
	Andrew Williams          Gravesend, Kent, UK
	Dev Dhindsa              Edmonton, Alberta
	Bill Harder              Edmonton, Alberta
	James S.B. Lyall         Leduc, Alberta
*/


char *help[] =
{
     "MURPHY looks for its text file first as MURPHY00.TXT in the",
     "current directory. If that fails, MURPHY looks for the variable",
     "MURPATH in the environment and uses its value as a full",
     "pathname. For example:",
     "   MURPATH = C:\SECRET\LAWS.TXT ",
     "If this fails, MURPHY will retrieve the PATH from the",
     "environment and search the PATH for MURPHY00.TXT",
     "See source listing for more documentation.",
     0
};

char *notice[]=
{
        " Author Charles J.C. Lyall ",
        "R.R. #2, Kingman, Alberta ",
        "Canada, T0B 2M0 ",
        "Phone/Fax (403) 662-2119 ",
        "CompuServe 70674,313 ",
        "This program is in the public domain and may be freely used ",
        "by anyone for their own amusement. It is not to be used for ",
        "profit without the author's permission. ",
        "<Version 3.1 -- February 12, 1991>",
        " Copyright (c) 1987, 1988, 1990, 1991 Charles J.C. Lyall ",
        0
};

/************************************************************
*                                                           *
*   Note:                                                   *
*   By default, this routine is to be compiled under        *
*   MicroSoft C 5.0. If you wish to use Borland's TURBO C   *
*   to compile it, then you must uncomment the line         *
*   "#define TURBOC"                                        *
*                                                           *
************************************************************/

/* #define TURBOC  */                                 /*3.02*/

#include <io.h>
#include <time.h>
#include <string.h>
#include <math.h>
#include <stdio.h>
#include <fcntl.h>
#include <conio.h>

#ifndef TURBOC

#include <sys\types.h>

#endif
#include <sys\stat.h>

char buffer[2048];                   /* 3.1                  */
unsigned int one = 1;
unsigned int bytesread;
int fhl;                             /* file handle          */
int i;
char ipath[] = "MURPHY00.TXT";       /* data file            */
long int filelen, filepos, ltime;
long int minustwo = -2;             /* for backing up in file */
char hold;                            /* hold read char here  */
char *here = &hold;                   /* pointer to same      */

#include <stdlib.h>
#define NULL 0
#define GARDEN_PATH "MURPATH"

static char path_name[64];  /* assemble the path name here    */
static char *name_end;
static char *path_ptr;
static char *str_ptr;


/***************************display_help*************************/
			 
void display_help()
{
     auto int i = 0;
     while(help[i] != 0)
          printf("%s\n", help[i++]);

}

/***************************search_path**************************/

int search_path(filename, flags)
char *filename;
int flags;
{
     if((path_ptr = getenv("PATH")) == NULL)
           return (NULL);   /* no path hence no find on path  */
     else
     {
          do           /* this has to work at least one time  */
          {
               name_end = path_name;
               do
               {
                    *name_end++ = *path_ptr++;
               }
               while(*path_ptr != '\0' && *path_ptr != ';');
               if( *(path_ptr - 1) != '\\')
                    *name_end++ = '\\';
               strcpy(name_end, filename);
               if((fhl = open(path_name, flags)) != -1)
                    return (fhl);
               if(*path_ptr++ == '\0')
                    return (NULL);
          }while(1);
     }
}


/******************************main*****************************/

main(argc)
int argc;
{
     if(argc > 1)
     {
          display_help();
          exit (0);
     }
     if((fhl = open(ipath, O_RDONLY | O_BINARY)) == -1)
     {
          if((str_ptr = getenv(GARDEN_PATH)) == NULL)
          {
               if((search_path(ipath, O_RDONLY | O_BINARY)) == NULL)
               {
                    printf("Failed to find text file. \n");
                    printf("Run MURPHY ? \n");
                    exit(1);
               }
          }
          else
          {
               if((fhl = open(str_ptr, O_RDONLY | O_BINARY)) == -1)
               {
                    perror("Found text in path but failed to open it");
                    printf("\nIncorrect environment variable \n");
                    exit(1);
               }
          }
     }

     if((filelen = filelength(fhl)) == -1L)
     {
          fprintf(stderr, "Failed to get length of text file \n");
          exit(2);
     }
     time(&ltime);   /* get time in seconds */

/*  a wee note about an otherwise senseless piece of code
 *
 *  ltime is a very large number, being the number of seconds
 *  since January 1, 1970. Indeed, it will overflow into the
 *  sign bit rather soon.  If one simply takes the time in
 *  seconds mod the filelength as the pointer into the file,
 *  then one has to wait up to a minute or more for enough
 *  seconds (characters in the file) to pass so that the
 *  printed law will change. If one simply multiplies the
 *  system time in seconds by a suitably large number, one will
 *  certainly have an overflow. Elderly programmers like
 *  yours truly have a well developed fear of overflows.
 *  Hence the following code which goes all the way around
 *  Robin Hood's barn to avoid the overflow. Then it corrects
 *  it anyway.
 *
 */

     filepos = ltime % filelen;        /* time mod filelength */
     filepos *= 257;   /*3.01*/        /* multiply by a prime */
     if((filepos = filepos % filelen) < 0)  /* can't be, eh? */
          filepos = 0 - filepos;      /* correct overflow ! */

/* clear up the boundary value problems namely    3.01      */
/*  - we can't back up from the zeroth char of the file     */
/*  - we might be on a newline past the last "@" in the file*/

     if((filepos + 3) > filelen)        /*3.01*/
         filepos -= 3;
     else if(filepos < 3L)
        filepos += 3;

     lseek(fhl, filepos, SEEK_SET);

/*  Now back up to the previous at symbol                 */

          do
          {
               filepos = lseek(fhl, minustwo, SEEK_CUR);
               if((bytesread = read(fhl, here, one)) == -1)
                    {
                     fprintf(stderr, "Read of one char failed");
                     exit(3);
                    }
           }while(hold != '@');

/*  Now point to the first character past the at symbol */

     bytesread = read(fhl, here, one);

/*  3.1 code to read into buffer, find end of law */

/*
**  This complication is thrown in because the IBM/Microsoft
**  LAN is a bit daft about character I/O when MURPHY runs
**  on the LAN workstations.  This speeds things up a tad.
**
**  Other than that, it has nothing to recommend it
*/
     do
     {
          buffer[i++] = hold;              /* print the char */
          bytesread = read(fhl, here, one); /* read the next */
          if(hold == 9)                         /*tab*/
          {
               hold = 32;                      /*space*/
               buffer[i++] = hold;         /* print 4 spaces */
               buffer[i++] = hold;         /* not 3          */
               buffer[i++] = hold;         /* FOUR           */
          }
     }while((hold != '@') && (bytesread == 1));
	 buffer[i] = '\0';
	 printf("%s",buffer);
}
