/* ONE_ON_NINE.C - From page 75 of Volume 4, Number 2, the February    */
/* 1987 issue of Computer Language. The article is by Jean-Pierre      */
/* Schachter and is entitled DATA STRUCTURES AND SCROLLING.            */
/*                                                                     */
/* Usage:   A>one_on_9 <RET>                                           */
/***********************************************************************/

#define REQUEST (request = get_scan())
#define FINISHED 1
#define MOVE_LEFT case 75
#define MOVE_RIGHT case 77
#define MOVE_UP case 72
#define MOVE_DOWN case 80
#define RIGHT --pb
#define LEFT ++pb
#define DOWN pb -= 240
#define UP pb += 240
#define TO_CENTER pb += 6080
#define IS ==
#define IS_NOT !=
#define SHOULD switch
#define BE
#define BEEP 7
#define CLRSCR puts(clrscr)

#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <conio.h>
#include <dos.h>

char *pb, *line[25];

main()
{
static char clrscr[] = { 27, "[2J\0" };

   pb = memset(malloc (18000), ' ', 18000);
   CLRSCR;
   move_it(TO_CENTER);        /* CENTERS DISPLAY ON V. SCR.     */
   mess_it();                 /* WRITES JUNK TO V. SCR.         */
   show_it();                 /* DISPLAYS THE V. SCREEN         */
   scrl_it();                 /* SCROLLS THE DISPLAY            */
   CLRSCR;
   exit(0);
}

/* ================== Function scrl_it() =======================*/

scrl_it()      /* THE READ AND INTERRUPT LOOP */
{
char request = 0, income();

   while (REQUEST IS_NOT FINISHED) {
      SHOULD (request) BE {
         MOVE_RIGHT:
            move_it(RIGHT);
            show_it();
            break;
         MOVE_LEFT:
            move_it(LEFT);
            show_it();
            break;
         MOVE_UP:
            move_it(UP);
            show_it();
            break;
         MOVE_DOWN:
            move_it(DOWN);
            show_it();
            break;
         default:
            putchar(7);
            break;
      }
   }
}

/* ====================== Function move_it() ========================= */

move_it(start)             /* SHIFTS THE VIRTUAL SCREEN */
struct gapl {
   char space[240];
} *start;
{
register int i = -1;

   while (i++ < 24)
      line[i] = (char *)start++;
}

/* ====================== Function mess_it() ==========================*/

mess_it()                  /* INITIALIZES THE VIRTUAL SCREEN */
{
register int k = -1, l;
char *v;

   while (k++ < 24) {
      v = line[k];
      for (l = 0; l < 80; l++)
         *v++ = 65 + k + l;
   }
}

/* ====================== Function show_it() ========================= */

show_it()                  /* THE SWAP TO SCREEN MEMORY */
{
register int d, e = -1;
struct TWO_STEP {
   char letter[2];
} far *next;
struct NEXTLIN {
   struct TWO_STEP ligne[80];
} far *lin_head = (struct NEXTLIN far *)(0xB000L << 16);

   while (e++ < 24) {
      next = (struct TWO_STEP far *) lin_head++;
      for (d = 0; d < 80; d++)
         next++->letter[0] = *(line[e] + d);
   }
}

/* ====================== Function get_scan() ======================== */

get_scan()      /* NON-ECHO NON-CR INPUT RETURNS SCAN CODE, = */
{                    /* NOT ASCII = USE utreg.h.al FOR ASCII ===== */
union REGS inreg, utreg;

   inreg.h.ah = 0;
   int86 (0x16, &inreg, &utreg);    /* KEYBOARD INT 0x16 */
   return (utreg.h.ah);
}

