/*	dos.h	*/

#ifndef __DOS_H
#define __DOS_H

extern short _doserrno;

struct WORDREGS {
	unsigned int	ax, bx, cx, dx, si, di, cflag, flags;
	};

struct BYTEREGS {
	unsigned char	al, ah, bl, bh, cl, ch, dl, dh;
	};

union	REGS	{
	struct	WORDREGS x;
	struct	BYTEREGS h;
	};

struct	SREGS	{
	unsigned int	es;
	unsigned int	cs;
	unsigned int	ss;
	unsigned int	ds;
	};

struct	REGPACK {
	unsigned	r_ax, r_bx, r_cx, r_dx;
	unsigned	r_bp, r_si, r_di, r_ds, r_es, r_flags;
	};

int	bdos(/* int, unsigned, unsigned */);
int	bdosptr(/* int, void*, unsigned */);
int	int86(/* int, union REGS*, union REGS* */);
int	int86x(/* int, union REGS*, union REGS*, struct SREGS* */);
int	intdos(/* union REGS*, union REGS* */);
int	intdosx(/* union REGS*, union REGS*, struct SREGS* */);
void segread(/* struct SREGS* */);
void intr(/* int, struct REGPACK* */);
