/********************************************************************
		PopDATE - INITIALIZATION CODE
	     (c) Copyright 1992 by Omega Point, Inc.
		   Author: Ratko V. Tomic
*********************************************************************/

#include "cr.h"
#include "lm.h"


#define	STK_SZ (150)
word isr_stk[STK_SZ+1];		/* Resident stack */
extern word init_data_end;


extern word hk_list[];	/* Hotkey list, defined in PDID.C */
extern service();	/* Hotkey service in PD.C */

/************************************************************************
  Signon messages are defined in the disposable-data module PDID.C
*************************************************************************/

extern char signon_scr[];    /* Signon message */
extern char first_msg[];     /* First signon message */
extern byte hello_atr[],mono_atr[];
extern char cal_box[];	     /* Calendar pop-up box */
extern char catc[],catm[];   /* Attributes for calendar box */
extern char txtm[];	     /* TSR text attributes (mono)  */
extern char cal_atr[];	     /* Active TSR attributes (default=color) */
extern char already[];       /* Already loaded message */
extern char unl_ok[];  	     /* TSR was unloaded message */
extern char unl_err[];	     /* Cannot unload message (not loaded last) */
extern int use_lim;	     /* Set to 0 if no move to LIM (/E switch)  */
extern int quiet;	     /* No waiting for a key on signon */

/************************************************************************
	VARIABLES USED AT RESIDENT TIME
*************************************************************************/

extern word *buf;	/* Buffer for screen save */
extern int wdx,wdy;	/* Window sizes */
extern int x0,y0;	/* Corner position for calendar */
extern int mx,my;	/* Start for day of month cursor */
extern int rvx,rvy;	/* Last highlighted day of month */

/*********************************************************************
		DISPLAY SIGNON SCREENS
**********************************************************************/


signon()
{ byte *s=hello_atr;
   if (vid_mode==7)
     {
     s=mono_atr;
     }

   if (!quiet)
     {
     save_crs(); kil_crs();
     crs_x=crs_y=0; vid_atr=7;
     fil_scr('');
     crs_x=5; crs_y=1;
     dspf(first_msg,s); 
     pckey();
     restore_crs();
     }

   vid_atr=7; clr_scr();
   crs_x=26; crs_y=4;
   dspf(signon_scr,s);

   crs_x=0; crs_y=scr_len-1;
   vid_atr=7;
   dsp_hor(0x20,scr_width);
   crs_x=0; crs_y--; mv_crs();
}

/*********************************************************************
	  CONSTRUCT CALENDAR SCREEN 

 The code below builds calendar screen in a buffer which is used at
 resident time by swap_blk() to put up the calendar and save the
 foreground screen. To build the screen we use dspf() in a special
 way: instead of displaying into video RAM we force it to "display"
 in regular RAM by substituting temporarily the vid_seg variable.
*********************************************************************/

bld_cal()
{ char *s;
  word w,old_vseg;		/* Used to save old video segment */

    if (color)			/* Select screen colors    */
      s=catc;
    else			/* Select mono attributes */
      {
      s=catm;	
      mem_cp(txtm,cal_atr,6);
      }

    buf=(word*)_heap;		/* Space for screen buffer */
    old_vseg=vid_seg;		/* Save real video segment */
    w=((word)buf+15)>>4;	/* Align to next paragraph */
    vid_seg=_cdata+w;		/* Create vid_seg in memory */
    
    crs_x=crs_y=0;
    dspf(cal_box,s);		/* Display quickly calendar */
    wdx=crs_x; wdy=crs_y+1;
    rvx=mx=x0+3;		/* Cursor for days of month */
    rvy=my=y0+1;
    crs_x=crs_y=0;
    get_blk(wdx,wdy,buf);	/* Compact the image */
    _heap+=wdx*wdy*2;		/* Reserve space on heap */
    vid_seg=old_vseg;		/* Restore video segment */
}

/*****************************************************
	LOAD TIME MAIN ENTRY
******************************************************/

main()
{ char *s;
  int mtl=MOVE_BOTH;
  
     s=cmd_line;		/* Command line pinter */
     up_case(s);
     if (str_pos('H',s))	/* Switch /H - no check of high memory */
       parent_data=0;		/* this skips himem scan for signature */

     if (str_pos('M',s))	/* Switch /M for mono color set */
       color=0;

     if (str_pos('E',s))	/* Disable LIM use if /E present */
     	use_lim=0;
     else if (is_stealth())
	mtl=MOVE_CODE;
     
     if (str_pos('Q',s))	/* Quiet */
       quiet=1;

     if (second_load())		/* Check if the TSR already loaded. */
       {
       if (str_pos('R',s)||str_pos('U',s))  /* Unload TSR	  */
         {
	 if (remove_tsr())		/* Remove TSR from memory */
	   dspf(unl_ok);		/* Inform about unloading */
	 else
	   dspf(unl_err);		/* Couldn't unload TSR due to  */
	 				/* another TSR loaded later    */
         }
       else dspf(already);		/* Otherwise show Help message */
       mv_crs();			/* Reposition real cursor */
       return(1);			/* Exit with errorlevel 1 */
       }
     bld_cal();				/* Construct calendar screen */

/** DISPLAY SIGNON SCREEN **/

     signon();

/** ENABLE TSR MODE **/

  stay_resident(isr_stk,STK_SZ*2); /* Define TSR stack, TSR on return */
  idata_end=&init_data_end;	   /* Enable init data disposal       */
  icode_beg=(fp)signon;		   /* Specify disposable code	      */

  install_hk(hk_list,service,2*STK_SZ,3);  /* Install hot-keys. */
  if (use_lim)
     move_to_lim(1,1,mtl);		   /*  Move TSR to LIM if available */

  return(0);			/* Set DOS errorlevel to 0 */
}
