#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <mem.h>

#include "queue.h"

void Usage (void);

struct FieldEntry {
	int Begin;
	int Len;
	};

 void
main (int argc, char *argv[]) {
	FILE *F1;
	char FileName[65];
	char *String;
	char Temp[100];
	char *Ptr, *p1, *p2;
	long Count = 0;
	long j;
	int i, k;
	int Random = 0;
	int RecLen = 10;
	QUE_DEF Fields;
	QUE_ENTRY *t;
	struct FieldEntry *f;
	char Alphas[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

	if (argc < 2) Usage();

	strcpy(FileName, "test.dat");

	InitQueue(&Fields);

	for (i=1; i < argc; i++) {
		if (argv[i][0] != '-') continue;
		switch ( tolower(argv[i][1]) ) {
			case 'r':
				Random = 1;
				break;
			case 'l':
				if ( !isdigit(argv[i][2]) ) {
					fprintf(stderr, "The '-l' option requires a length.\n");
					exit(1);
					}
				if ( (RecLen = atoi(&argv[i][2])) == 0 ) {
					fprintf(stderr, "Invalid length: %s\n", argv[i]);
					exit(1);
					}
				break;
			case 'f':
				strcpy(FileName, &argv[i][2]);
				break;
			default:
				fprintf(stderr, "Invalid option: %s\n", argv[i]);
				Usage();
			}
		}

	for (i=1; i < argc; i++) {
		if (argv[i][0] == '-') continue;
		p1 = argv[i];
		if ( (Count == 0) && (strspn(p1, "0123456789") == strlen(p1)) ) {
			Count = strtol(argv[i], &Ptr, 10);
			if (*Ptr != '\0') {
				fprintf(stderr, "Invalid count: %s\n", argv[i]);
				exit(1);
				}
			}
		else {
			p2 = &p1[strspn(p1, "0123456789")];
			if ( (f = malloc(sizeof(struct FieldEntry))) == NULL) {
				fprintf(stderr, "Insufficient memory for field entry.\n");
				exit(1);
				}
			f->Begin = atoi(p1) - 1;
			if (*p2 == ':') f->Len = atoi(++p2);
			else if (*p2 == '-') f->Len = atoi(++p2) - f->Begin;
			else {
				fprintf(stderr, "Invalid Field specification: %s\n", argv[i]);
				exit(2);
				}
			Enque(&Fields, f);
			}
		}

	if ( (String = malloc(RecLen + 1)) == NULL ) {
		fprintf(stderr, "Insufficient memory!\n");
		exit(1);
		}
	memset(String, '-', RecLen);
	String[RecLen] = '\0';

	if ( (F1 = fopen(FileName, "w")) == NULL ) {
		fprintf(stderr, "I can't create output file: %s", FileName);
		perror("");
		exit(1);
		}

	for (j=0; j < Count; j++) {
		if (Fields.Count == 0) {
			if (Random) sprintf(String, "%09d", rand() );
			else sprintf(String, "%09.9ld", j);
			if (RecLen > 9) String[9] = '-';
			}
		else for (k=0, t=Fields.Head; t != NULL; t = t->Next, k++) {
			f = t->Body;
			if (k & 0x01) {
				if (Random) sprintf(Temp, "%0*d", f->Len, rand() );
				else sprintf(Temp, "%0*.*ld", f->Len, f->Len, j);
				strncpy(&String[f->Begin], Temp, f->Len);
				}
			else {
				if (Random) setmem(Temp, f->Len, Alphas[rand() % 26]);
				else setmem(Temp, f->Len, Alphas[j % 26]);
				strncpy(&String[f->Begin], Temp, f->Len);
				}
			}
		if ( (j) && ( (j % 1000) == 0) ) printf(".");
		fprintf(F1, "%s\n", String);
		}

	fclose(F1);
	}


 void
Usage (void) {
	fprintf(stderr, "USAGE: bldtst [-r] [-f file_name] count\n");
	exit(1);
	}
