#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <alloc.h>

#include "queue.h"

#define _32K 32768U

static FILE *kin, *kout;
static QUE_DEF *K_Keys;
static char K_OutName[65] = "";
static char KeyName[65];
static int K_RecLen;
static char *K_Buffer;
static long where;

struct KeyEntry {
	int             Begin;
	int             Len;
	char            Order;
	char            Case;
	char            Type;
	};
extern char IntPath[65];

 void
GetKeys (void) {
	extern FILE *fin, *fout;
	extern QUE_DEF *Keys;
	extern int RecLen;
	extern char *Buffer;
	extern char OutName[65];
	extern unsigned long lnno;
	extern unsigned long EndAdr;
	unsigned long BufSize;

	QUE_ENTRY *t;
	struct KeyEntry *t1, *t2;
	int Begin = 8;

	kin = fin; kout = fout;
	K_Keys = Keys;
	strcpy(K_OutName, OutName);
	strcpy(KeyName, IntPath);
	if ( (KeyName[0] != '\0') && (KeyName[strlen(KeyName)-1] != '\\') )
		strcat(KeyName, "\\");
	strcat(KeyName, "SORT.K$$");
	strcpy(OutName, KeyName);
	K_RecLen = RecLen;
	Keys = malloc(sizeof(QUE_DEF));
	InitQueue(Keys);
	BufSize = (coreleft() - 2048) / 2;
	if (BufSize > _32K) setvbuf(kin, NULL, _IOFBF, _32K);
	else setvbuf(kin, NULL, _IOFBF, (size_t) BufSize);


	for (t=K_Keys->Head; t != NULL; t = t->Next) {
		t1 = (struct KeyEntry *) t->Body;
		t2 = malloc(sizeof(struct KeyEntry));
		t2->Begin = Begin;
		t2->Len = t1->Len;
		Begin += t1->Len;
		t2->Order = t1->Order;
		t2->Case = t1->Case;
		t2->Type = t1->Type;
		Enque(Keys, t2);
		}

	if ( (K_Buffer = malloc(Begin + 1)) == NULL ) {
		fprintf(stderr, "Insufficient memory for Key file buffer.\n");
		exit(14);
		}

	if ( (fin = fopen(KeyName, "w")) == NULL ) {
		fprintf(stderr, "I can't create key file: %s", KeyName);
		perror("");
		exit(13);
		}
	if (BufSize > _32K) setvbuf(fin, NULL, _IOFBF, _32K);
	else setvbuf(fin, NULL, _IOFBF, (size_t) BufSize);

	while (where = ftell(kin), fgets(Buffer, RecLen + 2, kin) != NULL ) {
		lnno++;
		if (Buffer[strlen(Buffer) - 1] != '\n') {
			fprintf(stderr, "Record #%lu exceeds maximum length %d\n",
					lnno, RecLen);
			exit(4);
			}
		sprintf(K_Buffer, "%07ld", where);
		K_Buffer[7] = '|';
		K_Buffer[8] = '\0';
		for (t=K_Keys->Head; t != NULL; t = t->Next) {
			t1 = (struct KeyEntry *) t->Body;
			strncat(K_Buffer, &Buffer[t1->Begin], t1->Len);
			}
		errno = 0;
		fprintf(fin, "%s\n", K_Buffer);
		if (errno) {
			perror("I/O error on key file");
			exit(8);
			}
		}
	lnno = 0;

	fclose(kin);
	fclose(fin);
	RecLen = Begin;

	if ( (fin = fopen(KeyName, "r")) == NULL ) {
		fprintf(stderr, "Major system failure!!\n");
		exit(20);
		}
	fseek(fin, 0, SEEK_END);
	EndAdr = ftell(fin);
	fseek(fin, 0,SEEK_SET);

	}

 void
PutKeys (void) {
	extern FILE *fin, *fout;
	extern int RecLen;
	extern char *Buffer;
	extern char InputName[65];

	FILE *F1, *F2;
	char *p;
	long BufSize;

	BufSize = coreleft() / 2;
	if ( (F2 = fopen(K_OutName, "w")) == NULL ) {
		fprintf(stderr, "I can't create output file: %s\n", K_OutName);
		exit(7);
		}
	if (BufSize > _32K) setvbuf(F2, NULL, _IOFBF, _32K);
	else setvbuf(F2, NULL, _IOFBF, (size_t) BufSize);

	if ( (kin = fopen(InputName, "r")) == NULL ) {
		fprintf(stderr, "I can't find input file: %s", InputName);
		perror("");
		exit(2);
		}

	if ( (F1 = fopen(KeyName, "r")) == NULL ) {
		fprintf(stderr, "%s\n", KeyName);
		fprintf(stderr, "Major error! %d", errno);
		perror("");
		exit(11);
		}
	if (BufSize > _32K) setvbuf(F1, NULL, _IOFBF, _32K);
	else setvbuf(F2, NULL, _IOFBF, (size_t) BufSize);

	while (fgets(K_Buffer, RecLen + 2, F1) != NULL ) {
		where = strtol(K_Buffer, &p, 10);
		p = strchr(K_Buffer, '|') + 1;
		errno = 0;
		fseek(kin, where, SEEK_SET);
		fgets(Buffer, K_RecLen + 2, kin);
		if (errno) {
			perror("I/O error on input file.");
			exit(8);
			}
		fputs(Buffer, F2);
		if (errno) {
			perror("I/O error on output file.");
			exit(8);
			}
		}

	fclose(kin);
	fclose(fout);
	fclose(F1);
	unlink("SORT.K$$");
	}
