/* Pielogo.c     Copyright (c) 1992 Kevin Stokes, Pie in the Sky Software */

#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include <string.h>
#include "lprgraf.h"
#include "psgraf.h"
#define MAXLINE 512

#define NCOL  20
#define NROW  10
#define SCRXMIN 40
#define SCRXMAX 560
#define SCRXSZ 520
#define SCRYMIN 40
#define SCRYMAX 440
#define SCRYSZ 400
#define SCRBXMAX 639
#define SCRBYMAX 479

#define PRNXMIN 20
#define PRNXMAX 700
#define PRNXSZ 680
#define PRNYMIN 20
#define PRNYMAX 700
#define PRNYSZ 680
#define	PRNBXMAX 719
#define	PRNBYMAX 719

#define PSXMIN 20
#define PSXMAX 700
#define PSXSZ 680
#define PSYMIN 20
#define PSYMAX 700
#define PSYSZ 680
#define	PSBXMAX 719
#define	PSBYMAX 719

#define LOWASCII 0x40
#define LOWCHAR 93

int	XMIN,XMAX,YMIN,YMAX,XSZ,YSZ,BXMAX,BYMAX;

extern int EGALINE(); 
extern int GRMODE();
extern int TXMODE();


struct fontchar {
 int lglyph;
 int lnpair;
 char *textptr;
 };

struct fontchar thefont[1024];

int odevice,lastspace,thisspace,prospace;

void drawstring();
void drawstringrad();
void drawchar();
void bermsg();

halfcircle(centerx,centery,radius,n,thickness)
int centerx,centery,radius,n,thickness;
{
	int	i,iargx1,iargy1,iargx2,iargy2,ii;
	float	theta,fradius,thckdelrad,phasenoise;
        for(ii=0;ii< thickness*3;ii++)
        {
        thckdelrad=(float) thickness*(float) ii/24.-(float)thickness/8.;
	fradius=radius+thckdelrad;
	phasenoise=(float) rand()*3.14159/75./32767.;
	iargx1=centerx+(int) fradius;
	iargy1=centery;
	for(i=0;i<n;i++)
            {
	      theta=( (float) (i+1)*3.14159/(float) n)+phasenoise;
	      if(theta > 3.14159) theta=3.14159;
	      iargx2=centerx+(int) (fradius*cos(theta));
	      iargy2=centery-(int) (fradius*sin(theta));
	      if(odevice == 0)
		 { EGALINE(iargx1,iargy1,iargx2,iargy2,15);
		   EGALINE(iargx1+1,iargy1,iargx2+1,iargy2,15); }
	        if(odevice == 1) lprdrawline(iargx1,iargy1,iargx2,iargy2,15);
	        if(odevice == 2) psline(iargx1,iargy1,iargx2,iargy2);
	      iargx1=iargx2;
	      iargy1=iargy2;
            }	
       }
}


circle(centerx,centery,radius,n,thickness)
int centerx,centery,radius,n,thickness;
{
	int	i,iargx1,iargy1,iargx2,iargy2,ii;
	float	theta,fradius,thckdelrad,phasenoise;
        for(ii=0;ii< thickness*3;ii++)
        {
        thckdelrad=(float) thickness*(float) ii/24.-(float)thickness/8.;
	fradius=radius+thckdelrad;
	phasenoise=(float) rand()*3.14159/7./32767.;
	iargx1=centerx+(int) fradius;
	iargy1=centery;
	for(i=0;i<n;i++)
            {
	      theta=( (float) (i+1)*2.*3.14159/(float) n)+phasenoise;
	      iargx2=centerx+(int) (fradius*cos(theta));
	      iargy2=centery-(int) (fradius*sin(theta));
	      if(odevice == 0)
		 { EGALINE(iargx1,iargy1,iargx2,iargy2,15);
		   EGALINE(iargx1+1,iargy1,iargx2+1,iargy2,15); }
	        if(odevice == 1) lprdrawline(iargx1,iargy1,iargx2,iargy2);
	        if(odevice == 2) psline(iargx1,iargy1,iargx2,iargy2);
	      iargx1=iargx2;
	      iargy1=iargy2;
            }	
       }
}

horizline(iargx1,iargx2,iargy1,thickness)
	int	iargx1,iargy1,iargx2,thickness;
{
	int	i,ii,iargy2,ithick;
	ithick=thickness|1;
	iargy2=iargy1;
        for(ii=0;ii< ithick;ii++)
        {
	if(odevice==0)
          EGALINE(iargx1,iargy1+ii-ithick/2,iargx2,iargy2+ii-ithick/2,15);
	if(odevice==1)
          lprdrawline(iargx1,iargy1+ii-ithick/2,iargx2,iargy2+ii-ithick/2);
	if(odevice==2)
          psline(iargx1,iargy1+ii-ithick/2,iargx2,iargy2+ii-ithick/2);
        }
	
}

main(int argc, char *argv[])

{
	int i,ii,nch,npair,glyph,linen,irow,icol;
	FILE *inputf;
	char aline[MAXLINE];
	char glyphs[10];
	char npairs[10];
/*        char *lineptr[1024];
	int  linenpair[1024],lineglyph[1024]; */
	int nchars;
	char psname[80];
	
/* printf("Command line: "); */
/* for (i=1;i < argc; i++) printf("%s ",argv[i]); */

inputf = fopen("shersh.oc3","r");
if (inputf == NULL) {
  printf("Could not open hersh.oc3 for reading\n");
  exit(0); }
odevice=-1;		/* default is screen output */
if (strcmpi(argv[1],"printer") == 0) odevice=1;
if (strcmpi(argv[1],"screen") == 0) odevice=0;
if (strcmpi(argv[1],"postscript") == 0) odevice=2;
if(odevice==-1) {
  printf("\nUsage :");
  printf("\n");
  printf("\npielogo screen                   Outputs logo to VGA screen");
  printf("\npielogo printer                  Outputs logo to Panasonic 1123/4 printer");
  printf("\npielogo postscript output.ps     Outputs to postscript file output.ps");
  printf("\n");
  exit(0);
  }
if (odevice == 0)
{  XMAX=SCRXMAX;
  YMAX=SCRYMAX;
  XMIN=SCRXMIN;
  YMIN=SCRYMIN;
  XSZ=SCRXSZ;
  YSZ=SCRYSZ;
  BXMAX=SCRBXMAX;
  BYMAX=SCRBYMAX; }
if (odevice == 1)
{  XMAX=PRNXMAX;
  YMAX=PRNYMAX;
  XMIN=PRNXMIN;
  YMIN=PRNYMIN;
  XSZ=PRNXSZ;
  YSZ=PRNYSZ;
  BXMAX=PRNBXMAX;
  BYMAX=PRNBYMAX; }
if (odevice == 2)
{  XMAX=PSXMAX;
  YMAX=PSYMAX;
  XMIN=PSXMIN;
  YMIN=PSYMIN;
  XSZ=PSXSZ;
  YSZ=PSYSZ;
  BXMAX=PSBXMAX;
  BYMAX=PSBYMAX; 
strcpy(psname,argv[2]);		/* put ps output filename in string */
}

linen=0;
nchars=0;
prospace=0;
while(fgets(aline,MAXLINE,inputf) != NULL) {
  linen++;
  if( strlen(aline) > 0) {
   if( aline[0] == ' ' )  {
    strncpy(glyphs,aline,5);
    glyphs[5]='\0';
    glyph=strtol(glyphs,NULL,10);
    strncpy(npairs,&aline[5],3);
    npairs[3]='\0';
    npair=strtol(npairs,NULL,10);
    nch=2*npair+8;
    aline[strlen(aline)-1] = '\0' ;
    while(nch != strlen(aline)) {
      fgets(&aline[strlen(aline)],MAXLINE-strlen(aline),inputf);
      linen++;
      aline[strlen(aline)-1] = '\0' ;
      if(strlen(aline) >= MAXLINE-2) { printf("\n Error in font file : %s \n",
        "shersh.oc3");
        printf("%d chars expected, %d chars found in line %d \n",nch,
        strlen(aline),linen);
        exit(0); }
    }
    thefont[nchars].textptr=calloc(nch+2,1);
    if(thefont[nchars].textptr == NULL) { printf("out of mem \n"); exit(0); }
    strcpy(thefont[nchars].textptr,&aline[8]);
    thefont[nchars].lnpair=npair;
    thefont[nchars].lglyph=glyph;
    nchars++;
      }
    }
  }
/* */
if(odevice==0) {
    GRMODE(); }
if(odevice==1) {
   lprinit(); }
if(odevice==2) {
   psinit(psname); }
        horizline(XMIN+1,XMAX-1,YSZ/2+YSZ/4+YMIN,4);
	drawchar(&thefont[93],XSZ/9+XMIN,YSZ/2+YSZ/4+YMIN-23,2.0,2.0,0.);
	drawchar(&thefont[93],XSZ/6+XMIN,YSZ/2+YSZ/4+YMIN-23,2.0,2.0,0.);
/*
       halfcircle(XSZ/2+XMIN,YSZ/2+YMIN,XSZ/6,40,10);
	drawstring("The quick brown fox",XSZ/2+XMIN,YSZ/2+YSZ/6+YMIN,.8,.8,18); 
*/
	drawstringrad(
"Pie in the Sky Software",XSZ/2+XSZ/4+XMIN,YSZ/2-YSZ/4+YMIN,
.97,.97,9,64.,2.9); 
if(odevice == 0) {
	getch();
            TXMODE();
}

if(odevice == 1) 
{
    lprprint();
    lpremit(12);
}
if(odevice == 2) 
{
    psclose();
}
}

void drawstring(stringptr,ixc,iyc,fsfx,fsfy,lsize)
char *stringptr;
int ixc,iyc,lsize;
float fsfx,fsfy;
{
char *mystrptr;
int	ixoff,charindex,i;
	mystrptr=stringptr;
	prospace=1;
	lastspace=0;
	ixoff=0;
/*	while(*mystrptr != "\0")  */
	for(i=0;i<strlen(stringptr);i++)
           {

              if(*mystrptr <= 0x5a) 
                  { charindex=(int) *mystrptr - LOWASCII +LOWCHAR ;
                    if(charindex < LOWCHAR) charindex=-1; }
              if(*mystrptr >= 0x61) 
                  { charindex=(int) *mystrptr - (int) 0x61+120+26;
                    if(charindex > 26+120+26 ) charindex=-1; }
	      if(*mystrptr == 0x20)
                { ixoff=ixoff+lsize;  lastspace=0; thisspace=0;}
              mystrptr++;
/*	      printf("(%d %d)",(int) *mystrptr - LOWASCII ,charindex); */
              if(charindex > 0) {
                drawchar(&thefont[charindex],ixc+ixoff,iyc,fsfx,fsfy,0.);
	        ixoff=ixoff+(int) ( (float) (lastspace+thisspace)/fsfx);
                ixoff=ixoff+lsize/5;
              }

           }
prospace=0;
lastspace=0;
}          

void drawstringrad(stringptr,ixc,iyc,fsfx,fsfy,lsize,lradius,thetastrt)
char *stringptr;
int ixc,iyc,lsize;
float fsfx,fsfy,lradius,thetastrt;
{
char *mystrptr;
int	ixoff,charindex,i,ixchar,iychar;
float	theta,thetaprime;
	mystrptr=stringptr;
	prospace=0;
	lastspace=0;
	theta=thetastrt;
	ixoff=0;
/*	while(*mystrptr != "\0")  */
	for(i=0;i<strlen(stringptr);i++)
           {

              if(*mystrptr <= 0x5a) 
                  { charindex=(int) *mystrptr - LOWASCII +LOWCHAR ;
                    if(charindex < LOWCHAR) charindex=-1; }
              if(*mystrptr >= 0x61) 
                  { charindex=(int) *mystrptr - (int) 0x61+120+26;
                    if(charindex > 26+120+26 ) charindex=-1; }
              ixoff=0;
	      if(*mystrptr == 0x20)
                { ixoff=lsize; lastspace=0; thisspace=0;
                ixoff=ixoff+lsize/4;
                theta=theta+(float) ixoff/lradius; }

              mystrptr++;
              if(charindex > 0) {
		thisspace='R'-(thefont[charindex].textptr)[0]; 
                theta=theta+(float) thisspace*fsfx/lradius;
		ixchar=ixc+(int) lradius*cos(theta);
		iychar=iyc+(int) lradius*sin(theta);
	        thetaprime=theta+3.14159/2.;
/*	      printf("(%c %d)",*mystrptr,charindex); */
                drawchar(&thefont[charindex],
/*                  ixchar,iychar,fsfx,fsfy,theta+3.14159/2.);  */
                  ixchar,iychar,fsfx,fsfy,thetaprime);
	        ixoff=ixoff+(int) ( (float) (lastspace+thisspace)*fsfx);
                ixoff=ixoff+lsize/5;
/*       printf("%i %i %i %c|",lastspace,thisspace,ixoff,*(mystrptr-1)); */
                theta=theta+(float) ixoff/lradius;
              }

           }
prospace=0;
lastspace=0;
}          


void drawchar(myfontptr,ixc,iyc,fsfx,fsfy,theta)

struct fontchar *myfontptr;
int ixc,iyc;
float fsfx,fsfy,theta;

{
        int i,ii;
	int argx1,argy1,argx2,argy2,n;
	int iargx1,iargy1,iargx2,iargy2;
	if(prospace != 0) { thisspace=('R'-myfontptr->textptr)[0]; }
             else {thisspace=0; lastspace=0;}
	if((*myfontptr).lnpair > 2)
          {
          argx2=(myfontptr->textptr)[2]-'R'+thisspace;
          argy2=(myfontptr->textptr)[3]-'R';
/*	  printf("\n%d %d M",argx1,argy1);		*/
          for(ii=0;ii < myfontptr->lnpair-2;ii++)
             {
             if((myfontptr->textptr)[2*ii+4] == ' ')
                {
                argx2=(myfontptr->textptr)[2*ii+6]-'R'+thisspace;
                argy2=(myfontptr->textptr)[2*ii+7]-'R';
                ii++;
/*		printf("\n"); */
          	}
             else
                {
                argx1=argx2;
                argy1=argy2;
                argx2=(myfontptr->textptr)[2*ii+4]-'R'+thisspace;
                argy2=(myfontptr->textptr)[2*ii+5]-'R';
/*	  printf("\n%d %d %d %d D",argx1,argy1,argx2,argy2); */
/*		iargx1=fsfx*640./1000.*argx1+ixc*640/1000;
		iargx2=fsfx*640./1000.*argx2+ixc*640/1000;
		iargy1=fsfy*480./1000.*argy1+iyc*480/1000;
		iargy2=fsfy*480./1000.*argy2+iyc*480/1000; */
		iargx1=fsfx*argx1*cos(theta)-fsfy*argy1*sin(theta)+ixc;
		if(errno == ERANGE) { printf("Range error"); exit(0); }
		iargx2=fsfx*argx2*cos(theta)-fsfy*argy2*sin(theta)+ixc;
		if(errno == ERANGE) { printf("Range error"); exit(0); }
		iargy1=fsfy*argy1*cos(theta)+fsfx*argx1*sin(theta)+iyc;
		if(errno == ERANGE) { printf("Range error"); exit(0); }
		iargy2=fsfy*argy2*cos(theta)+fsfx*argx2*sin(theta)+iyc;
		if(errno == ERANGE) { printf("Range error"); exit(0); }
		if(iargx1>BXMAX) bermsg(iargx1,iargy1,iargx2,iargy2);
		if(iargx2>BXMAX) bermsg(iargx1,iargy1,iargx2,iargy2);
		if(iargx1<0) bermsg(iargx1,iargy1,iargx2,iargy2);
		if(iargx2<0) bermsg(iargx1,iargy1,iargx2,iargy2);
		if(iargy1>BYMAX) bermsg(iargx1,iargy1,iargx2,iargy2);
		if(iargy2>BYMAX) bermsg(iargx1,iargy1,iargx2,iargy2);
		if(iargy1<0) bermsg(iargx1,iargy1,iargx2,iargy2);
		if(iargy2<0) bermsg(iargx1,iargy1,iargx2,iargy2);
		if(odevice ==0)
		 { EGALINE(iargx1,iargy1,iargx2,iargy2,15);
		   EGALINE(iargx1+1,iargy1,iargx2+1,iargy2,15); } 
	        if(odevice == 1) lprdrawline(iargx1,iargy1,iargx2,iargy2);
	        if(odevice == 2) psline(iargx1,iargy1,iargx2,iargy2);
/*		lprdrawline(iargx1+1,iargy1,iargx2+1,iargy2,15); */
                
                }
      
             
	     }
          }
	if(prospace != 0) { lastspace=(myfontptr->textptr)[1]-'R'; }
	thisspace='R'-(myfontptr->textptr)[0]; 
}

void bermsg(iargx1,iargy1,iargx2,iargy2)
int iargx1,iargx2,iargy1,iargy2;
{
printf("%d %d %d %d Boundary Error",iargx1,iargy1,iargx2,iargy2);
exit(0);
}

