/*
   Printer BGI driver C interface
   Copyright (c) 1991 A. Resztak
 */
 /*   Header file */

#if   !defined( __LARGE__) /* && !defined( __HUGE__) */
   #error PRTgraph library will run only in LARGE memory model.
#endif

#if   !defined(_PRT__pascal)
      #define  _PRT__pascal
#endif


 #define PRT_NO_MEMORY           1
 #define PRT_WRONG_PARAMETERS    2
 #define PRT_NOT_INITIALIZED     3
 #define PRT_IO_ERROR            4
 #define PRT_ERROR               5


 /*   drivers  */

 #define STAR_SR9    0  /* Epson ????, Star SR  */
 #define IBM9        1     /* IBM GraphPrinter, ProPrinter  */
 #define EPSON9      1     /* EPSON */
 #define PANASONIC9  2     /* Panasonic KX-P1124 - not tested */
 #define IBM9c       3     /* IBM ProPrinter (color) */
 #define EPSON9c     3     /* EPSON (color) */
 #define EPSON24     4     /* 24 pins EPSON compatible printer */
 #define IBM24       5     /* 24 pins IBM compatible printer */
 #define EPSON24c    6     /* 24 pins EPSON compatible color printer */
                           /*  not tested */
 #define IBM24c      7     /* 24 pins IBM compatible color printer */
                           /*  not tested */
 #define HPPaintJet  8     /* HP Paint Jet - not tested */
 #define HPLJII      9     /* HP Laser Jet
 /* #define HPLJIII     10  */
 /* #define POSTSCRIPT  11  */
 /* #define ROLANDP  12     */

 /* modes for particular drivers */
   /* EPSON9   */
      #define  EPSON9_60x72      0
      #define  EPSON9_120x72     1
      #define  EPSON9_120x216    2
      #define  EPSON9_240x216    3
   /* STAR_SR9    */
      #define  STAR_SR9_60x72        0
      #define  STAR_SR9_120x72       1
      #define  STAR_SR9_120x144      2
      #define  STAR_SR9_240x144      3
   /* IBM9     */
      #define  IBM9_60x72        0
      #define  IBM9_120x72       1
      #define  IBM9_120x216      2
      #define  IBM9_240x216      3
   /* EPSON24  */
      #define  EPSON24_60x180     0
      #define  EPSON24_120x180    1
      #define  EPSON24_180x180    2
      #define  EPSON24_360x180    3
      #define  EPSON24_360x360    4
   /* IBM24    */
      #define  IBM24_60x180     0
      #define  IBM24_120x180    1
      #define  IBM24_180x180    2
      #define  IBM24_360x180    3
   /* HPPJ   */
      #define  HPPJ_90x90        0
      #define  HPPJ_180x180      1
      #define  HPPJ_90x90c       2
      #define  HPPJ_180x180c     3
   /* HPLJII   */
      #define  HPLJII_75x75        0
      #define  HPLJII_100x100      1
      #define  HPLJII_150x150      2
      #define  HPLJII_300x300      3


 /*   F U N C T I O N S    P R O T O T Y P E S  */

#define  FAR_DATA    /* far */
#define  FAR_PTR        far
#define  FAR_PROC    far

#ifdef __cplusplus
extern "C" {
#endif


int FAR_PROC pascal PRT_SetDriver ( unsigned drv, unsigned mode,
                                     unsigned width, unsigned height,
                                     unsigned options );
   #define  PRT_NORMAL     0
   #define  PRT_ROTATE     1
   #define  PRT_INVERSE    2
   #define  PRT_REVERSE    2

 /* Procedures which may be called before initializing PBGI */
int FAR_PROC pascal PRT_Buffer ( void far *address, long size, int usable );
int FAR_PROC pascal PRT_EMSBuffer ( int handle, long size, int usable );
int   FAR_PROC pascal   PRT_SetBuffer ( long size, unsigned BufOpt );
      #define  NotUseEMS   1
      #define  NotUseXMS   2
 int FAR_PROC pascal PRT_DefineWorld ( unsigned MaxX, unsigned MaxY );
 int  FAR_PROC pascal   PRT_SetOutName ( char FAR_PTR * DeviceName );
 int  FAR_PROC pascal   PRT_SetMargins ( int left, int top );
 int  pascal FAR_PROC   PRT_RescaleFillPattern ( int r );
                        /* 0 = never, 1 = always , -1 = at high densities only */

 /* Procedure allocates PRT buffer, initializes PBGI, calls Draw(),
    closes PBGI, prints picture, and frees the buffer.
    All above is done neccesary number of times to print
    entire picture. */
int FAR_PROC pascal PRT_PrintBGI (
                              int far * graphdriver, int far *graphmode,
                              char far *pathtodriver,
                              int ( FAR_PTR * FAR_PROC  _PRT__pascal Draw)(void) );

       /* Various informing procedures */
   /* May be allways called   */
 unsigned   FAR_PROC pascal PRT_MaxDriver ( void );
 int  FAR_PROC pascal   PRT_DriverName ( unsigned driverno, char FAR_PTR * FAR_PTR * name_ptr  );
 int  FAR_PROC pascal   PRT_MaxMode ( unsigned driverno, int FAR_PTR *maxmode );
 int  FAR_PROC pascal   PRT_ModeName ( unsigned driverno, int modeno,
                        char FAR_PTR * FAR_PTR * name_ptr );
 int  FAR_PROC pascal   PRT_DriverNo ( void );
 int  FAR_PROC pascal   PRT_ModeNo ( void );
 char far * FAR_PROC pascal   PRT_errormsg ( int errorcode );

   /*  May be called only after PRT_SetPicture and PRT_SetDriver */
 long FAR_PROC pascal   PRT_BufferNeeded ( int x1, int y1, int x2, int y2 );
 int  FAR_PROC pascal   PRT_Resolution ( int FAR_PTR *Xres, int FAR_PTR *Yres );


 /* Procedure initializes PBGI, calls Draw(), closes PBGI,
    DOES NOT print picture, and DOES NOT allocate or free the buffer */
int FAR_PROC pascal  PRT_BuildBitMap (
                              int far * graphdriver, int far *graphmode,
                              char far *pathtodriver,
                              int x1,int y1, int x2,int y2,
                              int ( FAR_PTR * FAR_PROC  /* pascal */ Draw)(void) );

/* Procedures which may be called before freeing the buffer */
int FAR_PROC _PRT__pascal PRT_InitPrt ( int handle );
int FAR_PROC _PRT__pascal PRT_EndPrt ( int handle );
int   FAR_PROC pascal   PRT_PrintBuffer (int handle);
unsigned FAR_PROC pascal   PRT_getpixel ( int x, int y );
void  FAR_PROC pascal   setfillpattern16 ( char FAR_PTR * upattern, int color );
void  FAR_PROC pascal   getfillpattern16 ( char FAR_PTR * upattern );

int   FAR_PROC pascal   PRT_AllocateBuffer ( void );
int   FAR_PROC pascal   PRT_FreeBuffer (void);


int FAR_PROC pascal PRT_PrintCntrlInfo ( int handle,
                                         char FAR_PTR *s1, int value,
                                         char FAR_PTR * s2,
                                         int NonASCIIwidth );

	int FAR_PROC pascal PRT_installuserdriver ( const char far * name, int huge (*detect)(void) );
   int FAR_PROC pascal PRT_registerfarbgidriver ( void far pascal (*driver)(void) );
   int FAR_PROC pascal PRT_Unregisterfarbgidriver ( void far pascal(*driver)(void) );
   int FAR_PROC pascal PRT_SetViewSize( int x1, int y1, int x2, int y2 );
   int FAR_PROC pascal PRT_initgraph( int far * graphdriver, int far *graphmode,
                                       char far *pathtodriver );
                                       /*  int x1, int y1, int x2, int y2 ); */
   int FAR_PROC pascal PRT_closegraph(void); /* DOES NOT free the buffer   */

   typedef int _PRT__pascal ( FAR_PROC * pascal PRT_ErrorFuncP) ( int handle );
   typedef int _PRT__pascal ( FAR_PROC * pascal PRT_OpenFuncP)( const char far* outname );
   typedef int _PRT__pascal ( FAR_PROC * pascal PRT_CloseFuncP)( int handle );
   typedef int _PRT__pascal ( FAR_PROC * pascal PRT_WriteFuncP)( int handle, const void FAR_PTR * b,
                                                           unsigned len );
PRT_ErrorFuncP FAR_PROC pascal PRT_SetErrorFunc ( int far _PRT__pascal WrErrFunc(int handle) );
PRT_OpenFuncP  FAR_PROC pascal PRT_SetOpenFunc  ( int far _PRT__pascal f(const char far* outname) );
PRT_CloseFuncP FAR_PROC pascal PRT_SetCloseFunc ( int far _PRT__pascal f(int handle) );
PRT_WriteFuncP FAR_PROC pascal PRT_SetWriteFunc ( int far _PRT__pascal
                                                  f(int handle,
                                                    const void FAR_PTR * b,
                                                    unsigned len) );

extern void FAR_PROC pascal BitImage(void);  /* link our bit image BGI driver */

#ifdef __cplusplus
   }
#endif


#ifdef __cplusplus
extern "C" {
#endif
      int _PRT__pascal PRT_Open(const char far* outname);
      int _PRT__pascal PRT_Close( int handle );
      int _PRT__pascal PRT_Write( int handle, const void FAR_PTR * b, unsigned len );
#ifdef __cplusplus
           }
#endif


   /* end of PRTGRAPH.H  */
