/************************************************************************
*                                                                       *
*			1988 - Jim Schimpf				*
*                                                                       *
*                            BASE DATA TYPES                            *
*                                                                       *
*       Module:base.h                                                   *
*                                                                       *
*   Version     Date    Person      Description                         *
*-----------------------------------------------------------------------*
*   0.1      4-Apr-88   J.Schimpf   Initial Version                     *
*   0.2     24-May-88   J.Schimpf   New file for base data types        *
*   0.4	     1-Oct-88	J.Schimpf   Add SIGN & ABS			*
*                                                                       *
*   DESCRIPTION:                                                        *
*       These are the base data types                                   *
*                                                                       *
*									*
************************************************************************/

#ifndef _BASE_
#define _BASE_ 1

/*  BASE DATA TYPES */

typedef char BOOLEAN;       /* TRUE/FALSE type */
typedef int  (*IFC)();      /* Function returning an int */

/*  BASE CONSTANTS */

#define MAX_REPLY	128	/* Max size of reply from ARAX */
#define TRUE    0xff
#define FALSE   0

#define LESS    0
#define EQUAL   1
#define MORE    2

/*  Useful MACROS */

#define FREE(x)         if( x != NULL )\
				free( (char *)x )

#define COMPARE( x,y )  ( x == y ? EQUAL : ( x < y ? LESS : MORE ))

#define ABS( x )        ( (x < 0 ) ? x * -1 : x )

/*  Return TRUE on > 0 and FALSE on < 0 */

#define SIGN( x )       (( x < 0 ) ? FALSE : TRUE )

#endif

