/*******************************************************************
		STOP'n GO - Stopwatch
	Copyright (c) 1992 by Omega Point, Inc.
	       Author: Ratko V. Tomic
*********************************************************************
		RESIDENT CODE & DATA
*********************************************************************/

/******* TSR MODULE ********/

#include "sg.h"

long t;			   /* Starting BIOS tick count */
int on,exe;		   /* 0 when idle, NZ when timing/active */
word *box,*stk; 	   /* Screen buffer and TSR stack */
char ts[]="00:00:00.00";   /* String to convert time into */

xchg_scr()
{
   crs_x=22; crs_y=10;
   swap_blk(BOX_DX,BOX_DY,box);
   crs_y++; crs_x+=8; flush_kbd();
}

show_time()
{ register byte *s=(byte*)&t;
  register char *d;
  #define tm *(long*)s
    if ((tm=bios_ticks()-tm)<0L) tm+=0x1800b0L;
    ticks2time(tm,(struct time_rec*)s);
    s+=3; d=ts; _hkey_again=0;
    do cv_b2dec(*s,d),d+=3; while (--s>=(byte *)&t);
    xchg_scr(); dsp(ts);
    while(!anykey()&&!_hkey_again);
    xchg_scr();
}

/*** INTERCEPT FOR INTERRUPT 0x21 ***/

#define f_ss (dword)(_int_frame->saved_ss)  /* Foreground SS register */
#define f_sp (_int_frame->saved_sp)	    /* Foreground SP register */
struct trap_rec tr={0,0,0x21,0,0,0,1};	    /* Trap control record    */

isr21(arg)
{word f_ax;
   f_ax = ((struct glob_stk far *)((f_ss<<16)+f_sp))->ax; /* Get DOS func */
   if (f_ax==0x4B00) on=0;			          /* DOS Exec */
   else if (!(((f_ax&=0xFF00)==0x4C00)||!f_ax)||!on)      /* Exit ?*/
	return(arg);
   isr(H_GO1);
   return(arg);
}

isr(hk)		/*** HOTKEY INTERRUPT SERVICE ***/
{
   switch (hk) {
     case H_EX1:  ;
     case H_EXE:  if ((exe=~exe)!=0) add_trap(&tr);
		     else clr_trap(&tr); break;
     case H_ON1:  ;
     case H_ON:   if (!on) stuff_key(0xd);
     case H_GO1:  ;
     case H_GO:   if ((on=~on)!=0) t=bios_ticks();
		     else show_time(); break;
   }
}
