/*******************************************************************
		STOP'n GO - Stopwatch
	Copyright (c) 1992 by Omega Point, Inc.
	       Author: Ratko V. Tomic
*********************************************************************
          DISPOSABLE CODE (Load time initialization)
*********************************************************************/

#include "sg.h"

extern char loaded_msg[],hello_msg[],first_msg[];
extern char unl_ok[],cant_unl[];
extern byte hello_atr[],mono_atr[];
extern word init_data_end,hotkeys[];
extern char *box,*stk;
extern byte frame_atr,time_atr,text_atr;
extern isr(),isr21();	/* Hotkey and Trap services in SW.C */

one_scr(char *msg,byte *atr)
{
  int x0,y0,x1,y1;

    x0=crs_x; y0=crs_y; vid_atr=0x7;
    fil_scr(''); dspf(msg,atr);	/* Show hello screen on pinstripe */
    x1=crs_x; y1=crs_y+1; vid_atr=7;	/* Build shadow around */
    crs_y=y0+1; dsp_ver(0x20,y1-y0);
    crs_x++; crs_y=y0+1; dsp_ver(0x20,y1-y0);
    crs_x=x0+3; crs_y=y1; dsp_hor(0x20,x1-x0-1);
}

signon(sec_ld)
{ byte *s=hello_atr;
   if (vid_mode==7) 
     {
     s=mono_atr;
     time_atr=frame_atr=0x7;
     }
   save_crs(); kil_crs();
   if (!sec_ld)
     {
     crs_x=5; crs_y=1;
     one_scr(first_msg,s); pckey();
     }
   crs_x=11; crs_y=2;
   one_scr(hello_msg,s);
   crs_x=0; crs_y=24; vid_atr=7;
   dsp_hor(0x20,scr_width);
   restore_crs();
   crs_x=0; crs_y=23; mv_crs();
}


build_box()			/* Build stopwatch box in memory */
{ register word *p=(word*)box;
  register word f=frame_atr<<8,t=time_atr<<8,m=text_atr<<8;
  #define DX (11+2)
  #define BX (BOX_DX-2)
    *p++=f+0xdb; 
    p=fil_wrd(p,f+0xdf,BX);	/* Line 1 */
    *p++=f+0xdb;
    *p++=f+0xdb; *p++=f+0x20;	/* Line 2, left frame	*/
    *p++=m+0x20;
    *p++=m+'T';*p++=m+'I';*p++=m+'M';*p++=m+'E';
    p=fil_wrd(p,t+0x20,DX);	/* Line 2, clock	*/
    *p++=f+0x20; *p++=f+0xdb;	/* Line 2, right frame	*/
    *p++=f+0xdb;
    p=fil_wrd(p,f+0xdc,BX);	/* Line 3 */
    *p++=f+0xdb;	
    vid_atr=time_atr;
}

main()
{ char *s=cmd_line;
  int sl;

  up_case(s);
  sl=second_load();
  signon(sl);				/* Show signon message	*/
  if (sl) 	 			/* If already loaded	*/
    {
    if (str_pos('U',s) || str_pos('R',s))
      {
      if (remove_tsr())
        dsp(unl_ok);
      else dsp(cant_unl);
      }
    else dsp(loaded_msg);
    clr_eol();
    return(1);			/* If so exit with errorlevel 1	*/
    }
  _heap=SS+2+(stk=BS+(box=_heap));	/* Reserve heap space for TSR	*/
  build_box();				/* Create box image in memory	*/
  idata_end=&init_data_end;		/* Specify disposable data	*/
  icode_beg=(fp)one_scr;		/* Specify disposable code	*/
  stay_resident((word*)stk,SS);		/* Define TSR stack		*/
  install_hk(hotkeys,isr,SS,0x7f);	/* Install HOTKEY support	*/
  install_trap(isr21,SS,0x7f);		/* Install intr. traps		*/
  return(0);
}
