// LX_EXE.h - The format of the LX Executable type is described here.
//
//	History:
//		JVRodley	11/16/1993	Initial coding
//
//

#ifndef LXEXE_INCLUDED
#define LXEXE_INCLUDED

// Possible values for both ByteOrder and WordOrder
#define LITTLE_ENDIAN	0x00
#define BIG_ENDIAN		0x01

// Possible values for CPUType
#define PROC_286_UP	0x01
#define PROC_386_UP	0x02
#define PROC_486_UP	0x03
#define PROC_PENTIUM_UP	0x04

// Possible values for OSType
#define OST_UNKNOWN	0x00
#define OST_OS2		0x01
#define OST_WINREF	0x02
#define OST_DOS4		0x03
#define OST_WIN386REF	0x04

// Possible values for ModFlags
#define MODF_RESERVED1	0x00000001L
#define MODF_RESERVED2	0x00000002L
#define MODF_PERPROCLIB	0x00000004L
#define MODF_RESERVED3	0x00000008L
#define MODF_INTERNALFIX	0x00000010L
#define MODF_EXTERNALFIX	0x00000020L
#define MODF_RESERVED4	0x00000040L
#define MODF_RESERVED5	0x00000080L
#define MODF_NOWINCOMPAT	0x00000100L
#define MODF_WINCOMPAT	0x00000200L
#define MODF_USESWINAPIU	0x00000300L
#define MODF_RESERVED6	0x00000400L
#define MODF_RESERVED7	0x00000800L
#define MODF_RESERVED8	0x00001000L
#define MODF_NOTLOADABLE	0x00002000L
#define MODF_RESERVED9	0x00004000L
#define MODF_TYPEMASK	0x00038000L
#define MODF_TYPPROGRAM	0x00000000L
#define MODF_TYPLIBRARY	0x00080000L
#define MODF_TYPPROTMEMLIB	0x00018000L
#define MODF_TYPPHYSDEV	0x00020000L
#define MODF_TYPVIRTDEV	0x00028000L
#define MODF_PERPROCLIBTERM	0x40000000L

typedef struct {
	UCHAR ByteOrder;	// LITTLE_ENDIAN or BIG_ENDIAN
	UCHAR WordOrder;	// LITTLE_ENDIAN or BIG_ENDIAN
	ULONG FormatLevel;   // Loader format level, currently 0
	USHORT CpuType;      // 286 through Pentium+
	USHORT OSType;       // DOS, Win, OS/2 ...
	ULONG ModVersion;    // Version of this exe
	ULONG ModFlags;      // Program/Library ...
	ULONG ModNumPgs;  // Number of non-zero-fill or invalid pages
	ULONG EIPObjNum;  // Initial code object
	ULONG EIP;        // Start address within EIPObjNum
	ULONG ESPObjNum;  // Initial stack object
	ULONG Esp;        // Top of stack within ESPObjNum
	ULONG PgSize;     // Page size, fixed at 4k 
	ULONG PgOfsShift;       // Page alignment shift
	ULONG FixupSectionSize; // Size of fixup information in file
	ULONG FixupCksum;       // Checksum of FixupSection
	ULONG LdrSecSize;       // Size of Loader Section
 	ULONG LdrSecCksum;      // Loader Section checksum
	ULONG ObjTblOfs;        // File offset of Object Table
	ULONG NumObjects;       // Number of Objects
	ULONG ObjPgTblOfs;      // File offset of Object Page Table
	ULONG ObjIterPgsOfs;    // File offset of Iterated Data Pages
	ULONG RscTblOfs;        // File offset of Resource Table
	ULONG NumRscTblEnt;     // Number of entries in Resource Table
   ULONG ResNameTblOfs;    // File offset of Resident Name Table
   ULONG EntryTblOfs;      // File offset of Entry Table
	ULONG ModDirOfs;        // File offset of Module Directives
	ULONG NumModDirs;       // Number of Module Directives
	ULONG FixupPgTblOfs;    // File offset of Fixup Page Table
	ULONG FixupRecTblOfs;   // File offset of Fixup Record Table
	ULONG ImpModTblOfs;     // File offset of Imported Module Table
	ULONG NumImpModEnt;     // Number of Imported Modules
	ULONG ImpProcTblOfs;    // File offset of Imported Proc Table
	ULONG PerPgCksumOfs;    // File offset of Per-Page Checksum Table
	ULONG DataPgOfs;        // File offset of Data Pages
	ULONG NumPreloadPg;     // Number of Preload Pages
	ULONG NResNameTblOfs;   // File offset of Non Resident Name Table
                              // Relative to Beginning of File!!
	ULONG NResNameTblLen;   // Length in bytes of Non Resident Name Table
                              // The table is also NULL terminated.
	ULONG NResNameTblCksum; // Non Resident Name Table checksum
	ULONG AutoDSObj;        // Object number of auto data
	ULONG DebugInfoOfs;     // File offset of debugging info
	ULONG DebugInfoLen;     // Length of Debugging Info
	ULONG NumInstPreload;   // Number of instance-preload pages
	ULONG NumInstDemand;    // Number of instance-demand pages
	ULONG HeapSize;         // Heap size
	ULONG StackSize;        // Stack size
   } LX_EXE;


// An entry in the object table
typedef struct {
	ULONG size;             // Load-time size of object
	ULONG reloc_base_addr;  // Address the object wants to be loaded at.
	ULONG obj_flags;        // Read/Write/Execute, Resource, Zero-fill ...
	ULONG pg_tbl_index;     // Index in Object Page Table at which
                           // this object's first page is located.
	ULONG num_pg_tbl_entries;  // Number of consecutive Object Page Table
                              // entries that belong to this object.
	ULONG reserved;         // reserved.
} LX_OBJ;

// An object page table entry
typedef struct {
   ULONG offset;     // File offset of this pages data.  Relative to
                     // beginning of Iterated or Preload Pages Sections
   USHORT size;      // Size of this page.  <= 4096
   USHORT flags;     // Iterated, Zero-filled, Invalid ...
   } LX_PG;

// possible values for flags member
typedef enum pg_types {
   LX_DATA_PHYSICAL = 0,   // Legal Physical Page, file offset relative 
                           // to Preload Pages
   LX_DATA_ITERATED,       // Iterated Data Page, file offset relative to 
                           // Iterated Pages
   LX_DATA_INVALID,        // Invalid page.
   LX_DATA_ZEROFILL,       // Zero-filled page.
   LX_DATA_RANGE           // Range of pages.
   };

// An entry in nonres or res table, my concoction, string is 
// variable length, nonnull terminated in file.
typedef struct {
   UCHAR len;
   char string[256];
   USHORT ordinal;
} LX_NRES;

// possible bit values for obj_flags
#define OF_READABLE	0x0001
#define OF_WRITABLE	0x0002
#define OF_EXECUTABLE	0x0004
#define OF_RESOURCE	0x0008
#define OF_DISCARDABLE	0x0010
#define OF_SHARED	0x0020
#define OF_PRELOAD	0x0040
#define OF_INVALID	0x0080
#define OF_ZEROFILLED	0x0100
#define OF_RESIDENT	0x0200
#define OF_RESLONGLOCK	0x0400
#define OF_RESERVED1	0x0800
#define OF_16	0x1000
#define OF_BIGDEFAULT	0x2000
#define OF_CONFORMING	0x4000
#define OF_IOPRIV	0x8000
// bit combo
#define OF_RESCONTIGUOUS	0x0300

// An entry in the resource table
typedef struct {
   USHORT type_id;   // one of rsc_types
   USHORT name_id;   // ID application uses to load this resource
   ULONG size;       // size of the resource
   USHORT object;    // which object is this resource located in?
   ULONG offset;     // resource offset within the object 
   } LX_RSC;

#ifndef RT_POINTER
// Resource types
typedef enum rsc_types {
   RT_POINTER = 1,
   RT_BITMAP,
   RT_MENU,
   RT_DIALOG,
   RT_STRING,
   RT_FONTDIR,
   RT_FONT,
   RT_ACCELTABLE,
   RT_RCDATA,
   RT_MESSAGE,
   RT_DLGINCLUDE,
   RT_VKEYTBL,
   RT_CHARTBL,
   RT_DISPLAYINFO,
   RT_FKASHORT,
   RT_FKALONG,
   RT_HELPTABLE,
   RT_HELPSUBTABLE,
   RT_FDDIR,
   RT_FD
   };
#endif

#endif

/* Format of a menu page

1 byte gribble
2 bytes unsigned menu id
1 byte gribble
3 bytes signifying BEGIN or left bracket (variable from link to link)
3 bytes of gribble

   * format of a submenu
   4 bytes containing 11 00 00 00
   2 bytes unsigned submenu id
   null terminated string
   4 bytes of gribble (flags???)
   3 bytes signifying BEGIN or left bracket (variable from link to link)
   3 bytes of gribble

      * format of a menuitem
      4 bytes containing 01 00 00 00
      2 bytes unsigned item id
      null terminated string
      4 bytes of gribble (flags like MIS_TEXT??)



* file ends when size of resource bytes have been processed

*/
typedef struct {
   UCHAR gribble1;
   USHORT id;
   UCHAR gribble2;
   UCHAR leftbracket[3];
   UCHAR gribble3[3];
   } LX_MENU;

#define LX_SUBMENU_SIG  0x11L
typedef struct {
   ULONG signature;  // equals 0x11L
   USHORT id;
   char string[1];   // string followed by ...
   } LX_SUBMENU;

typedef struct {
   ULONG flags;
   UCHAR leftbracket[3]; // use whatever is up in the MENU leftbracket
   UCHAR gribble1[3];
   } LX_SUBMENU_STARTER;
         
#define LX_MENUITEM_SIG1  0x01L
typedef struct {
   ULONG signature;  // equals 0x01L
   USHORT id;
   UCHAR string[1];
   } LX_MENUITEM;

#define LX_MENUITEM_SEPARATOR  0x04L
typedef struct {
   ULONG signature;  // equals 0x04L
   USHORT id;			// ALWAYS 0!
   } LX_MENU_SEPARATOR;

typedef ULONG LX_MENUITEM_FOLLOWER;

typedef struct {
   USHORT object;
   ULONG target_ofs;
   USHORT srcofs[1];
   } LX_FU_INTERNAL;

typedef struct {
   USHORT module;
   ULONG proc_nm_ofs;
   ULONG additive;
   USHORT srcofs[1];
   } LX_FU_IMPBYNAME;

typedef struct {
   USHORT module;
   USHORT ordinal;
   ULONG additive;
   USHORT srcofs[1];
   } LX_FU_IMPBYORD;

typedef struct {
   USHORT ordinal;
   ULONG additive;
   USHORT srcofs[1];
   } LX_FU_VIAENTRY;

// FIXUP structure definitions
typedef struct {
   UCHAR source;
   UCHAR flags;
   union {
      UCHAR cnt;
      USHORT ofs;
      } sc;

   union {
      LX_FU_INTERNAL i;
      LX_FU_IMPBYORD o;
      LX_FU_IMPBYNAME   n;
      LX_FU_VIAENTRY e;
      } targ;
   ULONG offset;
   USHORT *list;
   } LX_FIXUP;


// Possible values for source
#define LX_SRC_MASK  0x0f
#define LX_FU_BYTE_FIXUP   0x00
#define LX_FU_16BITSELECTOR     0x02
#define LX_FU_16_1          0x03
#define LX_FU_16BITOFFSET  0x05
#define LX_FU_16_2         0x06
#define LX_FU_32BITOFFSET  0x07
#define LX_FU_32BITSELFRELOFFSET  0x08
#define LX_FU_ALIAS        0x10
#define LX_FU_SOURCELIST  0x20

// Possible values for target flags
#define LX_FUF_TARGETMASK  0x03
#define LX_FUF_INTERNAL 0x00
#define LX_FUF_IMPORTBYORDINAL   0x01
#define LX_FUF_IMPORTBYNAME  0x02
#define LX_FUF_IMPORTVIAENTRY 0x03
#define LX_FUF_ADDITIVEFIXUP  0x04
#define LX_FUF_RESERVED 0x08
#define LX_FUF_32BITTARGOFS  0x10
#define LX_FUF_32BITADDITIVE  0x20
#define LX_FUF_16BITOBJORDINAL   0x40
#define LX_FUF_8BITORDINAL 0x80

extern int Read_LXExe(void);
extern void DumpLXExeHdr(void);
extern void DumpLXTables(void);
extern void DumpLXPages(void);
extern void FreeLXPages(void);
extern void FreeLXTables(void);


