//                                    Copyright John V. Rodley   1994
//
#include <stddef.h>     /* Multi-threads live in mt directory.    */
#include <ctype.h>
#include <malloc.h>
#include <share.h>
#include <stdio.h>
#include <errno.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <string.h>
#include "types.h"
#include "exe.h"
#include "utils.h"

MZ_EXE mz_exe; // The MZ exe header, present in all executables.

// DumpDosExeHdr - Display the DOS exe hdr.
int DumpMZExeHdr()
{
    printf( "\n\nxxx   DOS EXE header information\n\n" );
    printf( "%40s: %u\n", "Number of bytes in header", mz_exe.cparhdr*16 );
    printf( "%40s: %u\n", "Number of 512 byte pages in header", mz_exe.cp );
    printf( "%40s: %u\n", "Number of bytes in last page", mz_exe.cbip );
    printf( "%40s: %04XH\n", "Checksum", mz_exe.csum );
    printf( "%40s: %04XH\n", "Minimum number of extra paragraphs", mz_exe.minalloc );
    printf( "%40s: %04XH\n", "Maximum number of extra paragraphs", mz_exe.maxalloc );
    printf( "%40s: %04XH:%04XH\n", "Starting address", mz_exe.cs, mz_exe.ip );
    printf( "%40s: %04XH:%04XH\n", "Stack address", mz_exe.ss, mz_exe.sp );
    printf( "%40s: %u\n", "Overlay number", mz_exe.ovno );
    printf( "%40s: %04XH\n", "OEM identifier", mz_exe.oeminfo );
    printf( "%40s: %u\n", "Number of relocations", mz_exe.crlc );
return( 0 );
}              /* DumpDosExeHdr */

// Read_MZExe - Read in the DOS header.
int Read_MZExe()
{
   unsigned short i;
   struct REL rel;
		
   if( bVerbose )
       printf( "xxx   Reading MZ executable header.\n" );

	 // The MZ Header ALWAYS appears at byte offset 0 from beginning of file.
	 fseek( fp, 0L, SEEK_SET );
    if( fread(( char *)&mz_exe, sizeof( MZ_EXE ), 1, fp ) != 1 )
      goto notanexe;

    if( strncmp( (char *)&mz_exe.magic, exetypes[TYPE_MZ].idstring, 2 ) != 0 )
      goto notanexe;

    if( mz_exe.crlc )
      {
      /* pause( fp ); */

      if( fseek( fp, (long )mz_exe.lfarlc, 0 ))
         {
         printf(  "Can't seek to %04xh\n", mz_exe.lfarlc );
         goto notanexe;
         }

      for( i = 0; i <= mz_exe.crlc; i++ )
         {
         if( fread( (char *)&rel, sizeof( struct REL ), 1, fp ) != 1 )
            {
	         printf(  "Can't read %d at 0x%lxL\n", sizeof( struct REL ), ftell( fp ) );
   	      goto notanexe;
            }
         }
      }
   return( TYPE_MZ );
notanexe:
    return( TYPE_OTHER );
}



