// MZ_exe.h - A description of a DOS/MZ executable
//
//	History:
//		JVRodley	6/1/1990
//

#ifndef MZEXE_INCLUDED
#define MZEXE_INCLUDED

struct REL {
   unsigned short offset;
   unsigned short segment;
   };

typedef struct {
   unsigned short magic;
   unsigned short cbip;
   unsigned short cp;
   unsigned short crlc;
   unsigned short cparhdr;
   unsigned short minalloc;
   unsigned short maxalloc;
   unsigned short ss;
   unsigned short sp;
   unsigned short csum;
   unsigned short ip;
   unsigned short cs;
   unsigned short lfarlc;
   unsigned short ovno;
   unsigned short res1[4];
   unsigned short oemid;
   unsigned short oeminfo;
   unsigned short res2[10];
   unsigned long lfanew;
   } MZ_EXE;

typedef struct {
		unsigned short magic;	// MUST BE ASCII "MZ"
		char useless_bytes[34];	// Ignore these bytes
		unsigned long lfanew;	// Here's the file offset of new exe header.
   } SIMPLE_MZ_EXE;

extern int DumpMZExeHdr(void);
extern int Read_MZExe(void);

#endif
