# SHOWEXE.MAK - Makefile for SHOWEXE.EXE and the examples shipped
# with the DDJ article on LX file formats.
#
# This is a Microsoft C6 application.
# 
# use "nmake -f showexe.mak"
#
# Compiler flags:
#
# AL    Large model
# -W3   Report all niggling warnings and such
# -c    Create .obj file.
# -F B000       Give us a big stack for recursion
# -Od   Disable optimizations (debugging).
# -G2   Assume 286 processor.
# -Zi   Include debugging info for CodeView.
# -Zp   Pack structures.

OPT=-AL -W3 -c -F B000 -Od -G2 -Zip

all: showexe.exe

args.obj:	 args.c
        cl $(OPT) args.c

utils.obj:     utils.c utils.h
	     cl $(OPT) utils.c

ne_exe.obj:      ne_exe.c ne_exe.h utils.h
	     cl $(OPT) ne_exe.c

mz_exe.obj:      mz_exe.c mz_exe.h utils.h
	     cl $(OPT) mz_exe.c

lx_exe.obj:      lx_exe.c lx_exe.h utils.h
	     cl $(OPT) lx_exe.c

showexe.obj:      showexe.c ne_exe.h utils.h
	     cl $(OPT) showexe.c

showexe.exe:     showexe.obj utils.obj args.obj \
                        lx_exe.obj ne_exe.obj mz_exe.obj
        link /STACK:16384 showexe+mz_exe+lx_exe+ne_exe+utils+args,showexe,NUL,/CO /NOD os2+llibcep,NUL

