
/*
 * TPCMAC.H - Macro Header for use with Turbo Pascal --> C Translator
 *
 * S.H.Smith, 22-Dec-86 (rev. 18-Apr-87 shs)
 *
 */

#include <stdio.h>


/* define some simple keyword replacements */

#define keypressed     kbhit()
#define upcase(c)      toupper(c)
#define length(s)      strlen(s)
#define dispose(v)     free(v)
#define pred(v)        ((v)-1)
#define succ(v)        ((v)+1)
#define sqr(v)         ((v)*(v))
#define chr(n)         (n)
#define ord(c)         (c)
#define false          0
#define true           1
#define NIL            NULL

#define delete(dstr,pos,num) strcpy(dstr+pos-1,dstr+pos+num)
#define val(dstr,res,code)   code=0, res=atof(dstr)
#define pos(ch,dstr)         index(ch,dstr)

#define THRU           -2
#define ENDSET         -1


/*
 * support library functions:  (these need to be written)
 *
 *   setof(a,b,...,-1)
 *      construct and return a set of the specified character values
 *
 *   inset(ex,set)
 *      predicate returns true if expression ex is a member of
 *      the set parameter
 *
 */

typedef char *string;
#define STRSIZ 255      /* default string length */


/*
 * copy len bytes from the dynamic string dstr starting at position from
 *
 */
string copy(dstr,from,len)
string dstr;
int  from,len;
{
   static char buf[STRSIZ];

   buf[0]=0;
   if (from>strlen(buf))     /* copy past end gives null string */
      return buf;

   strcpy(buf,dstr+from-1);  /* skip over first part of string */
   buf[len] = 0;             /* truncate after len characters */
   return buf;
}


/*
 *  concatenate str1 and str2 and return a pointer to the
 *  static result.   note that str1 or str2 may point to the
 *  concat static buffer.
 */
string concat(s1,s2)
string s1;
string s2;
{
   static char buf[STRSIZ];
   char ts2[STRSIZ];

   strcpy(ts2,s2);    /* this is needed because either s1 or s2 could
                         already point to buf! */
   strcpy(buf,s1);
   strcat(buf,ts2);

   return buf;
}


/* macros to process turbo pascal pragmas */

#define standard_io(p)        /* ignore */
#define control_c_check(p)    /* ignore */
#define device_check(p)       /* ignore */
#define max_files(p)          /* ignore */
#define input_file_buffer(p)  /* ignore */
#define io_error_check(p)     /* ignore */
#define stack_check(p)        /* ignore */
#define output_file_buffer(p) /* ignore */
#define range_check(p)        /* ignore */
#define user_interrupt(p)     /* ignore */
#define param_type_check(p)   /* ignore */
#define E(p)                  /* ignore */


/* file access support */

char _CURNAME[64];
int  ioresult = 0;

typedef FILE *text;

#define eof(fd)         feof(fd)
#define EOF(fd)         feof(fd)

#define assign(fd,name) strcpy(_CURNAME,name)
#define reset(fd)       ioresult = (( (fd = fopen(_CURNAME,"r")) == 0))
#define rewrite(fd)     ioresult = (( (fd = fopen(_CURNAME,"w")) == 0))

#define close(fd)       ioresult = fclose(fd)


