/*
* Program Description:
*     This programs shows the usage of the undocumented DOS interrupt
*     2eh. By executing this interrupt, you can permanently modify the
*     DOS environment variables.
*
* Compilation:
*     CL /c /Ox /Zp /Gs /AS undoc.c
*
* Linking:
*     LINK undoc+int2e;
*
* Execution:
*     UNDOC env-variable=new-value
*           where env-variable is the variable to set
*                 new-value    is the new value of the environment variable
*
*     Example: UNDOC PATH=C:\DOS
*/

/*
* make sure we use the standard functions properly
* by including function prototypes for common routines
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
* make a prototype for int_2e()
*/
extern void int_2e(char *);

/*
* this string holds the command to execute via int 2eh
*/
static char command_to_execute[129];

/*
* main program entry point
*/
main(int argc, char *argv[])
{

/*
* if the user doesn't know how to use this utility, tough shit . . .
*/
   if (argc != 2)
   {
      printf("Syntax error\n");
      exit(1);
   }

/*
* see if we are running under small model
*/
   if (sizeof(char *) != sizeof(int))
   {
      printf("Only works under small model!\n");
      exit(1);
   }

/* 
* byte zero needs the string length of the command
*/
   command_to_execute[0] = strlen(argv[1]) + 5;
   strcpy(&command_to_execute[1],"SET ");
   strcat(command_to_execute,argv[1]);

/*
* we need to terminate the string with a <CR>
*/
   command_to_execute[command_to_execute[0]+1] = 0x0d;

/*
* call the undocumented interrupt
*/
   int_2e(command_to_execute);

/*
* terminate program
*/
   exit(0);

}
