#include <stdio.h>
#include <stdarg.h>

typedef void (*funcptr)();

#define CHAR	1
#define INT		2
#define LONG	3
#define FLOAT 	4
#define DOUBLE	5
#define LDOUBLE 6
#define POINTER 7
#define FUNCPTR 8

void printargs(int *argtypeptr, ...)
{
    int argtype;
    va_list ap;

    va_start(ap, argtypeptr);
    while((argtype = *argtypeptr++) != 0)
    {
        switch(argtype)
        {
            case CHAR:
                printf("Char:	  %c\n", va_arg(ap, int));
                break;
            case INT:
                printf("Int: 	  %d\n", va_arg(ap, int));
                break;
            case LONG:
                printf("Long: 	  %l\n", va_arg(ap, long));
                break;
            case FLOAT:
                printf("Float: 	  %f\n", va_arg(ap, double));
                break;
            case DOUBLE:
                printf("Double:   %lf\n", va_arg(ap, double));
                break;
            case LDOUBLE:
                printf("Long Double:   %Lf\n", va_arg(ap, long double));
                break;
            case POINTER:
                printf("Pointer:  %p\n", va_arg(ap, void *));
                break;
            case FUNCPTR:
                printf("Function: %p\n", va_arg(ap, funcptr));
        }
    }
    va_end(ap);
    return;
}


int foo(void)
{
    return(0);
}


void main()
{
    int type[]= { CHAR, FLOAT, POINTER, DOUBLE, FUNCPTR, 0 };

    printargs(type, 'a', 3.0, type, 1.5, foo);
}
