/*------------------------- DEMOFORM.C -------------------------*/
/*                                                              */
/*  This file contains the VISIONS FORM LIBRARY DEMO software.  */
/*                                                              */
/*         Copyright 1990 Dan Vogel & David Bernazzani          */
/*                                                              */
/*   Date        Initials        Comments                       */
/*                                                              */
/*  03/07/90       DCV     Initial Release 0.00                 */
/*--------------------------------------------------------------*/

#include <stdio.h>
#include <ctype.h>
#include "USERFORM.H"
#include "DEMOPROT.H"

static char *cnotice="VISIONS Copyright 1990 Dan Vogel & David Bernazzani";

/*--------------------------------------------------------------*/



/*----------------------------------------------*/
/*                 Run_Form                     */
/* This is the form library demonstration code. */
/* This demonstration creates several different */
/* forms that may be used to generate an order  */
/* for VISIONS registration or source code.     */
/*----------------------------------------------*/
int Run_Form()
{
   FORM_HEAD *name_form, *order_form, *format_form, *bill_form;
   FILE *o_file;
   char name[35];
   char address1[35];
   char address2[35];
   char city[16];
   char state[3];
   char zipcode[6];
   char donation[4];
   char list_ord[2], window_ord[2], menu_ord[2], form_ord[2], all_ord[2];
   char registration[2], print_order[2];
   char format_DD5[2], format_HD5[2], format_DD3[2];
   char num_print[5];
   unsigned long total_bill=0L;
   long int reg_cost;
   unsigned tax_doll, tax_cent;
   int result;

   /*------------------------------------------*/
   /* Create the various forms used to enter   */
   /* address, order, and billing information. */
   /*------------------------------------------*/
   CreateNameForm(&name_form,name,address1,address2,city,state,zipcode);
   CreateOrderForm(&order_form,list_ord,window_ord,menu_ord,form_ord,all_ord);
   CreateFormatForm(&format_form,format_DD5,format_HD5,format_DD3);
   CreateBillForm(&bill_form,donation,registration,print_order);

   /*----------------------------------------*/
   /* Now execute each form, but allow the   */
   /* user to abort with an ESC at any time. */
   /*----------------------------------------*/
   if ((result = FormEntry(name_form)) != -1)
   {
      if ((result = FormEntry(order_form)) != -1)
      {
         if ((result = FormEntry(format_form)) != -1)
         {
            result = FormEntry(bill_form);
            if ((result != -1) && (toupper(print_order[0]) == 'Y'))
            {
               /*---------------------------------------*/
               /* Print the order on LPT1 if the        */
               /* user has set the print order request. */
               /*---------------------------------------*/
               o_file = fopen("LPT1","w");
               fprintf(o_file,"                VISIONS Ordering Form\n\n");
               fprintf(o_file,"   For: %s\n",name);
               fprintf(o_file,"        %s\n",address1);
               if (strlen(address2) > 0)
                  fprintf(o_file,"        %s\n",address2);
               fprintf(o_file,"        %s, %s, %s\n\n",city,state,zipcode);
               fprintf(o_file," I wish to order the following:\n\n");
               if ((list_ord[0] >= '1') && (list_ord[0] <= '9'))
               {
                  format_num(((long)(list_ord[0]-'0')*45L),4,num_print);
                  fprintf(o_file,"     %c copies of the list sources    ($ 45.00 each)  $%s.00\n",list_ord[0],num_print);
                  total_bill = total_bill + (unsigned long)((int)(list_ord[0]-'0')*45) * 100L;
               }
               if ((window_ord[0] >= '1') && (window_ord[0] <= '9'))
               {
                  format_num(((long)(window_ord[0]-'0')*45L),4,num_print);
                  fprintf(o_file,"     %c copies of the window sources  ($ 45.00 each)  $%s.00\n",window_ord[0],num_print);
                  total_bill = total_bill + (unsigned long)((int)(window_ord[0]-'0')*45) * 100L;
               }
               if ((menu_ord[0] >= '1') && (menu_ord[0] <= '9'))
               {
                  format_num(((long)(menu_ord[0]-'0')*45L),4,num_print);
                  fprintf(o_file,"     %c copies of the menu sources    ($ 45.00 each)  $%s.00\n",menu_ord[0],num_print);
                  total_bill = total_bill + (unsigned long)((int)(menu_ord[0]-'0')*45) * 100L;
               }
               if ((form_ord[0] >= '1') && (form_ord[0] <= '9'))
               {
                  format_num(((long)(form_ord[0]-'0')*45L),4,num_print);
                  fprintf(o_file,"     %c copies of the form sources    ($ 45.00 each)  $%s.00\n",form_ord[0],num_print);
                  total_bill = total_bill + (unsigned long)((int)(form_ord[0]-'0')*45) * 100L;
               }
               if ((all_ord[0] >= '1') && (all_ord[0] <= '9'))
               {
                  format_num(((long)(all_ord[0]-'0')*149L),4,num_print);
                  fprintf(o_file,"     %c copies of all the sources     ($149.00 each)  $%s.00\n",all_ord[0],num_print);
                  total_bill = total_bill + (unsigned long)((int)(all_ord[0]-'0')*149) * 100L;
               }
               if (toupper(registration[0]) == 'X')
               {
                  reg_cost = 75L-(total_bill/100L);
                  if (reg_cost < 0L)
                     reg_cost = 0L;
                  format_num((long)reg_cost,4,num_print);
                  fprintf(o_file,"     Registration fee                ($ 75.00)       $%s.00\n",num_print);
                  if (total_bill < 7500L)
                     total_bill = 7500L;
               }
               if ((toupper(state[0]) == 'M') && (toupper(state[1]) == 'A'))
               {
                  tax_doll = total_bill / 20L;
                  tax_cent = tax_doll % 100L;
                  tax_doll = tax_doll / 100L;
                  format_num((long)tax_doll,4,num_print);
                  fprintf(o_file,"     State sales tax                 (5%c)            $%s.%2.2d\n",'%',num_print,tax_cent);
                  total_bill = total_bill + tax_doll * 100L + tax_cent;
               }
               if (strlen(donation) > 0)
               {
                  format_num((long)atol(donation),4,num_print);
                  fprintf(o_file,"     Donation                                        $%s.00\n",num_print);
                  total_bill = total_bill + (atol(donation) * 100L);
               }
               format_num((long)(total_bill/100L),4,num_print);
               fprintf(o_file,"     Total                                           $%s.%2.2d\n",num_print,(int)(total_bill % 100L));

               if (toupper(format_DD5[0]) == 'X')
                  fprintf(o_file,"\n  Send diskettes in 5 1/4 DD (360K) format.\n");
               else
                  if (toupper(format_HD5[0]) == 'X')
                     fprintf(o_file,"\n  Send diskettes in 5 1/4 HD (1.2M) format.\n");
                  else
                     if (toupper(format_DD3[0]) == 'X')
                        fprintf(o_file,"\n  Send diskettes in 3 1/2 DD (720K) format.\n");

               fprintf(o_file,"\n        Mail to:\n");
               fprintf(o_file,"            VISIONS\n");
               fprintf(o_file,"            c\\o Dan Vogel\n");
               fprintf(o_file,"            5 Richard Road\n");
               fprintf(o_file,"            Randolph, MA 02368\n");
               fprintf(o_file,"\n        Please make checks payable to Dan Vogel.\n");

               fclose(o_file);
            }
         }
      }
   }

   DeleteForm(name_form);    /*Destroy the forms that were used. */
   DeleteForm(order_form);
   DeleteForm(format_form);
   DeleteForm(bill_form);

   return(0);
}



/*-----------------------------------------------*/
/*               CreateNameForm                  */
/* This routine creates a form used for entering */
/* the name and address of the user.             */
/*-----------------------------------------------*/
CreateNameForm(name_form,name,address1,address2,city,state,zipcode)
FORM_HEAD **name_form;
char *name;
char *address1;
char *address2;
char *city;
char *state;
char *zipcode;
{
   FORM_FIELD *field_ptr;

   /*-------------------------------------------------------------------*/
   /* Define the basic form: location, border style, colors, and title. */
   /*-------------------------------------------------------------------*/
   DefineForm(name_form,5,5,11,70,
      DOUBLEBORDER,TEXT_BLUE,TEXT_WHITE,"VISIONS Address Form");
   /*------------------------------*/
   /* Add a form record (field).   */
   /* This field allows any input. */
   /*------------------------------*/
   AddToForm(*name_form, NULL, &field_ptr);
   /*-------------------------------*/
   /* Now fill in the record with a */
   /* prompt and a text entry area. */
   /* Both prompt and text areas    */
   /* have their own color specs.   */
   /*-------------------------------*/
   AddToPrompt(field_ptr, 5, 8, 5, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"Name:");
   strcpy(name,"");   /* Set the default value to NULL. */
   AddToText(field_ptr, 5, 17, 34, 
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,name);

   /*------------------------------------*/
   /* And create the rest of the fields. */
   /*------------------------------------*/
   AddToForm(*name_form, NULL, &field_ptr);
   AddToPrompt(field_ptr, 6, 8, 9, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"Address:");
   strcpy(address1,"");
   AddToText(field_ptr, 6, 17, 34,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,address1);

   AddToForm(*name_form, NULL, &field_ptr);
   strcpy(address2,"");            /* This is a field without a prompt! */
   AddToText(field_ptr, 7, 17, 34,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,address2);

   AddToForm(*name_form, NULL, &field_ptr);
   AddToPrompt(field_ptr, 8, 8, 5, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"City:");
   strcpy(city,"");
   AddToText(field_ptr, 8, 17, 15,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,city);

   AddToForm(*name_form, NULL, &field_ptr);
   AddToPrompt(field_ptr, 8, 33, 6, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"State:");
   strcpy(state,"");
   AddToText(field_ptr, 8, 40, 2,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,state);

   /*----------------------------------------*/
   /* This field requires integer input only.*/
   /*----------------------------------------*/
   AddToForm(*name_form, *IntOnly, &field_ptr);
   AddToPrompt(field_ptr, 8, 44, 8, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"Zipcode:");
   strcpy(zipcode,"");
   AddToText(field_ptr, 8, 53, 5,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,zipcode);

   AddToForm(*name_form, NULL, &field_ptr); /* A field without text entry. */
   AddToPrompt(field_ptr, 10, 12, 41, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,
      "Hit Esc to exit, or Enter to accept form.");

   return(0);
}



/*-----------------------------------------------*/
/*              CreateOrderForm                  */
/* This routine creates a form used for entering */
/* the source code orders by a user.             */
/*-----------------------------------------------*/
CreateOrderForm(order_form,list_ord,window_ord,menu_ord,form_ord,all_ord)
FORM_HEAD **order_form;
char *list_ord, *window_ord, *menu_ord, *form_ord, *all_ord;
{
   FORM_FIELD *field_ptr;

   /*-------------------------------------------------------------------*/
   /* Define the basic form: location, border style, colors, and title. */
   /*-------------------------------------------------------------------*/
   DefineForm(order_form,7,5,15,50,DOUBLEBORDER,
      TEXT_BLUE,TEXT_WHITE,"VISIONS Order Form");
   /*----------------------------*/
   /* Add a form record (field). */
   /*----------------------------*/
   AddToForm(*order_form, *IntOnly, &field_ptr);
   /*-------------------------------*/
   /* Now fill in the record with a */
   /* prompt and a text entry area. */
   /* Both prompt and text areas    */
   /* have their own color specs.   */
   /*-------------------------------*/
   AddToPrompt(field_ptr, 5, 8, 19, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"List Sources($ 45):");
   strcpy(list_ord,"");
   AddToText(field_ptr, 5, 36, 1,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,list_ord);

   /*------------------------------------*/
   /* And create the rest of the fields. */
   /*------------------------------------*/
   AddToForm(*order_form, *IntOnly, &field_ptr);
   AddToPrompt(field_ptr, 6, 8, 21, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"Window Sources($ 45):");
   strcpy(window_ord,"");
   AddToText(field_ptr, 6, 36, 1,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,window_ord);

   AddToForm(*order_form, *IntOnly, &field_ptr);
   AddToPrompt(field_ptr, 7, 8, 19, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"Menu Sources($ 45):");
   strcpy(menu_ord,"");
   AddToText(field_ptr, 7, 36, 1,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,menu_ord);

   AddToForm(*order_form, *IntOnly, &field_ptr);
   AddToPrompt(field_ptr, 8, 8, 19, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"Form Sources($ 45):");
   strcpy(form_ord,"");
   AddToText(field_ptr, 8, 36, 1,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,form_ord);

   AddToForm(*order_form, *IntOnly, &field_ptr);
   AddToPrompt(field_ptr, 9, 8, 26, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,
      "All VISIONS Sources($145):");
   strcpy(all_ord,"");
   AddToText(field_ptr, 9, 36, 1,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,all_ord);

   AddToForm(*order_form, NULL, &field_ptr);
   AddToPrompt(field_ptr, 11, 4, 42, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,
      "Please enter the quantity of each package.");

   AddToForm(*order_form, NULL, &field_ptr);
   AddToPrompt(field_ptr, 13, 5, 41, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,
      "Hit Esc to exit, or Enter to accept form.");

   return(0);
}


/*-----------------------------------------------*/
/*              CreateFormatForm                 */
/* This routine creates a form used for entering */
/* the required diskette format for ordered      */
/* sources and library copies.                   */
/*-----------------------------------------------*/
CreateFormatForm(format_form,format_DD5,format_HD5,format_DD3)
FORM_HEAD **format_form;
char *format_DD5, *format_HD5, *format_DD3;
{
   FORM_FIELD *field_ptr;

   /*-------------------------------------------------------------------*/
   /* Define the basic form: location, border style, colors, and title. */
   /*-------------------------------------------------------------------*/
   DefineForm(format_form,7,5,12,45,DOUBLEBORDER,
      TEXT_BLUE,TEXT_WHITE,"VISIONS Format Form");
   /*----------------------------*/
   /* Add a form record (field). */
   /*----------------------------*/
   AddToForm(*format_form, *XOnly, &field_ptr);
   /*-------------------------------*/
   /* Now fill in the record with a */
   /* prompt and a text entry area. */
   /* Both prompt and text areas    */
   /* have their own color specs.   */
   /*-------------------------------*/
   AddToPrompt(field_ptr, 6, 12, 15, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"5 1/4-DD (360K)");
   strcpy(format_DD5,"");
   AddToText(field_ptr, 6, 29, 1,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,format_DD5);

   /*------------------------------------*/
   /* And create the rest of the fields. */
   /*------------------------------------*/
   AddToForm(*format_form, NULL, &field_ptr);
   AddToPrompt(field_ptr, 4, 86, 21, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"Diskette Media Format");

   AddToForm(*format_form, NULL, &field_ptr);
   AddToPrompt(field_ptr, 5, 10, 21, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"X the appropriate box");

   AddToForm(*format_form, *XOnly, &field_ptr);
   AddToPrompt(field_ptr, 7, 12, 15, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"5 1/4-HD (1.2M)");
   strcpy(format_HD5,"");
   AddToText(field_ptr, 7, 29, 1,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,format_HD5);

   AddToForm(*format_form, *XOnly, &field_ptr);
   AddToPrompt(field_ptr, 8, 12, 15, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"3 1/2-DD (720K)");
   strcpy(format_DD3,"");
   AddToText(field_ptr, 8, 29, 1,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,format_DD3);

   AddToForm(*format_form, NULL, &field_ptr);
   AddToPrompt(field_ptr, 10, 3, 41, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,
      "Hit Esc to exit, or Enter to accept form.");

   return(0);
}



/*-----------------------------------------------*/
/*               CreateBillForm                  */
/* This routine creates a form used for entering */
/* any donation amounts, registering the library,*/
/* any generating a printed order form.          */
/*-----------------------------------------------*/
CreateBillForm(bill_form,donation,registration,print_order)
FORM_HEAD **bill_form;
char *donation, *registration, *print_order;
{
   FORM_FIELD *field_ptr;

   /*-------------------------------------------------------------------*/
   /* Define the basic form: location, border style, colors, and title. */
   /*-------------------------------------------------------------------*/
   DefineForm(bill_form,9,5,12,46,DOUBLEBORDER,
      TEXT_BLUE,TEXT_WHITE,"VISIONS Billing Form");
   /*----------------------------*/
   /* Add a form record (field). */
   /*----------------------------*/
   AddToForm(*bill_form, *IntOnly, &field_ptr);
   /*-------------------------------*/
   /* Now fill in the record with a */
   /* prompt and a text entry area. */
   /* Both prompt and text areas    */
   /* have their own color specs.   */
   /*-------------------------------*/
   AddToPrompt(field_ptr, 5, 8, 29, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,
      "Donation:             $   .00");
   strcpy(donation,"");
   AddToText(field_ptr, 5, 31, 3,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,donation);

   /*------------------------------------*/
   /* And create the rest of the fields. */
   /*------------------------------------*/
   AddToForm(*bill_form, *XOnly, &field_ptr);
   AddToPrompt(field_ptr, 6, 8, 27, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,
      "Registration (X or blank): ");
   strcpy(registration,"");
   AddToText(field_ptr, 6, 35, 1,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,registration);

   AddToForm(*bill_form, *YNOnly, &field_ptr);
   AddToPrompt(field_ptr, 8, 8, 33, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,
      "Print an order to LPT1 (Y or N)? ");
   strcpy(print_order,"");
   AddToText(field_ptr, 8, 41, 1,
      TEXT_WHITE,TEXT_BLACK,TEXT_BLACK,TEXT_WHITE,print_order);

   AddToForm(*bill_form, NULL, &field_ptr);
   AddToPrompt(field_ptr, 10, 3, 41, 
      TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,
      "Hit Esc to exit, or Enter to accept form.");

   return(0);
}



/*---------------------------------------------------------------*/
/*                        format_num                             */
/* This routine is used for genarating formatted numeric output. */
/* The number received, num, is converted into a string, digits, */
/* characters long with leading spaces intead of zeroes.  This   */
/* string is placed into the passed num_print character array.   */
/*---------------------------------------------------------------*/
int format_num(num,digits,num_print)
long num;
int digits;
char *num_print;
{
   int i, j;
   char dummy[11];

   sprintf(dummy,"%10.10ld",num);
   j = 11;
   for (i = digits;i >= 0; i--)
      num_print[i] = dummy[j--];
   for (i = 0; (i < digits) && (num_print[i] == '0'); i++)
      num_print[i] = ' ';
   return(0);
}



/*-----------------------------------------------------------*/
/*                        IntOnly                            */
/* This is a field input validation routine.  This routine   */
/* requires that all input for its string field be integers. */
/* Leadings spaces are allowed.                              */
/*-----------------------------------------------------------*/
int IntOnly(string)
char *string;
{
   int leading_space = -1;   /* Have not seen first digit. */
   int i;

   for (i=0; i<strlen(string); i++)
   {
      if (string[i] == ' ')
      {
         if (leading_space == 0)  /* Seen first digit? */
            leading_space = 1;    /* Yes now must be spaces! */
      }
      else
      {
         if (leading_space == 1)  /* Digit after trailing space? */
            return(-1);           /* Yes, error */
         if (leading_space == -1)
            leading_space++;
         if (isdigit(string[i]) == 0)
            return(-1);
      }      
   }
   return(0);
}




/*-----------------------------------------------------------*/
/*                          XOnly                            */
/* This is a field input validation routine.  This routine   */
/* requires that the input for its string field be either a  */
/* space or an x, either upper or lower case.  Lower case    */
/* entry is converted to upper case.                         */
/*-----------------------------------------------------------*/
int XOnly(string)
char *string;
{
   if (string[0] == 'x')
      string[0] = 'X';
   if ((string[0] == 'X') || (string[0] == ' '))
      return(0);
   return(-1);
}




/*-----------------------------------------------------------*/
/*                         YNOnly                            */
/* This is a field input validation routine.  This routine   */
/* requires that the input for its string field be either a  */
/* space or an n, or a y, either upper or lower case.  Lower */
/* case entry is converted to upper case.  A space is        */
/* converted to an N.                                        */
/*-----------------------------------------------------------*/
int YNOnly(string)
char *string;
{
   if (string[0] == ' ')
      string[0] = 'N';
   if (string[0] == 'y')
      string[0] = 'Y';
   if (string[0] == 'n')
      string[0] = 'N';
   if ((string[0] == 'Y') || (string[0] == 'N'))
      return(0);
   return(-1);
}
  