/*------------------------- DEMOMENU.C -------------------------*/
/*                                                              */
/*  This file contains the VISIONS LIBRARY MENU DEMO software.  */
/*                                                              */
/*         Copyright 1990 Dan Vogel & David Bernazzani          */
/*                                                              */
/*   Date        Initials        Comments                       */
/*                                                              */
/*  03/07/90       DCV     Initial Release 0.00                 */
/*--------------------------------------------------------------*/

#include <stdio.h>
#include "USERLIST.H"
#include "USERWIND.H"
#include "USERMENU.H"
#include "USERFORM.H"
#include "DEMOPROT.H"

static char *cnotice="VISIONS Copyright 1990 Dan Vogel & David Bernazzani";

/*--------------------------------------------------------------*/



/*----------------------------------------------*/
/*                Run_Menu                      */
/* This is the menu library demonstration code. */
/*----------------------------------------------*/
int Run_Menu()
{
   WINDOW_HEAD *clear_window;      /* Window to clear screen. */
   MENU_HEAD *new_menu;

   /*-------------------------------------------*/
   /* Create a window just to clear the screen. */
   /*-------------------------------------------*/
   DefineWindow(&clear_window, 1, 1, 24, 80,
      TEXT_BLACK, TEXT_WHITE, "", NOBORDER, FALSE, FALSE, TRUE);
   DisplayWindow(clear_window);

   /*-------------------------------------------*/ 
   /* Tell the user what this routine is about. */
   /*-------------------------------------------*/
   Menu_Intro();

   /*-------------------------------------------------*/
   /* Allow user to select the desired demonstration. */
   /*-------------------------------------------------*/
   DefineMenu(&new_menu, 7,7,1,1,
        SINGLEBORDER, HOT_EXEC_ON, TEXT_BLUE, TEXT_WHITE,
        TEXT_WHITE, TEXT_BLUE, "SELECT MENU DEMONSTRATION");

   AddToMenu(new_menu, "Hot Key Demonstration", 'H', 0, *Menu_Hot);
   AddToMenu(new_menu, "Auto-sizing of Menu", 'A', 0, *Menu_Auto);
   AddToMenu(new_menu, "File Defined Menu", 'F', 0, *Menu_File);
   AddToMenu(new_menu, "Exit Menu Demonstration", 'E', 1, NULL);

   /*---------------------------------*/
   /* Get and execute user selection. */
   /*---------------------------------*/
   AutoDisplayMenu(new_menu);

   /*---------------------------------*/
   /* And return menu memory to heap. */
   /*---------------------------------*/
   DeleteMenu(new_menu);

   RemoveWindow(clear_window);
   DeleteWindow(clear_window);
   return(0);
}



/*---------------------------------------------------------------*/
/*                         Menu_Hot                              */
/* This routine demonstrates the difference between menus        */
/* with hot key execution and without.  This is accomplished     */
/* by showing the user two essentially identical menus, with     */
/* and without the hot key execution feature enabled.  Actually  */
/* executing a menu function, either by hot key, or by selecting */
/* and hitting enter will display a dummy window to indicate     */
/* which selection was made.                                     */
/*---------------------------------------------------------------*/
int Menu_Hot()
{
   MENU_HEAD *new_menu;

   /*-------------------------------------------*/
   /* Allow user to see hot key execution       */
   /* by creating a menu with hot keys enabled. */
   /*-------------------------------------------*/
   DefineMenu(&new_menu, 7,7,1,1,
        SINGLEBORDER, HOT_EXEC_ON, TEXT_BLUE, TEXT_WHITE,
        TEXT_WHITE, TEXT_BLUE, 
        "Type 1, 2, or 3 to see Hot Key Execution");

   AddToMenu(new_menu, "1) Hot Key # 1", '1', 0, *Hot_1);
   AddToMenu(new_menu, "2) Hot Key # 2", '2', 0, *Hot_2);
   AddToMenu(new_menu, "3) Hot Key # 3", '3', 0, *Hot_3);

   /*---------------------------------*/
   /* Get and execute user selection. */
   /*---------------------------------*/
   AutoDisplayMenu(new_menu);

   /*---------------------------------*/
   /* And return menu memory to heap. */
   /*---------------------------------*/
   DeleteMenu(new_menu);

   /*----------------------------------------*/
   /* Now define the exact same menu without */
   /* hot key execution enabled, and an      */
   /* appropriately different title.         */
   /*----------------------------------------*/
   DefineMenu(&new_menu, 7,7,1,1,
        SINGLEBORDER, HOT_EXEC_OFF, TEXT_BLUE, TEXT_WHITE,
        TEXT_WHITE, TEXT_BLUE,
        "Type 1, 2, or 3 to see Hot Key Selection, then Enter to Execute");

   AddToMenu(new_menu, "1) Hot Key # 1", '1', 0, *Hot_1);
   AddToMenu(new_menu, "2) Hot Key # 2", '2', 0, *Hot_2);
   AddToMenu(new_menu, "3) Hot Key # 3", '3', 0, *Hot_3);

   /*---------------------------------*/
   /* Get and execute user selection. */
   /*---------------------------------*/
   AutoDisplayMenu(new_menu);

   /*---------------------------------*/
   /* And return menu memory to heap. */
   /*---------------------------------*/
   DeleteMenu(new_menu);

   return(0);
}




/*--------------------------------------------------------------*/
/*                       Menu_Auto                              */
/* This routine demonstrates the menu auto-sizing display       */
/* capability.  This is accomplished by defining a menu         */
/* size that is far too big for the actual size of the menu     */
/* titles and selections.  This oversize menu is then displayed */
/* using DisplayMenu.  After the user exits this menu, the      */
/* same menu is redisplayed using AutoDisplayMenu, which scales */
/* down the menu size to what is needed for the menu prompts    */
/* and title.                                                   */
/*--------------------------------------------------------------*/
int Menu_Auto()
{
   MENU_HEAD *auto_menu;

   /*------------------*/
   /* Define the menu. */
   /*------------------*/
   DefineMenu(&auto_menu, 5,5,19,70,
        SINGLEBORDER, HOT_EXEC_ON, TEXT_BLUE, TEXT_WHITE,
        TEXT_WHITE, TEXT_BLUE, "Menu Auto-Sizing Demonstration");

   AddToMenu(auto_menu, "Null selection", 'N', 0, NULL);
   AddToMenu(auto_menu, "Display same menu with auto-sizing", 'D', 1, NULL);
   AddToMenu(auto_menu, "Null selection", 'N', 0, NULL);
   AddToMenu(auto_menu, "Null selection", 'N', 0, NULL);
   AddToMenu(auto_menu, "Null selection", 'N', 0, NULL);

   /*---------------------------------------------*/
   /* Show the user the menu without auto-sizing. */
   /*---------------------------------------------*/
   DisplayMenu(auto_menu);

   /*-----------------------*/
   /* Now size it properly. */
   /*-----------------------*/
   AutoDisplayMenu(auto_menu);

   /*---------------------------------*/
   /* And return menu memory to heap. */
   /*---------------------------------*/
   DeleteMenu(auto_menu);

   return(0);
}




/*----------------------------------------------------------------*/
/*                        Menu_File                               */
/* The following routine demonstrates the use of the              */
/* DoFileMenu routine.  With this routine a user can execute      */
/* a menu that is defined within a separate file.  This means     */
/* that simple menu changes, like color, titles, and so, can      */
/* be made to a file defined menu without recompiling any code.   */
/* The drawback however is that a file defined menu can only      */
/* return a non-zero value indicating the selection made from     */
/* the menu, it can not execute a routine directly from the       */
/* menu execution!  The format of the file is defined in the user */
/* manual.  This should be referred to when modifying or creating */
/* a file defined menu.  The file defined menu for this routine   */
/* is FILEMENU.MNU.  The user should experiment with this file    */
/* using the demonstration program to display it before creating  */
/* a menu file from scratch.                                      */
/*----------------------------------------------------------------*/
int Menu_File()
{
   WINDOW_HEAD *file_window;
   int val;
   char buffer[81];

   /*------------------------------------------------------*/
   /* Display a window to tell the user what is happening. */
   /*------------------------------------------------------*/
   DefineWindow(&file_window, 1, 1, 24, 80,
        TEXT_BLUE, TEXT_WHITE, "VISIONS File Execution Demonstration",
        SINGLEBORDER, FALSE, FALSE, TRUE);
   DisplayWindow(file_window);
   WindMesg(9,5,
      "   The following menu is defined in the file FILEMENU.MNU. ");
   WindMesg(24,28,"Hit any key to continue.");

   GetKey();    /* Force the user to strike a key. */

   val = DoFileMenu("FILEMENU.MNU");   /* Execute the file menu. */

   /*---------------------------------------*/
   /* And tell the user the returned value. */
   /*---------------------------------------*/
   sprintf(buffer," The resulting value of the menu call was: %d",val);
   WindMesgPtr(file_window,12,7,buffer);

   GetKey();    /* Force the user to strike a key. */

   RemoveWindow(file_window);
   DeleteWindow(file_window);

   return(0);
}



/*-----------------------------------------------*/
/*                Menu_Intro                     */
/* Introduce the user to this demonstration,     */
/* explaining the purpose and what is happening. */
/*-----------------------------------------------*/
int Menu_Intro()
{
   WINDOW_HEAD *intro_window;

   DefineWindow(&intro_window, 1, 1, 24, 80,
        TEXT_BLUE, TEXT_WHITE, "VISIONS Menu Demonstration Introduction",
        SINGLEBORDER, FALSE, FALSE, TRUE);
   DisplayWindow(intro_window);
   WindMesg(8,5,"   The VISIONS menu library layers menu selection capability on top ");
   WindMesg(9,5," of VISIONS windows.  As a result, VISIONS menus have all the color, ");
   WindMesg(10,5," title, and border selections available from the window library.  In  ");
   WindMesg(11,5," addition to these choices, the user may select hot key execution, ");
   WindMesg(12,5," auto-sized menus, and file execution of menus.  Hot keys allow the  ");
   WindMesg(13,5," menu user to select and execute a menu item with a single key.  Auto-");
   WindMesg(14,5," sizing lets the programmer specify only the top left coordinate of the");
   WindMesg(15,5," menu, VISIONS determines the height and width.  Finally, file definition");
   WindMesg(16,5," of menus allows the user to specify the menu titles, coordinates, return");
   WindMesg(17,5," values, and contents in a file.  This allows menu modification without");
   WindMesg(18,5," recompiling.  File executed menus can not execute subroutines, but can");
   WindMesg(19,5," return a selected value.  The source code used to create this ");
   WindMesg(20,5," demonstration is supplied with the executable.");
   WindMesg(24,28,"Hit any key to continue.");

   GetKey();

   RemoveWindow(intro_window);
   DeleteWindow(intro_window);
   return(0);
}




/*-------------------------------------------------------*/
/*               Hot_1,  Hot_2,  Hot_3                   */
/* The following routines simply display an error window */
/* that indicates which routine is active.  These are    */
/* used to tell the operator which menu selection has    */
/* been activated for demonstration purposes.  More      */
/* useful from a programmer's point of view is that      */
/* these routines demonstrate the ErrWindow routine,     */
/* which displays a single string of text centered on    */
/* the screen and requires the user to strike a key      */
/* before ErrWindow returns.  While this routine is      */
/* not very flexible, it is a very quick way of          */
/* displaying a short error message to the user!         */
/*-------------------------------------------------------*/
int Hot_1()
{
   ErrWindow("This is Hot Key routine # 1");
   return(0);
}

int Hot_2()
{
   ErrWindow("This is Hot Key routine # 2");
   return(0);
}

int Hot_3()
{
   ErrWindow("This is Hot Key routine # 3");
   return(0);
}

                                      