/*-------------------------- DEMOVIS.C -------------------------*/
/*								*/
/*  This file contains the main VISION LIBRARY DEMO software.	*/
/*								*/
/*         Copyright 1990 Dan Vogel & David Bernazzani		*/
/*								*/
/*   Date	Initials	Comments			*/
/*								*/
/*  03/07/90	DCV		Initial Release 0.00.		*/
/*--------------------------------------------------------------*/

#include <stdio.h>
#include <dos.h>
#include <graph.h>

#include "USERMENU.H"
#include "DEMOPROT.H"

static char *cnotice="VISIONS Copyright 1990 Dan Vogel & David Bernazzani";

/*--------------------------------------------------------------*/

#define	MAIN_DEMO_TOP_Y		(BYTE)2
#define	MAIN_DEMO_TOP_X		(BYTE)2
#define	MAIN_DEMO_HEIGHT	(BYTE)9
#define	MAIN_DEMO_WIDTH		(BYTE)35
#define	MAIN_DEMO_BK_COLOR	TEXT_BLUE
#define	MAIN_DEMO_TXT_COLOR	TEXT_WHITE
#define	MAIN_DEMO_HBK_COLOR	TEXT_WHITE
#define	MAIN_DEMO_HTXT_COLOR	TEXT_BLUE

/*-----------------------------------------------------------*/
/*  This is the main program for the VISIONS demonstration.  */
/*   WARNING - Error checking has been removed for clarity.  */
/*          This should not be a normal practice.            */
/*-----------------------------------------------------------*/
main()
{
   MENU_HEAD *new_menu;	/* Pointer to the menu to be created. */

   InitWindow();

   /*------------------------------------------------*/
   /*  Display initial VISION logo and information.  */
   /*------------------------------------------------*/
   VISION_logo();
   Share_Policy();

   /*-------------------------------------------------*/
   /*  Now give the user a choice of demonstrations.  */
   /*  First build the demonstration selection menu.  */
   /*-------------------------------------------------*/
   DefineMenu(&new_menu,MAIN_DEMO_TOP_Y,MAIN_DEMO_TOP_X,
	MAIN_DEMO_HEIGHT,MAIN_DEMO_WIDTH,SINGLEBORDER,HOT_EXEC_ON,
	MAIN_DEMO_BK_COLOR, MAIN_DEMO_TXT_COLOR, 
	MAIN_DEMO_HBK_COLOR, MAIN_DEMO_HTXT_COLOR,
	"VISIONS LIBRARY DEMONSTRATION");
   AddToMenu(new_menu, "List Demonstration", 'L', 0, *List_Demo);
   AddToMenu(new_menu, "Window Demonstration",	'W', 0,	*Window_Demo);
   AddToMenu(new_menu, "Menu Demonstration", 'M', 0, *Menu_Demo);
   AddToMenu(new_menu, "Form Demonstration",'F', 0, *Form_Demo);
   AddToMenu(new_menu, "Shareware Policy",'S', 0, *Share_Policy);
   AddToMenu(new_menu, "Exit VISIONS Demonstration",'E', 1, NULL);

   /*----------------------------------------------------------*/
   /* Now automatically size and display the menu, and execute */
   /* the menu routines based upon user selection.	       */
   /*----------------------------------------------------------*/
   AutoDisplayMenu(new_menu);

   /*-------------------------------------------------*/
   /* Release the memory used by the menu definition. */
   /*-------------------------------------------------*/
   DeleteMenu(new_menu);

exit:
   ExitWindow();		/*Clear screen and reset mode */

   exit(0);
}




/*-------------------------------------------*/
/*              VISION_logo                  */
/* This is the VISIONS logo display routine. */
/*-------------------------------------------*/
int VISION_logo()
{
   WINDOW_HEAD *window_ptr;
   int i;
   char block[81];

   DefineWindow(&window_ptr,1,1,24,80,TEXT_BLUE,TEXT_BWHITE,
	NULL, SINGLEBORDER, FALSE, FALSE, TRUE);
   DisplayWindow(window_ptr);

   /*-----------------------------------------*/
   /* Block out the logo in X's so its        */
   /* legible, and then convert it to blocks. */
   /*-----------------------------------------*/
   strcpy(block," XX       XX   XXXXX      XXX     XXXXX      XXX      X   X      XXX");
   for (i=0;block[i] != 0;i++)
      if (block[i] == 'X')
         block[i] = (char)219;
   WindMesg(5,6,block);

   strcpy(block,"  XX     XX      X       X          X       X   X     XX  X     X");
   for (i=0;block[i] != 0;i++)
      if (block[i] == 'X')
         block[i] = (char)219;
   WindMesg(6,6,block);
   strcpy(block,"   XX   XX       X        XX        X       X   X     X X X      XX");
   for (i=0;block[i] != 0;i++)
      if (block[i] == 'X')
         block[i] = (char)219;
   WindMesg(7,6,block);
   strcpy(block,"    XX XX        X          X       X       X   X     X  XX        X");
   for (i=0;block[i] != 0;i++)
      if (block[i] == 'X')
         block[i] = (char)219;
   WindMesg(8,6,block);
   strcpy(block,"     XXX       XXXXX     XXX      XXXXX      XXX      X   X     XXX");
   for (i=0;block[i] != 0;i++)
      if (block[i] == 'X')
         block[i] = (char)219;
   WindMesg(9,6,block);

   WindMesg(12,6,"                     Library Demonstration Program");
   WindMesg(15,6,"                           Copyright 1990");
   WindMesg(17,6,"                            by Dan Vogel");
   WindMesg(19,6,"                        and David Bernazzani");
   WindMesg(24,28,"Hit any key to continue.");

   GetKey();

   RemoveWindow(window_ptr);
   DeleteWindow(window_ptr);

   return(0);
}



/*--------------------------------------*/
/*            Share_Policy              */
/* This is the shareware policy display */
/* window for the VISIONS librarys.     */
/*--------------------------------------*/
int Share_Policy()
{
   WINDOW_HEAD *window_ptr;

   DefineWindow(&window_ptr,1,1,24,80,TEXT_BLUE,TEXT_BWHITE,
	NULL, SINGLEBORDER, FALSE, FALSE, TRUE);
   DisplayWindow(window_ptr);


   WindMesg(4,3,"                          VISIONS Library");
   WindMesg(7,3,"  The VISIONS library is a programmer's toolkit consisting of a list module,");
   WindMesg(8,3,"a windows module, a menus module, and a forms module.  Each module provides");
   WindMesg(9,3,"the programmer with a set of routines for implementing the basic functions");
   WindMesg(10,3,"associated with that module, whether it be pop up menus or form entry");
   WindMesg(11,3,"screens.  The windows provided by this program are text windows only and");
   WindMesg(12,3,"have been written for use with VGA, EGA, MCGA, CGA, or MGA video systems.");
   WindMesg(13,3,"This program gives examples of library functions, provides an on-line set");
   WindMesg(14,3,"of programmer's reference manuals for the library, and also allows the user");
   WindMesg(15,3,"to view the source code that generates this demonstration.  The library was");
   WindMesg(16,3,"compiled using Microsoft C 5.1 large model.  Compilation specific code has ");
   WindMesg(17,3,"been separated into a single file making it easy to port the library, for ");
   WindMesg(18,3,"those interested in purchasing the source rights.");
   WindMesg(24,28,"Hit any key to continue.");

   GetKey();


   WindMesg(7,3,"                                                                            ");
   WindMesg(8,3,"  This demonstration program, both executable and source provided, may be   ");
   WindMesg(9,3,"freely copied and distributed without charge.  The VISIONS library file     ");
   WindMesg(10,3,"provided with this demonstration is a full and complete VISIONS library that");
   WindMesg(11,3,"may be used only for home personal use.  A donation, suggested $25, to the  ");
   WindMesg(12,3,"VISIONS developers would be appreciated.  Any use of the VISIONS library for");
   WindMesg(13,3,"development of software to be sold must be registered with the developers.  ");
   WindMesg(14,3,"Registration cost is $75 per user and entitles the user to royalty-free use ");
   WindMesg(15,3,"of VISIONS as part of an executable program.  The executable program must   ");
   WindMesg(16,3,"give credits to VISIONS and its developers in any logo screens or manuals.  ");
   WindMesg(17,3,"   This library may not be sold or copied, except as free shareware in its  ");
   WindMesg(18,3,"original state, without the express written consent of the developers.  The ");
   WindMesg(19,3,"developers make no claims or warranties for the VISIONS library in any form.");
   WindMesg(20,3,"                                                                            ");

   WindMesg(24,28,"Hit any key to continue.");

   GetKey();

   WindMesg(8,3,"   Source code for the VISIONS library is available for the prices listed   ");
   WindMesg(9,3,"below.  Purchasing the VISIONS source code entitles the user to make his or ");
   WindMesg(10,3,"her own modifications to the VISIONS library, but does not permit the user  ");
   WindMesg(11,3,"to sell or distribute either the source or executable library code in       ");
   WindMesg(12,3,"either its original or modified state.  The modified library may still be   ");
   WindMesg(13,3,"used as part of a product (executable program) without royalty, although    ");
   WindMesg(14,3,"VISIONS and its developers are to receive credits in the developed programs ");
   WindMesg(15,3,"and their manuals.  Registration is still required when source code is      ");
   WindMesg(16,3,"purchased, but the fee may be used as a credit for source code purchase.    ");
   WindMesg(17,3,"   Site licensing can be discussed with the developers of VISIONS as needed ");
   WindMesg(18,3,"for multiple development stations.                                          ");
   WindMesg(19,3,"                                                                            ");
   WindMesg(20,3,"                                                                            ");
   WindMesg(24,28,"Hit any key to continue.");

   GetKey();

   WindMesg(2,3,"                      VISIONS Ordering Information                          ");
   WindMesg(3,3,"                                                                            ");
   WindMesg(4,3,"   Formats available:  3 1/2\" diskettes, 720Kb                              ");
   WindMesg(5,3,"                       5 1/4\" diskettes, 360Kb and 1.2Mb                    ");
   WindMesg(6,3,"   Prices:   VISIONS List library sources      $  45.00 (all sources include");
   WindMesg(7,3,"             VISIONS Window library sources    $  45.00  separate compiler  ");
   WindMesg(8,3,"             VISIONS Menu library sources      $  45.00  specific files.)   ");
   WindMesg(9,3,"             VISIONS Form library sources      $  45.00                     ");
   WindMesg(10,3,"             VISIONS package (all 4 modules)   $ 149.00                     ");
   WindMesg(11,3,"   Please add sales tax as appropriate (5% in Massachusetts).               ");
   WindMesg(12,3,"                                                                            ");
   WindMesg(13,3,"   Send orders, requests, and comments to:                                  ");
   WindMesg(14,3,"                                                                            ");
   WindMesg(15,3,"                            Dan Vogel                                       ");
   WindMesg(16,3,"                            5 Richard Road                                  ");
   WindMesg(17,3,"                            Randolph, Mass.  02368                          ");
   WindMesg(18,3,"                                                                            ");
   WindMesg(19,3,"   The VISIONS form library demonstration may also be used to generate a    ");
   WindMesg(20,3,"source code order form.                                                     ");
   WindMesg(21,3,"   Comments and suggestions for library improvements are not only welcome,  ");
   WindMesg(22,3,"but encouraged!  We will also try to answer questions, time permitting, if  ");
   WindMesg(23,3,"a self-addressed stamped envelope is included.                              ");

   GetKey();

   RemoveWindow(window_ptr);
   DeleteWindow(window_ptr);
   return(0);
}





/*-------------------------------------*/
/* List demonstration selection menus. */
/*-------------------------------------*/

#define  LIST_DEMO_TOP_Y                11
#define  LIST_DEMO_TOP_X                10
#define  LIST_DEMO_HEIGHT                7
#define  LIST_DEMO_WIDTH                25
#define  LIST_DEMO_BK_COLOR          TEXT_BLUE
#define  LIST_DEMO_TXT_COLOR         TEXT_WHITE
#define  LIST_DEMO_HBK_COLOR         TEXT_WHITE
#define  LIST_DEMO_HTXT_COLOR        TEXT_BLUE



/*---------------------------------------------------*/
/*                  List_Demo                        */
/* This is the list demonstration menu.  The user    */
/* may actually execute a demonstration, or view the */
/* demonstration source code.                        */
/*---------------------------------------------------*/
int List_Demo()
{
   MENU_HEAD *new_menu;

   /*------------------------------------------------------*/
   /*  First build the list demonstration selection menu.  */
   /*------------------------------------------------------*/
   DefineMenu(&new_menu, LIST_DEMO_TOP_Y, LIST_DEMO_TOP_X,
        LIST_DEMO_HEIGHT, LIST_DEMO_WIDTH, SINGLEBORDER, HOT_EXEC_ON,
        LIST_DEMO_BK_COLOR, LIST_DEMO_TXT_COLOR, 
        LIST_DEMO_HBK_COLOR, LIST_DEMO_HTXT_COLOR,
        "VISIONS LIST LIBRARY DEMONSTRATION");

   AddToMenu(new_menu, "Run List Demonstration", 'R', 0, *Run_List);
   AddToMenu(new_menu, "Display List Demonstration Source",
	 'D', 0, *Display_List);
   AddToMenu(new_menu, "View List Manual", 'V', 0, *View_List_Manual);
   AddToMenu(new_menu, "Exit List Demonstration", 'E', 1, NULL);

   /*---------------------------------*/
   /* Get and execute user selection. */
   /*---------------------------------*/
   AutoDisplayMenu(new_menu);

   /*---------------------------------*/
   /* And return menu memory to heap. */
   /*---------------------------------*/
   DeleteMenu(new_menu);

   return(0);
}




#define  DISP_LIST_TOPY                  1
#define  DISP_LIST_TOPX                  1
#define  DISP_LIST_HEIGHT               24
#define  DISP_LIST_WIDTH                80
#define  DISP_LIST_BK_COLOR          TEXT_BLUE
#define  DISP_LIST_TXT_COLOR         TEXT_WHITE


/*--------------------------------------------------------------*/
/*                       Display_List                           */
/* This is the routine to display the list library source code. */
/*--------------------------------------------------------------*/
int Display_List()
{
   /*---------------------------------------------------------*/
   /* Display the source code using the help window facility. */
   /*---------------------------------------------------------*/
   HelpWindow(DISP_LIST_TOPY, DISP_LIST_TOPX, 
        DISP_LIST_HEIGHT, DISP_LIST_WIDTH,
        DISP_LIST_BK_COLOR, DISP_LIST_TXT_COLOR,
        SINGLEBORDER,"List Demonstration Source Code", "DEMOLIST.C");
   return(0);
}




#define  VIEW_LIST_TOPY                1
#define  VIEW_LIST_TOPX                1
#define  VIEW_LIST_HEIGHT             24
#define  VIEW_LIST_WIDTH              80
#define  VIEW_LIST_BK_COLOR        TEXT_BLUE
#define  VIEW_LIST_TXT_COLOR       TEXT_BWHITE


/*-------------------------------------------------*/
/*              View_List_Manual                   */
/* This is the routine to display the list manual. */
/*-------------------------------------------------*/
int View_List_Manual()
{
   /*----------------------------------------------------*/
   /* Display the manual using the help window facility. */
   /*----------------------------------------------------*/
   HelpWindow(VIEW_LIST_TOPY, VIEW_LIST_TOPX, 
        VIEW_LIST_HEIGHT, VIEW_LIST_WIDTH,
        VIEW_LIST_BK_COLOR, VIEW_LIST_TXT_COLOR,
        SINGLEBORDER,"VISIONS List Manual", "VIS_LIST.TXT");
   return(0);
}




/*---------------------------------------*/
/* Window demonstration selection menus. */
/*---------------------------------------*/

#define  WINDOW_DEMO_TOP_Y                11
#define  WINDOW_DEMO_TOP_X                10
#define  WINDOW_DEMO_HEIGHT                7
#define  WINDOW_DEMO_WIDTH                25
#define  WINDOW_DEMO_BK_COLOR        TEXT_BLUE
#define  WINDOW_DEMO_TXT_COLOR       TEXT_WHITE
#define  WINDOW_DEMO_HBK_COLOR       TEXT_WHITE
#define  WINDOW_DEMO_HTXT_COLOR      TEXT_BLUE



/*-----------------------------------------------------*/
/*                  Window_Demo                        */
/* This is the window demonstration menu.  The user    */
/* may actually execute a demonstration, or view the   */
/* demonstration source code.                          */
/*-----------------------------------------------------*/
int Window_Demo()
{
   MENU_HEAD *new_menu;

   /*--------------------------------------------------------*/
   /*  First build the window demonstration selection menu.  */
   /*--------------------------------------------------------*/
   DefineMenu(&new_menu, WINDOW_DEMO_TOP_Y, WINDOW_DEMO_TOP_X,
        WINDOW_DEMO_HEIGHT, WINDOW_DEMO_WIDTH, SINGLEBORDER, HOT_EXEC_ON,
        WINDOW_DEMO_BK_COLOR, WINDOW_DEMO_TXT_COLOR, 
        WINDOW_DEMO_HBK_COLOR, WINDOW_DEMO_HTXT_COLOR,
        "VISIONS WINDOW LIBRARY DEMONSTRATION");

   AddToMenu(new_menu, "Run Window Demonstration", 'R', 0, *Run_Window);
   AddToMenu(new_menu, "Display Window Demonstration Source", 
        'D', 0, *Display_Window);
   AddToMenu(new_menu, "View Window Manual", 'V', 0, *View_Window_Manual);
   AddToMenu(new_menu, "Exit Window Demonstration", 'E', 1, NULL);

   /*---------------------------------*/
   /* Get and execute user selection. */
   /*---------------------------------*/
   AutoDisplayMenu(new_menu);

   /*---------------------------------*/
   /* And return menu memory to heap. */
   /*---------------------------------*/
   DeleteMenu(new_menu);

   return(0);
}





#define  DISP_WINDOW_TOPY                1
#define  DISP_WINDOW_TOPX                1
#define  DISP_WINDOW_HEIGHT             24
#define  DISP_WINDOW_WIDTH              80
#define  DISP_WINDOW_BK_COLOR        TEXT_BLUE
#define  DISP_WINDOW_TXT_COLOR       TEXT_WHITE


/*----------------------------------------------------------------*/
/*                        Display_Window                          */
/* This is the routine to display the window library source code. */
/*----------------------------------------------------------------*/
int Display_Window()
{
   /*---------------------------------------------------------*/
   /* Display the source code using the help window facility. */
   /*---------------------------------------------------------*/
   HelpWindow(DISP_WINDOW_TOPY, DISP_WINDOW_TOPX, 
        DISP_WINDOW_HEIGHT, DISP_WINDOW_WIDTH,
        DISP_WINDOW_BK_COLOR, DISP_WINDOW_TXT_COLOR,
        SINGLEBORDER,"Window Demonstration Source Code", "DEMOWIND.C");
   return(0);
}





#define  VIEW_WINDOW_TOPY                1
#define  VIEW_WINDOW_TOPX                1
#define  VIEW_WINDOW_HEIGHT             24
#define  VIEW_WINDOW_WIDTH              80
#define  VIEW_WINDOW_BK_COLOR        TEXT_BLUE
#define  VIEW_WINDOW_TXT_COLOR       TEXT_BWHITE


/*---------------------------------------------------*/
/*               View_Window_Manual                  */
/* This is the routine to display the window manual. */
/*---------------------------------------------------*/
int View_Window_Manual()
{
   /*----------------------------------------------------*/
   /* Display the manual using the help window facility. */
   /*----------------------------------------------------*/
   HelpWindow(VIEW_WINDOW_TOPY, VIEW_WINDOW_TOPX, 
        VIEW_WINDOW_HEIGHT, VIEW_WINDOW_WIDTH,
        VIEW_WINDOW_BK_COLOR, VIEW_WINDOW_TXT_COLOR,
        SINGLEBORDER,"VISIONS Window Manual", "VIS_WIND.TXT");
   return(0);
}





/*-------------------------------------*/
/* Menu demonstration selection menus. */
/*-------------------------------------*/

#define  MENU_DEMO_TOP_Y                11
#define  MENU_DEMO_TOP_X                10
#define  MENU_DEMO_HEIGHT                7
#define  MENU_DEMO_WIDTH                25
#define  MENU_DEMO_BK_COLOR         TEXT_BLUE
#define  MENU_DEMO_TXT_COLOR        TEXT_WHITE
#define  MENU_DEMO_HBK_COLOR        TEXT_WHITE
#define  MENU_DEMO_HTXT_COLOR       TEXT_BLUE



/*---------------------------------------------------*/
/*                  Menu_Demo                        */
/* This is the menu demonstration menu.  The user    */
/* may actually execute a demonstration, or view the */
/* demonstration source code.                        */
/*---------------------------------------------------*/
int Menu_Demo()
{
   MENU_HEAD *new_menu;

   /*------------------------------------------------------*/
   /*  First build the menu demonstration selection menu.  */
   /*------------------------------------------------------*/
   DefineMenu(&new_menu, MENU_DEMO_TOP_Y, MENU_DEMO_TOP_X,
        MENU_DEMO_HEIGHT, MENU_DEMO_WIDTH, SINGLEBORDER, HOT_EXEC_ON,
        MENU_DEMO_BK_COLOR, MENU_DEMO_TXT_COLOR, 
        MENU_DEMO_HBK_COLOR, MENU_DEMO_HTXT_COLOR,
        "VISIONS MENU LIBRARY DEMONSTRATION");

   AddToMenu(new_menu, "Run Menu Demonstration", 'R', 0, *Run_Menu);
   AddToMenu(new_menu, "Display Menu Demonstration Source", 
        'D', 0, *Display_Menu);
   AddToMenu(new_menu, "View Menu Manual", 'V', 0, *View_Menu_Manual);
   AddToMenu(new_menu, "Exit Menu Demonstration", 'E', 1, NULL);

   /*---------------------------------*/
   /* Get and execute user selection. */
   /*---------------------------------*/
   AutoDisplayMenu(new_menu);

   /*---------------------------------*/
   /* And return menu memory to heap. */
   /*---------------------------------*/
   DeleteMenu(new_menu);

   return(0);
}




#define  DISP_MENU_TOPY                1
#define  DISP_MENU_TOPX                1
#define  DISP_MENU_HEIGHT             24
#define  DISP_MENU_WIDTH              80
#define  DISP_MENU_BK_COLOR        TEXT_BLUE
#define  DISP_MENU_TXT_COLOR       TEXT_WHITE


/*--------------------------------------------------------------*/
/*                      Display_Menu                            */
/* This is the routine to display the menu library source code. */
/*--------------------------------------------------------------*/
int Display_Menu()
{
   /*---------------------------------------------------------*/
   /* Display the source code using the help window facility. */
   /*---------------------------------------------------------*/
   HelpWindow(DISP_MENU_TOPY, DISP_MENU_TOPX, 
        DISP_MENU_HEIGHT, DISP_MENU_WIDTH,
        DISP_MENU_BK_COLOR, DISP_MENU_TXT_COLOR,
        SINGLEBORDER,"Menu Demonstration Source Code", "DEMOMENU.C");
   return(0);
}



#define  VIEW_MENU_TOPY                1
#define  VIEW_MENU_TOPX                1
#define  VIEW_MENU_HEIGHT             24
#define  VIEW_MENU_WIDTH              80
#define  VIEW_MENU_BK_COLOR        TEXT_BLUE
#define  VIEW_MENU_TXT_COLOR       TEXT_BWHITE


/*-------------------------------------------------*/
/*               View_Menu_Manual                  */
/* This is the routine to display the menu manual. */
/*-------------------------------------------------*/
int View_Menu_Manual()
{
   /*----------------------------------------------------*/
   /* Display the manual using the help window facility. */
   /*----------------------------------------------------*/
   HelpWindow(VIEW_MENU_TOPY, VIEW_MENU_TOPX, 
        VIEW_MENU_HEIGHT, VIEW_MENU_WIDTH,
        VIEW_MENU_BK_COLOR, VIEW_MENU_TXT_COLOR,
        SINGLEBORDER,"VISIONS Menu Manual", "VIS_MENU.TXT");
   return(0);
}




/*-------------------------------------*/
/* Form demonstration selection menus. */
/*-------------------------------------*/

#define  FORM_DEMO_TOP_Y                11
#define  FORM_DEMO_TOP_X                10
#define  FORM_DEMO_HEIGHT                7
#define  FORM_DEMO_WIDTH                25
#define  FORM_DEMO_BK_COLOR         TEXT_BLUE
#define  FORM_DEMO_TXT_COLOR        TEXT_WHITE
#define  FORM_DEMO_HBK_COLOR        TEXT_WHITE
#define  FORM_DEMO_HTXT_COLOR       TEXT_BLUE



/*---------------------------------------------------*/
/*                  Form_Demo                        */
/* This is the form demonstration menu.  The user    */
/* may actually execute a demonstration, or view the */
/* demonstration source code.                        */
/*---------------------------------------------------*/
int Form_Demo()
{
   MENU_HEAD *new_menu;

   /*------------------------------------------------------*/
   /*  First build the form demonstration selection menu.  */
   /*------------------------------------------------------*/
   DefineMenu(&new_menu, FORM_DEMO_TOP_Y, FORM_DEMO_TOP_X,
        FORM_DEMO_HEIGHT, FORM_DEMO_WIDTH, SINGLEBORDER, HOT_EXEC_ON,
        FORM_DEMO_BK_COLOR, FORM_DEMO_TXT_COLOR, 
        FORM_DEMO_HBK_COLOR, FORM_DEMO_HTXT_COLOR,
        "VISIONS FORM LIBRARY DEMONSTRATION");

   AddToMenu(new_menu, "Run Form Demonstration", 'R', 0, *Run_Form);
   AddToMenu(new_menu, "Display Form Demonstration Source", 
        'D', 0, *Display_Form);
   AddToMenu(new_menu, "View Form Manual", 'V', 0, *View_Form_Manual);
   AddToMenu(new_menu, "Exit Form Demonstration", 'E', 1, NULL);

   /*---------------------------------*/
   /* Get and execute user selection. */
   /*---------------------------------*/
   AutoDisplayMenu(new_menu);

   /*---------------------------------*/
   /* And return menu memory to heap. */
   /*---------------------------------*/
   DeleteMenu(new_menu);

   return(0);
}




#define  DISP_FORM_TOPY                1
#define  DISP_FORM_TOPX                1
#define  DISP_FORM_HEIGHT             24
#define  DISP_FORM_WIDTH              80
#define  DISP_FORM_BK_COLOR       TEXT_BLUE
#define  DISP_FORM_TXT_COLOR      TEXT_WHITE


/*--------------------------------------------------------------*/
/*                       Display_Form                           */
/* This is the routine to display the form library source code. */
/*--------------------------------------------------------------*/
int Display_Form()
{
   /*---------------------------------------------------------*/
   /* Display the source code using the help window facility. */
   /*---------------------------------------------------------*/
   HelpWindow(DISP_FORM_TOPY, DISP_FORM_TOPX, 
        DISP_FORM_HEIGHT, DISP_FORM_WIDTH,
        DISP_FORM_BK_COLOR, DISP_FORM_TXT_COLOR,
        SINGLEBORDER,"Form Demonstration Source Code", "DEMOFORM.C");
   return(0);
}



#define  VIEW_FORM_TOPY                1
#define  VIEW_FORM_TOPX                1
#define  VIEW_FORM_HEIGHT             24
#define  VIEW_FORM_WIDTH              80
#define  VIEW_FORM_BK_COLOR        TEXT_BLUE
#define  VIEW_FORM_TXT_COLOR       TEXT_BWHITE


/*-------------------------------------------------*/
/*               View_Form_Manual                  */
/* This is the routine to display the form manual. */
/*-------------------------------------------------*/
int View_Form_Manual()
{
   /*----------------------------------------------------*/
   /* Display the manual using the help window facility. */
   /*----------------------------------------------------*/
   HelpWindow(VIEW_FORM_TOPY, VIEW_FORM_TOPX, 
        VIEW_FORM_HEIGHT, VIEW_FORM_WIDTH,
        VIEW_FORM_BK_COLOR, VIEW_FORM_TXT_COLOR,
        SINGLEBORDER,"VISIONS Form Manual", "VIS_FORM.TXT");
   return(0);
}

                 