/*------------------------- DEMOWIND.C -------------------------*/
/*                                                              */
/* This file contains the VISIONS LIBRARY WINDOW DEMO software. */
/*                                                              */
/*         Copyright 1990 Dan Vogel & David Bernazzani          */
/*                                                              */
/*   Date        Initials        Comments                       */
/*                                                              */
/*  03/07/90       DCV       Initial Release 0.00               */
/*--------------------------------------------------------------*/

#include <stdio.h>
#include "USERLIST.H"
#include "USERWIND.H"
#include "USERMENU.H"
#include "USERFORM.H"
#include "DEMOPROT.H"

static char *cnotice="VISIONS Copyright 1990 Dan Vogel & David Bernazzani";

/*--------------------------------------------------------------*/




/*-----------------------------------------------------*/
/*                  Run_Window                         */
/*  This is the window library demonstration code.     */
/* The window library demonstration consists of three  */
/* parts, first an introduction to the windows library */
/* demonstration, second a display of multiple windows */
/* of many colors, sizes, and types, and finally an    */
/* interactive window developer and display.           */
/*  NOTE: In general, error checking has been removed  */
/* for the sake of code clarity.  Users should check   */
/* return values for errors!                           */
/*-----------------------------------------------------*/
int Run_Window()
{
   WINDOW_HEAD *clear_window;      /* Window to clear screen. */
   MENU_HEAD *new_menu;

   /*-------------------------------------------*/
   /* Create a window just to clear the screen. */
   /*-------------------------------------------*/
   DefineWindow(&clear_window, 1, 1, 24, 80,
      TEXT_BLACK, TEXT_WHITE, "", NOBORDER, FALSE, FALSE, TRUE);
   DisplayWindow(clear_window);

   /*-------------------------------------------*/ 
   /* Tell the user what this routine is about. */
   /*-------------------------------------------*/
   Window_Intro();

   /*--------------------------------------------------------*/
   /*  First build the window demonstration selection menu.  */
   /*--------------------------------------------------------*/
   DefineMenu(&new_menu, 7,7,1,1,
        SINGLEBORDER, HOT_EXEC_ON, TEXT_BLUE, TEXT_WHITE,
        TEXT_WHITE, TEXT_BLUE, "SELECT WINDOW DEMONSTRATION");

   AddToMenu(new_menu, "Colors of Windows", 'C', 0, *Colors_Window);
   AddToMenu(new_menu, "Borders of Windows", 'B', 0, *Borders_Window);
   AddToMenu(new_menu, "Exploding/Imploding Windows",
        'E', 0, *Exploding_Window);
   AddToMenu(new_menu, "MultiWindow Display", 'M', 0, *Multiple_Window);
   AddToMenu(new_menu, "Interactive Window Demo",
        'I', 0, *Interactive_Windows);
   AddToMenu(new_menu, "Exit Window Demonstration", 'E', 1, NULL);

   /*---------------------------------*/
   /* Get and execute user selection. */
   /*---------------------------------*/
   AutoDisplayMenu(new_menu);

   /*---------------------------------*/
   /* And return menu memory to heap. */
   /*---------------------------------*/
   DeleteMenu(new_menu);

   RemoveWindow(clear_window);
   DeleteWindow(clear_window);
   return(0);
}



/*-----------------------------------------------------*/
/*                 Colors_Window                       */
/* This routine displays a full screen window showing  */
/* all possible colors available in VISIONS for        */
/* backgrounds and text.  This is also useful for      */
/* determining the mappings of different color values  */
/* on a monochrome adaptor!  Note that VISIONS will    */
/* automatically convert colors to monochrome if there */
/* is no color adaptor.  Furthermore, VISIONS disables */
/* background color blinking in color systems in order */
/* to provide eight more colors.                       */
/*-----------------------------------------------------*/
int Colors_Window()
{
   WINDOW_HEAD *window_ptr;

   /*-----------------------------------*/
   /* Set up the window and display it. */
   /*-----------------------------------*/
   DefineWindow(&window_ptr, 1, 1, 24, 80,
        TEXT_BLACK, TEXT_WHITE, "Colors Display",
        DOUBLEBORDER, FALSE, FALSE, TRUE);
   DisplayWindow(window_ptr);

   /*------------------------------------------------*/
   /* Now fill in the window with color information. */
   /*------------------------------------------------*/
   SetTextColor(TEXT_WHITE);  SetBkColor(TEXT_BLACK); 
   WindMesg(4,13,"Background Colors");
   WindMesg(4,53,"Text Colors");

   SetTextColor(TEXT_WHITE);  SetBkColor(TEXT_BLACK); 
   WindMesg(6,13,"Black Background");
   SetBkColor(TEXT_BLUE);     WindMesg(7,13,"Blue Background");
   SetBkColor(TEXT_GREEN);    WindMesg(8,13,"Green Background");
   SetBkColor(TEXT_CYAN);     WindMesg(9,13,"Cyan Background");
   SetBkColor(TEXT_RED);      WindMesg(10,13,"Red Background");
   SetBkColor(TEXT_MAGENTA);  WindMesg(11,13,"Magenta Background");
   SetBkColor(TEXT_BROWN);    WindMesg(12,13,"Brown Background");
   SetBkColor(TEXT_WHITE);    SetTextColor(TEXT_BLACK);
   WindMesg(13,13,"White Background");
   SetTextColor(TEXT_WHITE);  SetBkColor(TEXT_DGREY);
   WindMesg(14,13,"Dark Grey Background");
   SetBkColor(TEXT_LBLUE);    WindMesg(15,13,"Light Blue Background");
   SetBkColor(TEXT_LGREEN);   WindMesg(16,13,"Light Green Background");
   SetBkColor(TEXT_LCYAN);    WindMesg(17,13,"Light Cyan Background");
   SetBkColor(TEXT_LRED);     WindMesg(18,13,"Light Red Background");
   SetBkColor(TEXT_LMAGENTA); WindMesg(19,13,"Light Magenta Background");
   SetBkColor(TEXT_YELLOW);   SetTextColor(TEXT_BLACK);
   WindMesg(20,13,"Yellow Background");
   SetBkColor(TEXT_BWHITE);   SetTextColor(TEXT_BLACK);
   WindMesg(21,13,"Bright White Background");

   SetBkColor(TEXT_WHITE);    SetTextColor(TEXT_BLACK);
   WindMesg(6,53,"Black Text");
   SetTextColor(TEXT_BLUE);   WindMesg(7,53,"Blue Text");
   SetTextColor(TEXT_GREEN);  WindMesg(8,53,"Green Text");
   SetTextColor(TEXT_CYAN);   WindMesg(9,53,"Cyan Text");
   SetTextColor(TEXT_RED);    WindMesg(10,53,"Red Text");
   SetTextColor(TEXT_MAGENTA);
   WindMesg(11,53,"Magenta Text");
   SetTextColor(TEXT_BROWN);  SetBkColor(TEXT_WHITE);
   WindMesg(12,53,"Brown Text");
   SetBkColor(TEXT_BLACK);    SetTextColor(TEXT_WHITE);
   WindMesg(13,53,"White Text");
   SetBkColor(TEXT_WHITE);    SetTextColor(TEXT_DGREY);
   WindMesg(14,53,"Dark Grey Text");
   SetBkColor(TEXT_BLACK);    SetTextColor(TEXT_LBLUE);
   WindMesg(15,53,"Light Blue Text");
   SetTextColor(TEXT_LGREEN); WindMesg(16,53,"Light Green Text");
   SetTextColor(TEXT_LCYAN);  WindMesg(17,53,"Light Cyan Text");
   SetTextColor(TEXT_LRED);   WindMesg(18,53,"Light Red Text");
   SetTextColor(TEXT_LMAGENTA);
   WindMesg(19,53,"Light Magenta Text");
   SetTextColor(TEXT_YELLOW); WindMesg(20,53,"Yellow Text");
   SetTextColor(TEXT_BWHITE); WindMesg(21,53,"Bright White Text");

   WindMesg(24,28,"Hit any key to continue.");

   GetKey();    /* Wait for a user keystroke. */

   RemoveWindow(window_ptr);   /* And finally destroy the window. */
   DeleteWindow(window_ptr);

   return(0);
}




/*-----------------------------------------------*/
/*                Borders_Window                 */
/* This routine displays three separate windows, */ 
/* each with a different style of border in      */
/* order to show the user the different border   */
/* options, No Border, Single Line Border, and   */
/* Double Line Border.                           */
/*-----------------------------------------------*/
int Borders_Window()
{
   WINDOW_HEAD *w_ptr1, *w_ptr2, *w_ptr3;

   /*---------------------------------------------------------*/
   /* Define windows portraying the different border choices. */
   /*---------------------------------------------------------*/
   DefineWindow(&w_ptr1, 8, 1, 7, 39,
        TEXT_BLUE, TEXT_BWHITE, "No Border Window",
        NOBORDER, FALSE, FALSE, TRUE);
   DefineWindow(&w_ptr2, 8, 41, 7, 39,
        TEXT_BLUE, TEXT_BWHITE, "Single Border Window",
        SINGLEBORDER, FALSE, TRUE, TRUE);
   DefineWindow(&w_ptr3, 16, 20, 7, 39,
        TEXT_BLUE, TEXT_BWHITE, "Double Border Window",
        DOUBLEBORDER, TRUE, FALSE, TRUE);

   /*----------------------------*/
   /* Display the three windows. */
   /*----------------------------*/
   DisplayWindow(w_ptr1);
   DisplayWindow(w_ptr2);
   DisplayWindow(w_ptr3);

   WindMesg(7,7,"Hit any key to continue.");

   GetKey();    /* Wait for a user keystroke. */

   RemoveWindow(w_ptr1);   /* And destroy the border demo windows. */
   DeleteWindow(w_ptr1);
   RemoveWindow(w_ptr2);
   DeleteWindow(w_ptr2);
   RemoveWindow(w_ptr3);
   DeleteWindow(w_ptr3);

   return(0);
}




/*------------------------------------------------------*/
/*                 Exploding_Window                     */
/* This routine demonstrates the difference between     */
/* an exploding/imploding window, and a 'normal'        */
/* window.  This is accomplished by displaying both     */
/* types of windows at the same time, and then removing */
/* them.  This is done repeatedly to allow the user     */
/* to more clearly see the difference.                  */
/*------------------------------------------------------*/
int Exploding_Window()
{
   WINDOW_HEAD *(window_ptr[2]);
   int i;

   /*----------------------*/
   /* Define both windows. */
   /*----------------------*/
   DefineWindow(&(window_ptr[0]), 2, 2, 11, 40,
        TEXT_CYAN, TEXT_LGREEN, "EXPLODING AND IMPLODING WINDOW",
        SINGLEBORDER, TRUE, TRUE, TRUE);
   DefineWindow(&(window_ptr[1]), 15, 45, 7, 34,
        TEXT_BLUE, TEXT_WHITE, "NON-EXPLODING/IMPLODING WINDOW",
        SINGLEBORDER, FALSE, FALSE, TRUE);


   /*--------------------------------------------*/
   /* Now display and remove both several times. */
   /*--------------------------------------------*/
   for (i=1;i<6;i++)
   {
      DisplayWindow(window_ptr[0]);
      DisplayWindow(window_ptr[1]);
      delay(18);
      RemoveWindow(window_ptr[0]);
      RemoveWindow(window_ptr[1]);
   }

   /*-----------------------------*/
   /* Finally delete the windows. */
   /*-----------------------------*/
   DeleteWindow(window_ptr[0]);
   DeleteWindow(window_ptr[1]);

   return(0);
}





/*-------------------------------------------------*/
/*               Multiple_Window                   */
/* This routine is intended to show the user the   */
/* ability of VISIONS to display numerous windows. */
/* In this routine 28 windows are displayed on the */
/* screen.  The maximum number of windows that can */
/* be defined at any one time is dependent on the  */
/* size of the windows, whether or not they are    */
/* popup windows, and how much of the heap is being*/
/* used for other purposes.  Over 100 medium size  */
/* popup windows is easily attained.               */
/*-------------------------------------------------*/
int Multiple_Window()
{
   WINDOW_HEAD *(window_ptr[28]);
   int i;

   /*---------------------------------------------------*/
   /* Define all the windows using a variety of colors. */
   /*---------------------------------------------------*/
   DefineWindow(&(window_ptr[0]), 7, 64, 5, 15,
        TEXT_LBLUE, TEXT_BLACK, "WINDOW # 1",
        SINGLEBORDER, TRUE, TRUE, TRUE);
   DefineWindow(&(window_ptr[1]), 20, 3, 5, 20,
        TEXT_BROWN, TEXT_LBLUE, "WINDOW # 2",
        DOUBLEBORDER, TRUE, FALSE, TRUE);
   DefineWindow(&(window_ptr[2]), 14, 34, 8, 18,
        TEXT_BLUE, TEXT_LRED, "WINDOW # 3",
        NOBORDER, TRUE, FALSE, TRUE);
   DefineWindow(&(window_ptr[3]), 17, 59, 5, 20,
        TEXT_BLACK, TEXT_LCYAN, "WINDOW # 4",
        DOUBLEBORDER, FALSE, TRUE, TRUE);
   DefineWindow(&(window_ptr[4]), 1, 12, 5, 35,
        TEXT_GREEN, TEXT_LMAGENTA, "WINDOW # 5",
        NOBORDER, FALSE, TRUE, TRUE);
   DefineWindow(&(window_ptr[5]), 4, 44, 6, 16,
        TEXT_RED, TEXT_BWHITE, "WINDOW # 6",
        SINGLEBORDER, FALSE, TRUE, TRUE);
   DefineWindow(&(window_ptr[6]), 20, 55, 5, 21,
        TEXT_BLUE, TEXT_BWHITE, "WINDOW # 7",
        DOUBLEBORDER, TRUE, FALSE, TRUE);
   DefineWindow(&(window_ptr[7]), 19, 21, 5, 17,
        TEXT_RED, TEXT_WHITE, "WINDOW # 8",
        SINGLEBORDER, TRUE, FALSE, TRUE);
   DefineWindow(&(window_ptr[8]), 9, 23, 6, 18,
        TEXT_BLACK, TEXT_YELLOW, "WINDOW # 9",
        NOBORDER, FALSE, TRUE, TRUE);
   DefineWindow(&(window_ptr[9]), 14, 31, 5, 20,
        TEXT_WHITE, TEXT_GREEN, "WINDOW # 10",
        DOUBLEBORDER, FALSE, FALSE, TRUE);
   DefineWindow(&(window_ptr[10]), 17, 2, 6, 19,
        TEXT_YELLOW, TEXT_BLACK, "WINDOW # 11",
        SINGLEBORDER, TRUE, TRUE, TRUE);
   DefineWindow(&(window_ptr[11]), 18, 16, 4, 17,
        TEXT_WHITE, TEXT_CYAN, "WINDOW # 12",
        NOBORDER, TRUE, TRUE, TRUE);
   DefineWindow(&(window_ptr[12]), 13, 61, 6, 20,
        TEXT_WHITE, TEXT_BROWN, "WINDOW # 13",
        SINGLEBORDER, TRUE, TRUE, TRUE);
   DefineWindow(&(window_ptr[13]), 1, 63, 7, 16,
        TEXT_BLUE, TEXT_BWHITE, "WINDOW # 14",
        SINGLEBORDER, TRUE, TRUE, TRUE);
   DefineWindow(&(window_ptr[14]), 1, 1, 5, 15,
        TEXT_LBLUE, TEXT_BLACK, "WINDOW # 15",
        SINGLEBORDER, TRUE, TRUE, TRUE);
   DefineWindow(&(window_ptr[15]), 5, 5, 5, 20,
        TEXT_BROWN, TEXT_LBLUE, "WINDOW # 16",
        DOUBLEBORDER, TRUE, FALSE, TRUE);
   DefineWindow(&(window_ptr[16]), 2, 8, 8, 18,
        TEXT_BLUE, TEXT_LRED, "WINDOW # 17",
        NOBORDER, TRUE, FALSE, TRUE);
   DefineWindow(&(window_ptr[17]), 10, 59, 5, 20,
        TEXT_BLACK, TEXT_LCYAN, "WINDOW # 18",
        DOUBLEBORDER, FALSE, TRUE, TRUE);
   DefineWindow(&(window_ptr[18]), 19, 32, 5, 35,
        TEXT_GREEN, TEXT_LMAGENTA, "WINDOW # 19",
        NOBORDER, FALSE, TRUE, TRUE);
   DefineWindow(&(window_ptr[19]), 8, 24, 6, 16,
        TEXT_RED, TEXT_BWHITE, "WINDOW # 20",
        SINGLEBORDER, FALSE, TRUE, TRUE);
   DefineWindow(&(window_ptr[20]), 10, 1, 5, 21,
        TEXT_BLUE, TEXT_BWHITE, "WINDOW # 21",
        DOUBLEBORDER, TRUE, FALSE, TRUE);
   DefineWindow(&(window_ptr[21]), 19, 61, 5, 17,
        TEXT_RED, TEXT_WHITE, "WINDOW # 22",
        SINGLEBORDER, TRUE, FALSE, TRUE);
   DefineWindow(&(window_ptr[22]), 10, 35, 6, 18,
        TEXT_BLACK, TEXT_YELLOW, "WINDOW # 23",
        NOBORDER, FALSE, TRUE, TRUE);
   DefineWindow(&(window_ptr[23]), 4, 11, 5, 20,
        TEXT_WHITE, TEXT_GREEN, "WINDOW # 24",
        DOUBLEBORDER, FALSE, FALSE, TRUE);
   DefineWindow(&(window_ptr[24]), 6, 52, 6, 19,
        TEXT_YELLOW, TEXT_BLACK, "WINDOW # 25",
        SINGLEBORDER, TRUE, TRUE, TRUE);
   DefineWindow(&(window_ptr[25]), 18, 36, 4, 17,
        TEXT_WHITE, TEXT_CYAN, "WINDOW # 26",
        NOBORDER, TRUE, TRUE, TRUE);
   DefineWindow(&(window_ptr[26]), 16, 61, 6, 20,
        TEXT_WHITE, TEXT_BROWN, "WINDOW # 27",
        SINGLEBORDER, TRUE, TRUE, TRUE);
   DefineWindow(&(window_ptr[27]), 5, 63, 7, 16,
        TEXT_BLUE, TEXT_BWHITE, "WINDOW # 28",
        SINGLEBORDER, TRUE, TRUE, TRUE);

   /*------------------------------*/
   /* Now display all the windows. */
   /*------------------------------*/
   for (i=0;i<28;i++)
   {
      DisplayWindow(window_ptr[i]);
      delay(12);   /* Slight pause between window displays. */
   }

   /*-----------------------------------------*/
   /* Big pause before we remove the windows. */
   /*-----------------------------------------*/
   for (i=0;i<28;i++)
      delay(10);

   /*-----------------------------*/
   /* Now remove all the windows. */
   /*-----------------------------*/
   for (i=27;i>=0;i--)
   {
      delay(12);   /* Slight pause between window removals. */
      RemoveWindow(window_ptr[i]);
      DeleteWindow(window_ptr[i]);
   }

   return(0);
}



/*-------------------------------------------------*/
/*              Interactive_Windows                */
/* This routine allows the user to define a window */
/* including colors, sizes, borders, titles, and   */
/* screen positions in an interactive way.         */
/*-------------------------------------------------*/
int Interactive_Windows()
{
   WINDOW_HEAD *window_ptr;
   MENU_HEAD *bkcol_menu, *txtcol_menu, *border_menu;
   MENU_HEAD *popup_menu, *implode_menu, *explode_menu;
   FORM_HEAD *coord_form;
   BYTE row, col, heighth, width;
   long int bkcol, txtcol;
   char title[81];
   char s_row[3], s_col[3], s_heighth[3], s_width[3];
   BYTE border;
   BYTE explode, implode, popup;
   int key=0;


   Interactive_Info();     /* Tell the user what's about to happen. */

   /*---------------------------------------*/
   /* Create the text color selection menu. */
   /*---------------------------------------*/
   MakeColorMenu(&txtcol_menu,"Select Text Color");

   /*---------------------------------------------*/
   /* Create the background color selection menu. */
   /*---------------------------------------------*/
   MakeColorMenu(&bkcol_menu,"Select Background Color");

   /*-----------------------------------------*/
   /* Create the border style selection menu. */
   /*-----------------------------------------*/
   DefineMenu(&border_menu,12,12,1,1,SINGLEBORDER,HOT_EXEC_ON,
        TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"Select Border");
   AddToMenu(border_menu, "No Border", 'N', NOBORDER, NULL);
   AddToMenu(border_menu, "Single Line Border", 'S', SINGLEBORDER, NULL);
   AddToMenu(border_menu, "Double Line Border", 'D', DOUBLEBORDER, NULL);

   /*--------------------------------*/
   /* Create the pop-up enable menu. */
   /*--------------------------------*/
   DefineMenu(&popup_menu,14,14,1,1,SINGLEBORDER,HOT_EXEC_ON,
        TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"Popup Style");
   AddToMenu(popup_menu, "TRUE", 'T', 1, NULL);
   AddToMenu(popup_menu, "FALSE", 'F', 2, NULL);

   /*------------------------------------------*/
   /* Create the exploding window enable menu. */
   /*------------------------------------------*/
   DefineMenu(&explode_menu,14,14,1,1,SINGLEBORDER,HOT_EXEC_ON,
        TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"Exploding Style");
   AddToMenu(explode_menu, "TRUE", 'T', 1, NULL);
   AddToMenu(explode_menu, "FALSE", 'F', 2, NULL);

   /*------------------------------------------*/
   /* Create the imploding window enable menu. */
   /*------------------------------------------*/
   DefineMenu(&implode_menu,14,14,1,1,SINGLEBORDER,HOT_EXEC_ON,
        TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,"Imploding Style");
   AddToMenu(implode_menu, "TRUE", 'T', 1, NULL);
   AddToMenu(implode_menu, "FALSE", 'F', 2, NULL);

   /*-----------------------------------------------------*/
   /* Create the window coordinates and title entry form. */
   /*-----------------------------------------------------*/
   MakeCoordForm(&coord_form, title, s_row, s_col, s_heighth, s_width);

   while (key != ESC)
   {

      /*--------------------------------------------------------*/
      /* Execute all the menus and forms to specify the window. */
      /*--------------------------------------------------------*/
      if (FormEntry(coord_form) == -1) goto exit;
      /*---------------------------------*/
      /* Convert the inputs to integers. */
      /*---------------------------------*/
      row = atoi(s_row);       col = atoi(s_col);
      width = atoi(s_width);   heighth = atoi(s_heighth);

      if ((bkcol = AutoDisplayMenu(bkcol_menu)) == -1) goto exit;
      bkcol = ColorConvert((int)bkcol);   /* Convert colors to numbers. */
      if ((txtcol = AutoDisplayMenu(txtcol_menu)) == -1) goto exit;
      txtcol = ColorConvert((int)txtcol);
      if ((border = AutoDisplayMenu(border_menu)) == -1) goto exit;
      if ((popup = AutoDisplayMenu(popup_menu)) == -1) goto exit;
      if (popup == 2) popup = FALSE; else popup = TRUE;
      if ((explode = AutoDisplayMenu(explode_menu)) == -1) goto exit;
      if (explode == 2) explode = FALSE; else explode = TRUE;
      if ((implode = AutoDisplayMenu(implode_menu)) == -1) goto exit;
      if (implode == 2) implode = FALSE; else implode = TRUE;

      /*----------------------------------------*/
      /* Tell the user to hit keys to continue. */
      /*----------------------------------------*/
      ErrWindow(
       "Hit any key to see your window, and then another key to continue.");

      /*------------------------------------*/
      /* Display the user's defined window. */
      /*------------------------------------*/
      DefineWindow(&window_ptr, row, col, heighth, width,
        bkcol, txtcol, title, border, explode, implode, popup);

      DisplayWindow(window_ptr);

      /*---------------------------------*/
      /* Force a key strike to continue. */
      /*---------------------------------*/
      GetKey();

      RemoveWindow(window_ptr);  /* And destroy the user's window. */
      DeleteWindow(window_ptr);

   }

   /*-------------------------------------------------------*/
   /* Destroy all the window specification forms and menus. */
   /*-------------------------------------------------------*/
   DeleteMenu(txtcol_menu);
   DeleteMenu(bkcol_menu);
   DeleteMenu(border_menu);
   DeleteForm(coord_form);
exit:
   return(0);
}




/*------------------------------------------------------*/
/*                 Interactive_Info                     */
/* This routine displays a window of information to the */
/* user, telling him what is about to happen with the   */
/* interactive window demonstration.                    */
/*------------------------------------------------------*/
int Interactive_Info()
{
   WINDOW_HEAD *info_window;

   /*--------------------------------*/
   /* Define and display the window. */
   /*--------------------------------*/
   DefineWindow(&info_window, 5, 3, 17, 67, TEXT_BLUE, TEXT_WHITE, 
     "Interactive VISIONS Window Demonstration Introduction", 
     SINGLEBORDER, TRUE, TRUE, TRUE);

   DisplayWindow(info_window);

   WindMesg(5,3,"The following is an interactive window display routine.  This");
   WindMesg(6,3,"routine allows you to specify a window's coordinates, size, ");
   WindMesg(7,3,"title, borders, colors, and display options, and then see the ");
   WindMesg(8,3,"result interactively.  A series of forms and menus is used ");
   WindMesg(9,3,"to allow you to enter your window's specifications.  Failing ");
   WindMesg(10,3,"to correctly specify a window's coordinates or size may cause ");
   WindMesg(11,3,"the window to be undisplayable.  Should this happen, just ");
   WindMesg(12,3,"change your specifications and try again.  The interactive ");
   WindMesg(13,3,"window demonstration preserves all your choices between ");
   WindMesg(14,3,"window displays, so that you can default a specification to");
   WindMesg(15,3,"your last selection.");

   WindMesg(17,21,"Hit any key to continue.");

   GetKey();   /* Force a keystrike to continue. */

   RemoveWindow(info_window);  /* And destroy the window. */
   DeleteWindow(info_window);

   return(0);
}



/*-----------------------------------*/
/*           MakeColorMenu           */
/* Create the color selection menu   */
/* for the interactive windows demo. */
/*-----------------------------------*/
MakeColorMenu(col_menu,title)
MENU_HEAD **col_menu;
char *title;
{

   DefineMenu(col_menu,4,4,1,1,SINGLEBORDER,HOT_EXEC_ON,
        TEXT_BLUE,TEXT_WHITE,TEXT_WHITE,TEXT_BLUE,title);
   AddToMenu(*col_menu, "BLACK", 'B', 1, NULL);
   AddToMenu(*col_menu, "BLUE", 'B', 2, NULL);
   AddToMenu(*col_menu, "GREEN", 'G', 3, NULL);
   AddToMenu(*col_menu, "CYAN", 'C', 4, NULL);
   AddToMenu(*col_menu, "RED", 'R', 5, NULL);
   AddToMenu(*col_menu, "MAGENTA", 'M', 6, NULL);
   AddToMenu(*col_menu, "BROWN", 'B', 7, NULL);
   AddToMenu(*col_menu, "WHITE", 'W', 8, NULL);
   AddToMenu(*col_menu, "DARK GREY", 'D', 9, NULL);
   AddToMenu(*col_menu, "LIGHT BLUE", 'L', 10, NULL);
   AddToMenu(*col_menu, "LIGHT GREEN", 'L', 11, NULL);
   AddToMenu(*col_menu, "LIGHT CYAN", 'L', 12, NULL);
   AddToMenu(*col_menu, "LIGHT RED", 'L', 13, NULL);
   AddToMenu(*col_menu, "LIGHT MAGENTA", 'L', 14, NULL);
   AddToMenu(*col_menu, "YELLOW", 'Y', 15, NULL);
   AddToMenu(*col_menu, "BRIGHT WHITE", 'B', 16, NULL);

   return(0);
}



/*----------------------------------------------*/
/*                MakeCoordForm                 */
/* Create the coordinate selection and title    */
/* entry form for the interactive windows demo. */
/*----------------------------------------------*/
int MakeCoordForm(coord_form, title, s_row, s_col, s_heighth, s_width)
FORM_HEAD **coord_form;
char *title;
char *s_row, *s_col, *s_heighth, *s_width;
{
   FORM_FIELD *field_ptr;

   DefineForm(coord_form,2,5,12,60,SINGLEBORDER,
      TEXT_BLUE,TEXT_WHITE,"Window Title and Coordinates");
   AddToForm(*coord_form, *IntOnly, &field_ptr);
   AddToPrompt(field_ptr, 5, 2, 21, TEXT_BLUE,TEXT_WHITE,
      TEXT_WHITE,TEXT_BLUE,"Top Left Corner  Row:");
   strcpy(s_row,"");
   AddToText(field_ptr, 5, 27, 2, TEXT_BLACK,TEXT_WHITE,
      TEXT_WHITE,TEXT_BLACK,s_row);

   AddToForm(*coord_form, *IntOnly, &field_ptr);
   AddToPrompt(field_ptr, 6, 19, 7, TEXT_BLUE,TEXT_WHITE,
      TEXT_WHITE,TEXT_BLUE,"Column:");
   strcpy(s_col,"");
   AddToText(field_ptr, 6, 27, 2, TEXT_BLACK,TEXT_WHITE,
      TEXT_WHITE,TEXT_BLACK,s_col);

   AddToForm(*coord_form, *IntOnly, &field_ptr);
   AddToPrompt(field_ptr, 7, 19, 7, TEXT_BLUE,TEXT_WHITE,
      TEXT_WHITE,TEXT_BLUE,"Height:");
   strcpy(s_heighth,"");
   AddToText(field_ptr, 7, 27, 2, TEXT_BLACK,TEXT_WHITE,
      TEXT_WHITE,TEXT_BLACK,s_heighth);

   AddToForm(*coord_form, *IntOnly, &field_ptr);
   AddToPrompt(field_ptr, 8, 19, 7, TEXT_BLUE,TEXT_WHITE,
      TEXT_WHITE,TEXT_BLUE,"Width:");
   strcpy(s_width,"");
   AddToText(field_ptr, 8, 27, 2, TEXT_BLACK,TEXT_WHITE,
      TEXT_WHITE,TEXT_BLACK,s_width);

   AddToForm(*coord_form, NULL, &field_ptr);
   AddToPrompt(field_ptr, 10, 2, 6, TEXT_BLUE,TEXT_WHITE,
      TEXT_WHITE,TEXT_BLUE,"Title:");
   strcpy(title,"");
   AddToText(field_ptr, 10, 9, 45, TEXT_BLACK,TEXT_WHITE,
      TEXT_WHITE,TEXT_BLACK,title);

   return(0);
}



/*-----------------------------------------------*/
/*               Window_Intro                    */
/* Introduce the user to this demonstration,     */
/* explaining the purpose and what is happening. */
/*-----------------------------------------------*/
int Window_Intro()
{
   WINDOW_HEAD *intro_window;

   DefineWindow(&intro_window, 1, 1, 24, 80,
        TEXT_BLUE, TEXT_WHITE, "VISIONS Window Demonstration Introduction",
        SINGLEBORDER, FALSE, FALSE, TRUE);
   DisplayWindow(intro_window);
   WindMesg(9,5,"   The VISIONS window library demonstration is intended to introduce ");
   WindMesg(10,5," the user to the window library concepts and functions through the ");
   WindMesg(11,5," use of several separate window examples.  The first examples are user ");
   WindMesg(12,5," passive demonstrations, where all the possible window colors and types");
   WindMesg(13,5," are displayed.  The last demonstration is user interactive, allowing");
   WindMesg(14,5," the user to set all the parameters associated with a window, and then");
   WindMesg(15,5," display the result.  The source code used to create this demonstration");
   WindMesg(16,5," is supplied with the executable.  Please remember that all VISIONS");
   WindMesg(17,5," windows are text windows, graphics windows are not supported.");

   WindMesg(24,28,"Hit any key to continue.");

   GetKey();    /* Wait for a user keystroke. */

   RemoveWindow(intro_window);    /* And destroy the window. */
   DeleteWindow(intro_window);

   return(0);
}



/*-----------------------------------------------*/
/*               ColorConvert                    */
/* This routine converts integer values returned */
/* from a menu, to long integer colors used by   */
/* the interactive window demonstration.         */
/*-----------------------------------------------*/
long int ColorConvert(color)
int color;
{
   long int retcolor;

   switch (color)
   {
   case 1:
        retcolor = TEXT_BLACK;
        break;
   case 2:
        retcolor = TEXT_BLUE;
        break;
   case 3:
        retcolor = TEXT_GREEN;
        break;
   case 4:
        retcolor = TEXT_CYAN;
        break;
   case 5:
        retcolor = TEXT_RED;
        break;
   case 6:
        retcolor = TEXT_MAGENTA;
        break;
   case 7:
        retcolor = TEXT_BROWN;
        break;
   case 8:
        retcolor = TEXT_WHITE;
        break;
   case 9:
        retcolor = TEXT_DGREY;
        break;
   case 10:
        retcolor = TEXT_LBLUE;
        break;
   case 11:
        retcolor = TEXT_LGREEN;
        break;
   case 12:
        retcolor = TEXT_LCYAN;
        break;
   case 13:
        retcolor = TEXT_LRED;
        break;
   case 14:
        retcolor = TEXT_LMAGENTA;
        break;
   case 15:
        retcolor = TEXT_YELLOW;
        break;
   case 16:
   default:
        retcolor = TEXT_BWHITE;
        break;
   }

   return(retcolor);
}




/*-------------------------------*/
/*            delay              */
/* This routine provides a brute */
/* force code loop delay.        */
/*-------------------------------*/
delay(num)
{
   long int i, k, j;

   for (k=0; k<num; k++)
      for (i=0;i<600L;i++)
         j = 3/5 + i;
}
                                                                                                             