/*------------------------- SHARWIND.H -------------------------*/
/*								*/
/*  This file contains definitions used for the window library	*/
/*  that are needed both internally by the library and also	*/
/*  by the user of the library.					*/
/*								*/
/*         Copyright 1990 Dan Vogel & David Bernazzani		*/
/*								*/
/*								*/
/*		Revision History				*/
/*								*/
/*  03/20/90   DCV	Release.				*/
/*								*/
/*--------------------------------------------------------------*/

#include "SHARCOMP.H"			/* Compiler Specific Definitions */


		/* Window Border Types */

#define	NOBORDER	1
#define	SINGLEBORDER	2
#define	DOUBLEBORDER	3


		/* General definitions of TRUE and FALSE */
#define	FALSE	0
#define	TRUE	1


		/* Text Screen Colors */

#define	INIT_TEXT_BLACK		0L
#define	INIT_TEXT_BLUE		1L
#define	INIT_TEXT_GREEN		2L
#define	INIT_TEXT_CYAN		3L
#define	INIT_TEXT_RED		4L
#define	INIT_TEXT_MAGENTA	5L
#define	INIT_TEXT_BROWN		6L
#define	INIT_TEXT_WHITE		7L
#define	INIT_TEXT_DGREY		8L
#define	INIT_TEXT_LBLUE		9L
#define	INIT_TEXT_LGREEN	10L
#define	INIT_TEXT_LCYAN		11L
#define	INIT_TEXT_LRED		12L
#define	INIT_TEXT_LMAGENTA	13L
#define	INIT_TEXT_YELLOW	14L
#define	INIT_TEXT_BWHITE	15L




			/*  Error Values  */

#define	UNABLE_TO_OPEN_HELPFILE	-201	/* File opening error */
#define	HELP_WINDOW_TOO_SMALL	-202	/* Display window too small! */
#define	OUT_OF_WINDOW_HEAP	-203	/* Out of heap for pop up storage */
#define	NOT_A_WINDOW_POINTER	-204	/* Bad pointer to window structure */
#define	BAD_WINDOW_DEF		-205	/* Size of window exceeds screen */


	/* Standard type used for passing small values. */

typedef unsigned char BYTE;
typedef unsigned int WORD;


       /* Access to color definitions. */

extern long int	TEXT_BLACK;
extern long int	TEXT_BLUE;
extern long int	TEXT_GREEN;
extern long int	TEXT_CYAN;
extern long int	TEXT_RED;
extern long int	TEXT_MAGENTA;
extern long int	TEXT_BROWN;
extern long int	TEXT_WHITE;
extern long int	TEXT_DGREY;
extern long int	TEXT_LBLUE;
extern long int	TEXT_LGREEN;
extern long int	TEXT_LCYAN;
extern long int	TEXT_LRED;
extern long int	TEXT_LMAGENTA;
extern long int	TEXT_YELLOW;
extern long int	TEXT_BWHITE;
                              