/*------------------------- USERFORM.H -------------------------*/
/*								*/
/*  This file contains definitions used for the form library	*/
/*  that are needed by the user of the library.			*/
/*								*/
/*         Copyright 1990 Dan Vogel & David Bernazzani		*/
/*								*/
/*								*/
/*		Revision History				*/
/*								*/
/*  03/05/90   DCV	Release.				*/
/*								*/
/*--------------------------------------------------------------*/


		/*  Include Files  */

#include "SHARFORM.H"			/* Pick up shared definitions */


		/*  Type Definitions  */

typedef unsigned char FORM_HEAD;	/* Form Header */
typedef unsigned char FORM_FIELD;	/* Form prompt/entry field pair*/
typedef unsigned char FORM_TEXT;	/* Form prompt or entry field descr.*/


		/* Routine Definitions */

extern  int DefineForm(FORM_HEAD * *new_form,BYTE row,BYTE col,BYTE height,BYTE width,BYTE border,long bkcol,long txtcol,char *title);
extern  int AddToForm(FORM_HEAD *form_ptr,int (*form_valid)(),FORM_FIELD * *field_ptr);
extern  int AddToPrompt(FORM_FIELD *field_ptr,BYTE row,BYTE col,BYTE length,long bkcol,long txtcol,long highbkcol,long highcol,char *str_txt);
extern  int AddToText(FORM_FIELD *field_ptr,BYTE row,BYTE col,BYTE length,long bkcol,long txtcol,long highbkcol,long highcol,char *str_txt);
extern  int DeleteForm(FORM_HEAD *new_form);
extern  int FormEntry(FORM_HEAD *new_form);
                                                                                                                       