/*------------------------- USERLIST.H -------------------------*/
/*								*/
/*  This file contains definitions used for the list library	*/
/*  that are needed by the user of the library.			*/
/*								*/
/*	    Copyright 1990 Dan Vogel & David Bernazzani		*/
/*								*/
/*								*/
/*		Revision History				*/
/*								*/
/*  03/05/90   DCV	Release.				*/
/*								*/
/*--------------------------------------------------------------*/

		/*  Include Files  */

#include "SHARLIST.H"			/* Pick up shared definitions */


		/*  Type Definitions  */

typedef unsigned char LIST_LINK;
typedef unsigned char LIST_HEAD;


		/*  Routine Definitions  */

extern  int DefineList(LIST_HEAD * *new_list,int (*compare_f)(unsigned char *,unsigned char *),int (*delete_f)(unsigned char *),int (*display_f)(unsigned char *,char *));
extern  int AddToList(LIST_HEAD *list_root,LIST_LINK *list_ptr,unsigned char *new_item);
extern  int AppendToList(LIST_HEAD *list_top,unsigned char *new_item);
extern  int AllocateLink(LIST_LINK * *new_link);
extern  int AllocateList(LIST_HEAD * *new_list);
extern  int DeleteFromList(LIST_HEAD *list_ptr,unsigned char *remove_item);
extern  int RemoveFromList(LIST_HEAD *list_ptr,unsigned char *remove_item);
extern  int DeleteList(LIST_HEAD *del_list);
extern  int FindInList(LIST_HEAD *list_ptr,unsigned char *find_item,LIST_LINK * *list_fnd);
extern  int DisplayListItem(LIST_HEAD *list_ptr,LIST_LINK *disp_link,char *buffer);
extern  int ListTop(LIST_HEAD *list_ptr,LIST_LINK * *top_link);
extern  int ListBottom(LIST_HEAD *list_ptr,LIST_LINK * *bot_link);
extern  int ListNext(LIST_LINK *curr_link,LIST_LINK * *next_link);
extern  int ListLast(LIST_LINK *curr_link,LIST_LINK * *last_link);
extern  int CountList(LIST_HEAD *list_ptr);
extern  int ListNth(LIST_HEAD *list_ptr,int list_num,LIST_LINK * *ret_link);
extern  int SortList(LIST_HEAD *list_ptr,int (*compare_f)(unsigned char *,unsigned char *));
extern  int DisplayList(BYTE topy,BYTE col,BYTE height,BYTE width,long bkcol,long txtcol,char border,char *title,LIST_HEAD *d_list);
                                                           