/*------------------------- USERWIND.H -------------------------*/
/*								*/
/*  This file contains definitions used for the window library	*/
/*  that are needed by the user of the library.			*/
/*								*/
/*         Copyright 1990 Dan Vogel & David Bernazzani		*/
/*								*/
/*								*/
/*		Revision History				*/
/*								*/
/*  03/20/90   DCV	Release.				*/
/*								*/
/*--------------------------------------------------------------*/


#include "SHARWIND.H"		/* Needed include files. */


typedef	unsigned char WINDOW_HEAD;



		/* Library Routine Type Definitions */

extern  void InitWindow(void );
extern  void ExitWindow(void );
extern  int DefineWindow(WINDOW_HEAD * *new_wind,BYTE topy,BYTE leftx,BYTE height,BYTE width,long bkcol,long txtcol,char *title,BYTE border,BYTE explode,BYTE implode,BYTE popup);
extern  int DeleteWindow(WINDOW_HEAD *window_ptr);
extern  int DisplayWindow(WINDOW_HEAD *window_ptr);
extern  int RemoveWindow(WINDOW_HEAD *window_ptr);
extern  int Window(WINDOW_HEAD *window_ptr);
extern  void SetWindow(BYTE row,BYTE col,BYTE height,BYTE width,long bkcol,long txtcol);
extern  int SetWindowPtr(WINDOW_HEAD *window_ptr);
extern  void WindMesg(BYTE row,BYTE col,char *message);
extern  int WindMesgPtr(WINDOW_HEAD *window_ptr,BYTE row,BYTE col,char *message);
extern  int ErrWindow(char *msg);
extern  int HelpWindow(BYTE row,BYTE col,BYTE height,BYTE width,long bkcol,long txtcol,BYTE border,char *title,char *filename);

                            