











                                       ViewLib







                                   Reference Manual








                         Copyright 1992, DB/Soft Publishing.
                                 All rights reserved.








                                Printed in the U.S.A.

                             Version 1.00, first printing







          Copyright________________________________________________________

          This software is protected under  United States Copyright Law and
          International Treaty provisions.  DB/Soft Publishing reserves all
          rights to ViewLib except for the following:

          A limited license is hereby granted allowing you use and evaluate
          ViewLib for up  to 30 days.  You may also distribute unregistered
          copies of  ViewLib  in its  entirety  to any  parties  interested
          provided no  modification of  the  files in  the ViewLib  archive
          occurs.    The  maximum  transaction  related  to  selling  media
          containing unregistered copies of ViewLib  (eg Shareware vendors)
          may not exceed $10.00.   Conversion to a more  convenient archive
          format  is allowed.    All other  uses  of ViewLib  violate  this
          license and are hereby expressly disallowed.

                        Copyright 1992, by DB/Soft Publishing,
                                 All Rights Reserved.

                    3200 Truxel Rd #199, Sacramento, CA 95833 USA

                              Telephone: (916) 927-6951

                                 BBS: (916) 927-2349

          Limited Warranty_________________________________________________

          DB/Soft Publishing  grants no warranties, express  or implied, by
          statute  or otherwise,  regarding this  software and  its related
          materials, their fitness for any purpose, their quality, or their
          merchantability.  In  no way shall  DB/Soft Publishing be  liable
          for  any  special, consequential,  other  damages  for breach  of
          warranty.

          This Statement  shall be  construed, interpreted and  governed by
          the laws of the State of California.

          This  warranty will be replaced by a limited 90-day warranty that
          covers the diskette, software and documentation upon registration
          of ViewLib.


          Registering ViewLib______________________________________________

          ViewLib  is an example  of software marketed  under the Shareware
          concept.  The premise is simple:  you may evaluate  ViewLib for a
          reasonable period  of time  (30 days  maximum)  during which  you
          decide if  it is  a library  worth owning  and using  for viewing







          files  from within your applications.   If so,  you must register
          ViewLib, using order.doc for  ordering information.  If, after  a
          reasonable evaluation period, you decide not to register ViewLib,
          you then must discontinue its use.

          This  provides me  with a way  to market  software with  very low
          advertising  overhead, which  results in  a price  savings passed
          directly on to you.  And, it provides you with a chance to 'play'
          with my product and decide if it meets your needs. 

          As an incentive to speed the registration process, only the small
          memory  model  of ViewLib  is  distributed  as shareware.    Upon
          registration, you  will receive all the  available memory models:
          small, medium,  compact  and  large,  for both  Borland  C++  and
          Microsoft C.


          Getting Help_____________________________________________________

          There are several ways of contacting the author, Jeff Dunlop, for
          technical assistance if you get stuck.  From cheapest and slowest
          to most expensive and fastest:

               - Fidonet's SHAREWRE echo

               - ILink's Shareware conference

               - Fidonet netmail at 1:203/16

               - Compuserve mail at 72147,3055

               - Internet at 72147.3055@compuserve.com

               - The DB/Soft Online at (916) 927-2349

                - By mail at 3200 Truxel Rd #199 Sacramento CA 95833

          The best method of contacting  the author depends on the type  of
          assistance you need.   If it's a rather complicated  problem, you
          will  probably be far better  served if you  prepare a message in
          advance  and upload  it  with a  source  example to  the  DB/Soft
          Online.  We can then test it and offer suggestions.  If it's just
          a question or suggestion about ViewLib capabilities, the ILink or
          Fidonet conferences  will work best.   Fidonet netmail privileges
          can be difficult to  get, but offer excellent timeliness  at very
          low connect time.  Check your local Fidonet BBS if interested.







                                  Table of Contents


               Chapter 1 Introduction .................................. 2
                    Features ........................................... 2
                    Requirements ....................................... 2
                    Getting Started .................................... 2

               Chapter 2 Function Reference ............................ 4
                    vlLister ........................................... 4
                    vlGetVidMode ....................................... 6
                    vlGetVidBase ....................................... 7
                    vlGetCols .......................................... 8
                    vlGetRows .......................................... 8
                    vlIsDV ............................................. 9
                    vlIsEgaVga ......................................... 9
                    vlIsShift .......................................... 10
                    vlIsRShift ......................................... 10
                    vlIsLShift ......................................... 10
                    vlIsMono ........................................... 10



























                                          1







          Chapter 1 

          Introduction_____________________________________________________


          Features_________________________________________________________

          ViewLib provides an excellent means  to providing report and file
          viewing from  within  your C  applications.   Some  of  ViewLib's
          features include:

              -     View any size file

              -     Resize and move the view window at will

              -     Completely define the color of the text and border.  

              -     Completely  define  the  characters  that  compose  the
                    border.

              -     Define the initial size of the View window.

              -     ViewLib can  operate with as  little as  30k free  ram,
                    which  is  released  back   to  your  application  when
                    finished.

              -     Desqview, EGA  and VGA are all  detected and respected.
                    In DesqView, the shadow buffer is used to avoid  bleed-
                    through to other tasks. 

          Requirements_____________________________________________________

          You  must own either a Microsoft  or Borland C compiler.  ViewLib
          should  be compatible  with  most if  not  all of  the  compilers
          produced by  these two  companies, and  with any  other companies
          that  produces compatible compilers  (Watcom comes to  mind).  If
          you require ViewLib's functionality with an unsupported compiler,
          the  only solution  is to  purchase the  source code  (please see
          order.doc for details).

          Getting Started__________________________________________________

          ViewLib  can be linked into  any application just  like any other
          library.    Therefore, you  should  copy  vl*.lib into  the  same
          directory  that you  keep your  other  .lib files  in.   The file


                                          2







          vlibbcs.lib  is for  Borland compilers,  and vlibmscs.lib  is for
          Microsoft compilers.













































                                          3







          Chapter 2

          Function
          Reference________________________________________________________


          vlLister_________________________________________________________

             Usage: int vlLister(char  *FileSpec, int  x1, int y1,  int x2,
                    int  y2,  unsigned   char  Foreground,  unsigned   char
                    Background, unsigned BufSize, BORDER *BorderInfo);

             Prototype in:  vlib.h

             Description:   vlLister  displays  in  the coordinates  x1, y1,
                            x2,  y2 the  filename  passed.   The coordinates
                            are 0-based.   The minimum  allowed buffer  size
                            is eight kilobytes (8092  bytes).  The suggested
                            optimum buffer size is  also 8k.   The only time
                            that  it might  be  beneficial to  work  with  a
                            larger buffer is  in the case of reading a  file
                            on  a  floppy  drive.    The  valid  colors  for
                            Background (defined in vlib.h) are as follows:

                            VL_BLACK,  VL_BLUE, VL_GREEN,  VL_CYAN,  VL_RED,
                            VL_MAGENTA, VL_BROWN, VL_LIGHTGREY


                            The valid colors  for Foreground are any of  the
                            colors valid for Background, plus:

                            VL_DARKGREY,    VL_LIGHTBLUE,     VL_LIGHTGREEN,
                            VL_LIGHTCYAN,   VL_LIGHTRED,    VL_LIGHTMAGENTA,
                            VL_YELLOW, VL_WHITE


                            The user-accessable fields of BorderInfo are:

                            bd_enable:  Set to  TRUE if  a border is  to be
                                        displayed.   If  set to  FALSE, all
                                        other values are ignored.

                            b_string:   A string  describing the characters
                                        that  are  used   to  construct   a
                                        border.  Any character value in the
                                        extended   IBM  character   set  is

                                          4







                                        valid.  The string  "Ŀ" would
                                        make a box similar to:
                                        Ŀ
                                              
                                        

                            Foreground: The    colors   valid    for   text
                                        foreground are valid here as well.

                            Background: The    colors   valid    for   text
                                        background are valid here as well.


          Return value:  Upon  successful  completion, vlLister  returns 0.
                         The following error codes are defined in vlib.h:

                       VLIB_ARGERR:   The  screen  coordinates  passed  were
                       outside  the  range  of   the  current  text  screen.
                       Remember that the coordinates are from  0 to 24, 0 to
                       79 on CGA screens.
                       VLIB_DOSERR: There  was  an error  reading the  file.
                       Usually this means the name passed wasn't found.
                       VLIB_ALLOCERR: A request for more memory was denied.

             Example:

             #include "vlib.h"

             void main(void)
             {

               BORDER  BorderInfo  =  {{TRUE},   {"Ŀ"},  {VL_YELLOW},
               {VL_BLUE}};

               vlLister("file.txt",  1,  1,  78,  23,  VL_YELLOW,  VL_BLUE,
               0x2000, &bd_info);
             }

          The  behavior of vlLister depends on whether BorderInfo.bd_enable
          is TRUE or FALSE.   If the border is disabled, then it is assumed
          that the calling  function has  prepared a custom  border and  so
          border resizing/window moving is disabled as well.  If the border
          is enabled, then the base of the  border has the following string
          displayed:

                  PgUp PgDn Home End Esc

                                          5







          These are a subset of the allowed keystrokes.  The complete  list
          of legal keystrokes is:

          Home:   Display from the top of the file

          End:    Display the end of the file

          PgUp:   Display  the  previous  page  (varies  according  to   the
                  current window size.

          PgDn:   Display the  next page  (varies according  to the  current
                  window size

          Down:   Display the next line.

          Up:     Display the previous line.

          Right:  Shift the display left 10 columns.

          Left:   Shift the display right 10 columns.

          Ctl-Right*:
          RShift-Right:  Lengthen the window to the right one column.

          Ctl-Left*:
          RShift-Left:   Shorten the window to the left one column.

          Ctl-Dn*:
          RShift-Dn:     Lengthen the window down one row.

          Ctl-Up*:
          RShift-Up:     Shorten the window up one row.

          LShift-Right:  Move the window right one column.

          LShift-Up:     Move the window up one row.

          LShift-Left:   Move the window left one column.

          LShift-Dn:     Move the window down one row.

          * Only  supported on  101-key enhanced keyboards  with supporting
          BIOS.

          vlGetVidMode_____________________________________________________


                                          6







             Usage: unsigned char vlGetVidMode(void);

             Prototype in:  vlib.h

             Description:   vlGetVidMode returns  the current video mode  as
                            reported by Bios.

             Return Value:  Refer  to a  MS-Dos technical  reference  manual
                            for  the possible  return  values of  Bios video
                            modes and their meanings.

             Example:

             #include <stdio.h>
             #include "vlib.h"

             void main(void)
             {
               printf("Current video mode is %d\n", vlGetVidMode());
             }


          vlGetVidBase_____________________________________________________

             Usage: unsigned vlGetVidbase(void);

             Prototype in:  vlib.h

             Description:   vlGetVidBase returns the segment of the  current
                            video display buffer.

             Return Value:  Usually, b000  will be  returned for  monochrome
                            display,  and  b800 for  all  others.   However,
                            DesqView  shadow  buffers may  contain different
                            addresses on some platforms.

             Example:

             #include <stdio.h>
             #include "vlib.h"

             void main(void)
             {
               printf("The  current  video  ram  base  address  is  %xd\n",
               vlGetVidBase());
             }

                                          7








          vlGetCols________________________________________________________

             Usage: int vlGetCols(void);

             Prototype in:  vlib.h

             Description:   vlGetCols   determines  the  number  of  columns
                            currently being displayed.

             Return Value:  Most systems will return  80 columns.   However,
                            DesqView windows  defined at  unusual sizes will
                            be detected,  as  will  132-column  (and  other)
                            displays.

             Example:

             #include <stdio.h>
             #include "vlib.h"

             void main(void)
             {
               printf("The monitor  is currently displaying  %d columns\n",
               vlGetCols());
             }


          vlGetRows________________________________________________________

             Usage: int vlGetRows(void);

             Prototype in:  vlib.h

             Description:   vlGetRows   determines   the  number   of   rows
                            currently being displayed.

             Return Value:  Most systems  will  return  25 rows.    However,
                            DesqView windows  defined at unusual sizes  will
                            be detected,  as will  43-column, 50-column (and
                            other) displays.

             Example:

             #include <stdio.h>
             #include "vlib.h"


                                          8







             void main(void)
             {
               printf("The  monitor  is  currently  displaying  %d rows\n",
               vlGetRows());
             }


          vlIsDV___________________________________________________________

             Usage: int vlIsDV(void);

             Prototype in:  vlib.h

             Description:   vlIsDV  determines whether DesqView is installed
                            and active.

             Return Value:  If  DesqView  is active,  vlIsDV  returns  TRUE;
                            otherwise, FALSE is returned.

             Example:

             #include <stdio.h>
             #include "vlib.h"

             void main(void)
             {
               printf("DesqView %s active\n", vlIsDV() ? "is" : "is not");
             }


          vlIsEgaVga_______________________________________________________

             Usage: int vlIsEgaVga(void);

             Prototype in:  vlib.h

             Description:   vlIsEgaVga  determines whether an enhanced color
                            adapter is installed.

             Return Value:  If   an  EGA   or  VGA  adapter   is  installed,
                            vlIsEgaVga  returns  TRUE; otherwise,  FALSE  is
                            returned.

             Example:

             #include <stdio.h>

                                          9







             #include "vlib.h"

             void main(void)
             {
               printf("An EGA or VGA monitor %s installed.\n", vlIsEgaVga()
               ? "is" : "is not");
             }


          vlIsShift
          vlIsRShift
          vlIsLShift_______________________________________________________

             Usage: int vlIsLshift(void);
                    int vlIsRshift(void);
                    int vlIsShift(void);

             Prototype in:  vlib.h

             Description:   vlIsShift,  vlIsLShift and vlIsRShift return the
                            status  of  the  shift keys  as  appropriate for
                            each function.

             Return Value:  If the appropriate  shift key is being  pressed,
                            the function returns TRUE;   otherwise, FALSE is
                            returned.

             Example:

             #include <stdio.h>
             #include "vlib.h"

             void main(void)
             {
               printf("A shift key %s being pressed.\n", vlIsShift() ? "is"
               : "is not"); 
             }


          vlIsMono_________________________________________________________

             Usage: int vlIsMono(void);

             Prototype in:  vlib.h



                                          10







             Description:   vlIsMono determines  if the  current video  mode
                            is monochrome.

             Return Value:  If  the  current  video   mode  is   monochrome,
                            vlIsMono   returns  TRUE;  otherwise,  FALSE  is
                            returned.

             Example:

             #include <stdio.h>
             #include "vlib.h"

             void main(void)
             {
               printf("The monitor %s monochrome video mode.\n", vlIsMono()
               ? "is" : "is not");
             }

          vlCursorOff_____________________________________________________

             Usage: void vlCursorOff(void);

             Prototype in:  vlib.h

             Description:   Turns  off the  text mode  cursor.   Many  Bios'
                            have  bugs in this area, especially when dealing
                            with  very old  Hercules adapters  any  many EGA
                            adapters.  No attempt to address these bugs  has
                            been attempted in  ViewLib.  In the worst  case,
                            the  cursor   won't  disappear.    This  routine
                            automatically calls vlCursorSave.

             Example:

             #include "vlib.h"

             void main(void)
             {
               vlCursorOff();
             }

          vlCursorSave____________________________________________________

             Usage: void vlCursorSave(void);

             Prototype in:  vlib.h

                                          11







             Description:   Saves the current cursor  information for  later
                            retrieval.  Only one cursor can  be saved.  Each
                            call to  vlCursorSave overwrites the last cursor
                            saved.  This information  is extracted from  the
                            Bios  data area,  an area  which is  not used by
                            the rare video adapter.  

             Example:

             #include "vlib.h"

             void main(void)
             {
               vlCursorSave();
             }

          vlCursorRestore_________________________________________________

             Usage: void vlCursorRestore(void);

             Prototype in:  vlib.h

             Description:   Restores the last  cursor information saved.  If
                            vlCursorSave()  was  not previously  called, the
                            cursor's contents are undefined.

             Example:

             #include "vlib.h"

             void main(void)
             {
               vlCursorRestore();
             }













                                          12

