/*
**	$id: ssvcid icnfile.h 1.0 10/15/91  9:50 am$
**		Function prototypes and structures used with loading icons from disk.
**
**	(C) 1991	Larry Widing
*/
#ifndef	__ICNFILE_H__
#define	__ICNFILE_H__	1

#if	defined(CDECL)
	#undef	CDECL
#endif

#if	!defined(CDECL)
	#if	defined(__cplusplus)
		#define	CDECL	"C"
	#else
		#define	CDECL
	#endif
#endif

/*
** Icon File Directory Entry Format
*/
struct IconData {
	BYTE		width;			// width of icon (16, 32, 64)
	BYTE		height;			// height of icon (16, 32, 64)
	BYTE		colorCount;		// number of colors in icon (2, 8, 16)
	BYTE		reserved0;		// reserved for future use
	WORD		reserved1;		// reserved for future use
	WORD		reserved2;		// reserved for future use
	DWORD		icoDIBSize;		// size, in bytes, of icon image
	DWORD		icoDIBOffset;	// offset, in bytes, from start of file to image
};
typedef struct IconData ICONDATA;

/*
**	Icon File Header Format
*/
struct IconFileHeader {
	WORD	icoReserved;		// must be 0
	WORD	icoResourceType;	// must be 1
	WORD	icoResourceCount;	// number of images in this file
};
typedef struct IconFileHeader ICONFILEHEADER;

extern ICONDATA			CurIcon;
extern ICONFILEHEADER	CurIconFile;

/*
**	Function Prototypes
*/
extern CDECL HICON ReadIconFile(const char *filename);

#endif	/* !defined(__ICNFILE_H__) */

/*
**	Modification History
**	--------------------
**	$lgb$
** 10/15/91     Larry Widing   Initial version for Win Tech Journal Article.
**	$lge$
*/
