/*
 EPSHeader

   File: wildfile.h
   Author: J. Kercheval
   Created: Thu, 03/14/1991  20:10:16
*/
/*
 EPSRevision History

   J. Kercheval  Thu, 03/14/1991  21:15:57  ifdef attribute constants
   J. Kercheval  Sat, 03/16/1991  15:03:54  add FileInfo structure
   J. Kercheval  Sat, 03/16/1991  20:08:41  add status byte
   J. Kercheval  Sun, 03/31/1991  16:15:06  rename time and date defines
   D. Kirschbaum Mon, 05/13/1991  16:32:00  For Turbo C v2.0:
                                            Add <dos.h>
                                            Change some file attribs.
*/

#ifndef BOOLEAN
#define BOOLEAN int
#define TRUE 1
#define FALSE 0
#endif

/*
 * Dedicated to the Public Domain.  Use this for any purpose for any reason
 * with no restrictions, warranties, suitability for fitness etc.
 *
 * Wild File is a module designed to aid the developer in producing programs
 * which use a *sensible* wildcard scheme.  For instance using this module
 * your command line could specify any SH style regular expression which
 * produced a valid file name as input for file names.  The only limitation
 * is that since DOS uses the literal escape character '\' as a delimiter to
 * specifying a directory follow you may not use this character in the
 * command line in this routine.
 *
 * This module assumes compilation on MSC or Borland C (Turbo C, TCC, BCC)
 */


/*----------------------------------------------------------------------------
 *
 *
 * These routines allow the use of multiple search threads.  Simply declare a
 * variable to be of type FileInfo (perhaps called ff), fill in the
 * file_pattern and the file_attributes fields (ie.  ff.file_pattern and
 * ff.file_attributes), initiate the search with find_firstfile() and
 * continue the search with find_nextfile().  There is no reason why you
 * could not conduct more than one search simultaneously using several
 * different variables.
 *
 * In general you should not alter any element of the FileInfo structure once
 * find_firstfile() has been called.  You should never alter any element of
 * the file field in the FileInfo structure.  Doing so may make it impossible
 * to continue the search.
 *
 * The elements of the FileInfo structure are defined as follows:
 *
 *    file_pattern      A string representing the search expression
 *                      filled in by the caller before the call to
 *                      find_firstfile()
 *
 *    file_attributes   An 8 bit flag representing the file attributes
 *                      you are interested in.  This should be created
 *                      by using the | operator and the defined
 *                      constants below (ie. _FA_HIDDEN | _FA_NORMAL |
 *                      _FA_SYSTEM would obtain all files that were
 *                      hidden, system or normal (no attribute) files).
 *                      This should be filled before the call to
 *                      find_firstfile()
 *
 *    file_path         Derived from the file_pattern feild in
 *                      find_firstfile(), this feild represents the
 *                      path required to locate the file whose name is
 *                      found in file.name as described below
 *
 *    file              This is a structure defined by most compilers
 *                      and its contents are DOS defined.  It is filled
 *                      on a call to find_firstfile() or find_nextfile()
 *                      and contains specific information about each
 *                      file found.  If find_firstfile() or
 *                      find_nextfile() return FALSE then this
 *                      structure has undefined fields.
 *                      The structures elements are defined as:
 *
 *                          file.name       The name and extension of
 *                                          the last file found. Is of
 *                                          type char[13].
 *
 *                          file.size       The size in bytes of the
 *                                          last file found. Is of type
 *                                          long.
 *
 *                          file.attributes The ORed attributes of the
 *                                          last found file. Is of type
 *                                          char.
 *
 *                          file.datestamp  The data of last modification
 *                                          for the last found file. Is
 *                                          of type int with bits defined
 *                                          as follows:
 *                                              bits 0-4    day
 *                                              bits 5-8    month
 *                                              bits 9-15   years since 1980
 *
 *                          file.timestamp  The time of last modification
 *                                          for the last found file.  Is
 *                                          if type int with bits defined
 *                                          as follows:
 *                                              bits 0-4    seconds div 2
 *                                              bits 5-10   minutes
 *                                              bits 11-15  hours
 *
 *    status            Information flags used internally by this module.
 *                      There is no user interesting information and this
 *                      status byte should not be altered.  Changing this
 *                      field may result in incorrect file matching behavior
 *                      by find_nextfile().
 *
 * As an example use of these routines refer to the main() function at the
 * end of wildfile.c
 *
 ---------------------------------------------------------------------------*/

#ifdef __TURBOC__
#include <dir.h>
#include <dos.h>                /* v1.14 for FA_RDONLY, etc. */
#define info ffblk
#define attributes ff_attrib
#define timestamp ff_ftime
#define datestamp ff_fdate
#define size ff_fsize
#define name ff_name
#else
#include <dos.h>
#define info find_t
#define attributes attrib
#define timestamp wr_time
#define datestamp wr_date
#define size size
#define name name
#define MAXPATH   80
#endif

struct file_info_struct {

    /* thest elements should be set before the call to find_firstfile() */
    char file_pattern[2 * MAXPATH + 1]; /* the original file pattern */
    char file_attributes;       /* the wanted file attributes */

    /* these elements are filled by find_firstfile() and find_nextfile() */
    char file_path[MAXPATH + 1];/* the lead portion of the path */
    struct info file;           /* the file block */
    unsigned char status;       /* internal status information */
};

typedef struct file_info_struct FileInfo;


/*----------------------------------------------------------------------------
 *
 * In behavior regarding attributes, these routines differ a bit from the
 * standard DOS calls to findfile and findnext.  These routines will only
 * return files with those attributes you explicitly set.  The standard DOS
 * call will return all normal files in addition to the attributes wanted.
 * This is a little silly since the behavior is true for only certian
 * attribute bits.  The Volume bit set will not result in the return of
 * normal files.  One side effect of this design decision is that you must
 * explicitly ask for files with normal or *no* attributes.  Believe me this
 * is NOT a hardship.
 *
 * To obtain a combination of attributes just or the attribute constants as
 * needed (ie. _FA_NORMAL | _FA_READONLY).  Only those files with a wanted
 * attribute will be returned.  If files without any attributes are wanted
 * then you must or the A_NORMAL constant into the attr parameter (This is
 * different behavior than the standard findfirst, findnext call behavior).
 *
 * Note: These constants are defined internally for portability.  The
 * constant used does not change but the various compilers sure have invented
 * enough names for them.  I assume BC (Turbo C) or MSC.
 *
 * The file attribute definitions are as follows:
 *
 *    _FA_READONLY   Search for readonly files
 *    _FA_HIDDEN     Search for hidden files
 *    _FA_SYSTEM     Search for system files
 *    _FA_VOLUME     Search for Volume label
 *    _FA_DIRECTORY  Search for Directory
 *    _FA_ARCHIVE    Search for non backup up files
 *    _FA_NORMAL     Search for all normal files
 *
 ---------------------------------------------------------------------------*/

/* if not using Borland C then assume MSC */

#ifdef __TURBOC__
#define _FA_READONLY  FA_RDONLY /* FA_READONLY v1.14 */
#define _FA_HIDDEN    FA_HIDDEN
#define _FA_SYSTEM    FA_SYSTEM
#define _FA_VOLUME    FA_VOLUME
#define _FA_DIRECTORY FA_DIREC  /* FA_DIRECTORY v1.14 */
#define _FA_ARCHIVE   FA_ARCH   /* FA_ARCHIVE v1.14 */
#define _FA_NORMAL    0x40
#else
#define _FA_READONLY  _A_RDONLY
#define _FA_HIDDEN    _A_HIDDEN
#define _FA_SYSTEM    _A_SYSTEM
#define _FA_VOLUME    _A_VOLID
#define _FA_DIRECTORY _A_SUBDIR
#define _FA_ARCHIVE   _A_ARCH
#define _FA_NORMAL    0x40
#endif


/*----------------------------------------------------------------------------
 *
 * find_firstfile() will find the first file matching file_pattern.
 * find_nextfile() will find the next file matching the name specified by
 * find_firstfile().  The routines will return the BOOLEAN value FALSE if the
 * file is not found in the call to find_firstfile() or if there are no more
 * files found in a call to find_nextfile.  If a file is found then both
 * routines will return the BOOLEAN value TRUE.
 *
 * file_pattern may be SH style regular expressions.  The regular expression
 * symbols allowed are:
 *
 *       '*' -- Matches any set of zero or more characters
 *       '?' -- Matches any single character
 *       [SET] matches any character in the specified set,
 *       [!SET] or [^SET] matches any character not in the specified set.
 *       \ is allowed within a set to escape a character like ']' or '-'
 *
 * A set is composed of characters or ranges; a range looks like character
 * hyphen character (as in 0-9 or A-Z).  [0-9a-zA-Z_] is the minimal set of
 * characters allowed in the [..] pattern construct.  Other characters are
 * allowed (ie. 8 bit characters) if your system will support them.
 *
 * To suppress the special syntactic significance of any of `[]*?!^-\' within
 * an [..] construct and match the character exactly, precede it with a `\'.
 *
 * Parameters:
 *       ff - a pointer to a FileInfo structure already allocated or
 *            declared.
 *
 ---------------------------------------------------------------------------*/

BOOLEAN find_firstfile(FileInfo * ff);
BOOLEAN find_nextfile(FileInfo * ff);
