/***************************************************************************
*   XMSLIB.H                                                               *
*   HEADER FOR XMSLIB                                                      *
*   OS:        DOS                                                         *
*   VERSION:   1.21                                                        *
*   DATE:      06/04/91                                                    *
*                                                                          *
*   Copyright (c) 1991 James W. Birdsall. All Rights Reserved.             *
*                                                                          *
***************************************************************************/

#define XMSLIB_H

/*
** system includes <>
*/

/*
** custom includes ""
*/

/*
** local #defines
*/

/* error returns */

#define XMMOOPS     -1
#define NOXMM       -2


/* XMS library errors */

#define XMM_TOOSHORT        0x40


/* XMS driver errors */

#define XMM_UNIMP           0x80
#define XMM_VDISK           0x81
#define XMM_A20ERROR        0x82
#define XMM_GENERROR        0x8E
#define XMM_UNRECERROR      0x8F

#define XMM_NOHMA           0x90
#define XMM_HMAUSED         0x91
#define XMM_HMATOOBIG       0x92
#define XMM_HMANOALLOC      0x93
#define XMM_A20STILLEN      0x94

#define XMM_NOFREEX         0xA0
#define XMM_NOFREEXHAN      0xA1
#define XMM_BADXHAN         0xA2
#define XMM_BADSRCHAN       0xA3
#define XMM_BADSRCOFF       0xA4
#define XMM_BADDESTHAN      0xA5
#define XMM_BADDESTOFF      0xA6
#define XMM_BADLENGTH       0xA7
#define XMM_COPYOVERLAP     0xA8
#define XMM_PARITY          0xA9
#define XMM_NOLOCK          0xAA
#define XMM_LOCKED          0xAB
#define XMM_TOOMANYLOCKS    0xAC
#define XMM_LOCKFAIL        0xAD

#define XMM_UMBSMALLER      0xB0
#define XMM_NOFREEUMB       0xB1
#define XMM_BADUMBHAN       0xB2


/* function macros */

#define XMMcopyto(clen,src,dhan,doff)    _XMMcopy((clen),0, \
                                            (unsigned long)(src),(dhan),(doff))
#define XMMcopyfrom(clen,shan,soff,dest) _XMMcopy((clen),(shan),(soff),0, \
                                                         (unsigned long)(dest))


/*
** misc: copyright strings, version macros, etc.
*/

/*
** typedefs
*/

struct XMMregs {
    unsigned int regAX;
    unsigned int regBX;
    unsigned int regDX;
    unsigned int regSI;
    unsigned int regDS;
};


/*
** global variables
*/

extern unsigned char _XMMerror;         /* EMS error variable */
extern unsigned int  _XMMversion;       /* EMS version, BCD */

extern char xmslib_vers_vers[];
extern char xmslib_vers_date[];
extern char xmslib_vers_time[];


/*
** function prototypes
*/

extern int XMMlibinit(void);
extern int XMMgetversion(void);

extern unsigned long XMMcoreleft(void);
extern unsigned long XMMallcoreleft(void);

extern int XMMalloc(unsigned long bytes);
extern int XMMfree(int handle);

extern int _XMMcopy(unsigned long clen, int shan, unsigned long soff,
                                                 int dhan, unsigned long doff);

extern int XMMrawcall(struct XMMregs *regs);