/***************************************************************************
*   XMSTEST.C                                                              *
*   VERSION: 1.0                                                           *
*   DATE:    06/07/91                                                      *
*                                                                          *
*   Copyright (c) 1991 James W. Birdsall. All Rights Reserved.             *
*                                                                          *
*   Compiles under Turbo C, Turbo C++, Borland C++.                        *
*                                                                          *
*   This is an example of the use of the XMSLIB functions. This simple     *
*   demo program copies one file to another, using an EMB (extended memory *
*   block) as a buffer. There must be a single EMB larger than the length  *
*   of the file, since the entire file is stored at once.                  *            *
*                                                                          *
*   If the symbol LONG is defined, a large temporary buffer is used. If    *
*   not, a small temporary buffer is used.                                 *
*                                                                          *
***************************************************************************/

/*
** system includes <>
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys\stat.h>


/*
** custom includes ""
*/

#include "xmslib.h"


/*
** local #defines
*/

#ifdef LONG
#define BUFFERSIZE 30000
#else
#define BUFFERSIZE 159
#endif


/*
** misc: copyright strings, version macros, etc.
*/

/*
** typedefs
*/

/*
** global variables
*/

unsigned char buffer[BUFFERSIZE];


/*
** static globals
*/

/*
** function prototypes
*/

/*
** functions
*/


main(int argc, char *argv[])
{
   FILE *infile, *outfile;
   long filrem, MMoffset, freebytes;
   struct stat statbuf;
   int MMhandle;
   unsigned int readsize;

   /*
   ** Check for enough arguments.
   */
   if (argc < 3)
   {
      printf("Usage: %s infile outfile\n", argv[0]);
      exit(3);
   }

   /*
   ** INITIALIZE XMSLIB! VERY IMPORTANT!
   */
   if (XMMlibinit() != 0)
   {
      printf("Error in XMSLIB initialization.\n");
      exit(3);
   }

   /*
   ** Get size of largest EMB, total of all EMBs, display
   */
   freebytes = XMMallcoreleft();
   if (_XMMerror != 0)
   {
       printf("Error %x in XMMallcoreleft()\n", _XMMerror);
       exit(3);
   }
   printf("XMS: total free %lu bytes, ", freebytes);
   freebytes = XMMcoreleft();
   if (_XMMerror != 0)
   {
       printf("Error %x in XMMcoreleft()\n", _XMMerror);
       exit(3);
   }
   printf("largest free EMB %lu bytes\n", freebytes);

   /*
   ** Get size of input file so we know how many bytes to allocate.
   */
   if (stat(argv[1], &statbuf) != 0)
   {
      printf("stat() error.\n");
      exit(3);
   }
   filrem = statbuf.st_size;
   if (filrem > freebytes)
   {
      printf("Largest available EMB too small to copy file.\n");
      exit(3);
   }

   /*
   ** Allocate EMB.
   */
   MMhandle = XMMalloc((unsigned long) filrem);
   if (MMhandle == XMMOOPS)
   {
      printf("Error %x allocating EMB.\n", (int) _XMMerror);
      exit(3);
   }

   /*
   ** Open input file.
   */
   if ((infile = fopen(argv[1], "rb")) == (FILE *) NULL)
   {
      printf("Error opening file %s\n", argv[1]);
      XMMfree(MMhandle);
      exit(3);
   }

   /*
   ** Main loop. Data is read from the input file into the temporary buffer,
   ** then copied from the temporary buffer to the EMB.
   */
   MMoffset = 0;
   printf("Reading file");
   while (filrem > 0)
   {
      /* figure out how much to read */
      readsize = ((filrem > BUFFERSIZE) ? BUFFERSIZE : (int)filrem);

      /* read */
      if (fread(buffer, sizeof(char), readsize, infile) != readsize)
      {
         printf("Error reading file %s\n");
         XMMfree(MMhandle);
         exit(3);
      }

      /* copy to XMS */
      if (XMMcopyto((unsigned long) readsize, (unsigned char far *) buffer,
                                MMhandle, (unsigned long) MMoffset) == XMMOOPS)
      {
         printf("Error %x writing to EMB.\n", (int) _XMMerror);
         XMMfree(MMhandle);
         exit(3);
      }

      /* display, update variables */
      printf(".");
      filrem -= readsize;
      MMoffset += readsize;
   }

   /*
   ** Close input file, open output file.
   */
   fclose(infile);
   if ((outfile = fopen(argv[2], "wb")) == (FILE *) NULL)
   {
      printf("Error opening file %s\n", argv[2]);
      XMMfree(MMhandle);
      exit(3);
   }

   /*
   ** The other main loop. Data is copied from XMS to the temporary buffer,
   ** then written to the output file.
   */
   filrem = MMoffset;
   MMoffset = 0;
   printf("\nWriting file");
   while (filrem > 0)
   {
      /* figure out how many bytes to copy */
      readsize = ((filrem > BUFFERSIZE) ? BUFFERSIZE : (int)filrem);

      /* copy from XMS */
      if (XMMcopyfrom((unsigned long) readsize, MMhandle,
            (unsigned long) MMoffset, (unsigned char far *) buffer) == XMMOOPS)
      {
         printf("Error %x reading from EMB.\n", (int) _XMMerror);
         XMMfree(MMhandle);
         exit(3);
      }

      /* write */
      if (fwrite(buffer, sizeof(char), readsize, outfile) != readsize)
      {
         printf("Error writing file %s\n");
         XMMfree(MMhandle);
         exit(3);
      }

      /* display, update variables */
      printf(".");
      filrem -= readsize;
      MMoffset += readsize;
   }

   /*
   ** Close output file, free EMB.
   */
   fclose(outfile);
   XMMfree(MMhandle);

   /*
   ** Done.
   */
   printf("\nDone.\n");
   exit(0);
} /* end of main() */


