'LZ78 Decompressor
'Warning: Do NOT press CTRL+Break and then continue this program while
'you are running it in the environment! At best, the resulting decompressed
'file will be invalid(or you'll receive "??BAD CODE IN FILE"). At worst, your
'machine will lock up.
DEFINT A-Z
DECLARE FUNCTION GetBit ()
DECLARE FUNCTION GetData (C)

DECLARE SUB PutByte (A)
DECLARE SUB Rebuild.Table (New.Entries)
DECLARE FUNCTION GetCode ()
DECLARE FUNCTION GetByte ()
CONST True = -1, False = 0

'Prefix & Suffix of each code
DIM SHARED Prefix(4352), Suffix(4352), Used(4352)
DIM OutCode(4096)

'Input and output disk buffers
DIM SHARED InBuffer$, IAddress, IEndAddress, Iseg
DIM SHARED OutBuffer$, OStartAddress, OAddress, OEndAddress, Oseg

'Used for screen updating
DIM SHARED BytesIn&

'Powers of two
DIM SHARED Powers(7)
DIM SHARED LongPowers(12) AS LONG
'Mask for each codesize
DIM SHARED Masks(12)
'Current codesize
DIM SHARED CodeSize
DIM SHARED TempChar, BitsLeft

LOCATE , , 1
IF POS(0) <> 1 THEN PRINT

PRINT "D2.BAS - Modified LZ78 Decoder in QuickBASIC 4.5"
PRINT "By Rich Geldreich 1992"

A$ = COMMAND$
IF A$ = "" THEN INPUT "File to decompress"; A$
IF A$ = "" THEN END

FOR A = 0 TO 7: Powers(A) = 2 ^ A: NEXT
FOR A = 0 TO 12: LongPowers(A) = 2 ^ A: NEXT
FOR A = 1 TO 12: Masks(A) = (2 ^ A) - 1: NEXT

'Initialize each disk buffer
InBuffer$ = STRING$(5000, 0)
OutBuffer$ = STRING$(5000, 0)
'Find address of output buffer
A& = SADD(OutBuffer$)
A& = A& - 65536 * (A& < 0)
Oseg = SSEG(OutBuffer$) + (A& \ 16)
OAddress = A& AND 15
OEndAddress = OAddress + 5000
OStartAddress = OAddress
BytesIn& = 0


'Open files
OPEN "OUTPUT.LZ1" FOR BINARY AS #1
IF LOF(1) = 0 THEN
    CLOSE
    KILL "OUTPUT.LZ1"
    PRINT "Nothing to decompress."
    END
END IF

OPEN A$ FOR BINARY AS #2

'First code is 259
FreeCode = 259
StartCode = 259
CodeSize = 3

Code = GetCode
CurCode = Code
OldCode = Code
FinChar = Code
PutByte FinChar

FileLength& = LOF(1)
IF POS(0) <> 1 THEN PRINT
PRINT "Decompressing:";
Y = CSRLIN: X = POS(0)
'Main decompression loop
DO

    OutputCounter = OutputCounter + 1
    IF OutputCounter = 256 THEN
        LOCATE Y, X
        PRINT (100& * BytesIn&) \ FileLength&; "% done";
        OutputCounter = 0
    END IF

GetCode:
    'Get code from input file
    Code = GetCode
    'Process code
    SELECT CASE Code
    'End of file command
    CASE 256
        OutBuffer$ = LEFT$(OutBuffer$, OAddress - OStartAddress)
        PUT #2, , OutBuffer$
        LOCATE Y, X
        PRINT " done       "
        CLOSE : END
    'Increase code size command
    CASE 257
        CodeSize = CodeSize + 1
    'Rebuild table command
    CASE 258
        Rebuild.Table New.Entries
        FreeCode = New.Entries + StartCode
        CodeSize = 3

        IF FreeCode > 4352 THEN
            FreeCode = StartCode
            Code = GetCode
             
            CurCode = Code
            OldCode = Code
             
            FinChar = Code
            PutByte FinChar
        ELSE
            'prevents an invalid code from entering the table
            Ignore.Next = True
        END IF

    'Process a code
    CASE ELSE
       
        CurCode = Code
        InCode = Code
        'Do we have this string yet?
        IF Code >= FreeCode THEN
            'If Code>FreeCode then stop decompression: this can't be right!
            IF Code > FreeCode THEN PRINT "??BAD CODE IN FILE": CLOSE : END

            'Trick decompressor to use last code
            Used(Code) = Used(Code) + 1
            CurCode = OldCode
            OutCode(OutCount) = FinChar
            OutCount = OutCount + 1
        END IF
        
        'Does this code represent a string?
        IF CurCode >= StartCode THEN
            'Get each character from the table and "push" it onto the stack
            DO
                Used(CurCode) = Used(CurCode) + 1
                OutCode(OutCount) = Suffix(CurCode)
                OutCount = OutCount + 1
                CurCode = Prefix(CurCode)
            'keep on doing this until we have a normal character
            LOOP UNTIL CurCode <= 255
        END IF
        FinChar = CurCode

        PutByte FinChar

        'Pop all the codes of the stack and put them into the output file
        FOR A = OutCount - 1 TO 0 STEP -1
            PutByte OutCode(A)
        NEXT

        OutCount = 0
        'Put the new string into the table
        IF Ignore.Next THEN
            Ignore.Next = False 'don't use this string yet if the table
                                'has just been rebuilt
        ELSE
            Prefix(FreeCode) = OldCode
            Suffix(FreeCode) = FinChar
            FreeCode = FreeCode + 1
        END IF
        OldCode = InCode
    END SELECT
LOOP

FUNCTION GetBit STATIC
    IF BitsLeft = 0 THEN
        TempChar = GetByte
        BitsLeft = 8
    END IF
    GetBit = (TempChar \ Powers(8 - BitsLeft)) AND 1
    BitsLeft = BitsLeft - 1
END FUNCTION

FUNCTION GetByte STATIC
    IF IAddress = IEndAddress THEN
        GET #1, , InBuffer$
        A& = SADD(InBuffer$)
        A& = A& - 65536 * (A& < 0)
        Iseg = SSEG(InBuffer$) + (A& \ 16)
        IAddress = A& AND 15
        IEndAddress = IAddress + 5000
    END IF
    DEF SEG = Iseg
    GetByte = PEEK(IAddress)
    BytesIn& = BytesIn& + 1
    IAddress = IAddress + 1
END FUNCTION

FUNCTION GetCode
    IF GetBit THEN
        GetCode = GetData(CodeSize) + 256 'get a compression code
    ELSE
        GetCode = GetData(8) 'get a normal character
    END IF
END FUNCTION

FUNCTION GetData (C) STATIC

    IF BitsLeft = 0 THEN
        TempChar = GetByte
        BitsLeft = 8
    END IF
    WorkCode& = TempChar \ Powers(8 - BitsLeft)
    DO WHILE C > BitsLeft
        TempChar = GetByte
        WorkCode& = WorkCode& OR TempChar * LongPowers(BitsLeft)
        BitsLeft = BitsLeft + 8
    LOOP
    BitsLeft = BitsLeft - C
    GetData = WorkCode& AND Masks(C)

END FUNCTION

SUB PutByte (A) STATIC
    IF OAddress = OEndAddress THEN
        PUT #2, , OutBuffer$
        OAddress = OStartAddress
    END IF
    DEF SEG = Oseg
    POKE OAddress, A
    OAddress = OAddress + 1
END SUB

SUB Rebuild.Table (New.Entries)
    DIM P(4096), S(4096), U(4096) AS LONG, Pn(4096), Location(4096)
    DIM C(4352)
   
    SHARED StartCode

    'Collect all used codes.
    Num.Entries = 0
    FOR A = StartCode TO 4352
        IF Used(A) > 0 THEN
            Used(A) = 0
            P = Prefix(A): S = Suffix(A)
            P(Num.Entries) = P
            S(Num.Entries) = S
            U(Num.Entries) = P * 4353& + S
            C(A) = Num.Entries
            Num.Entries = Num.Entries + 1
        END IF
    NEXT
  
    'Build pointers to all used codes.
    Num.Entries = Num.Entries - 1
    FOR A = 0 TO Num.Entries
        Pn(A) = A
    NEXT
  
    'Sort the used codes based on the value of Prefix*4353+Suffix
    '(larger codes go farther down the table).
    Mid = Num.Entries \ 2
    DO
        FOR A = 0 TO Num.Entries - Mid
            CompareLow = A
            CompareHigh = A + Mid
            DO WHILE U(Pn(CompareLow)) > U(Pn(CompareHigh))
                SWAP Pn(CompareLow), Pn(CompareHigh)
                CompareHigh = CompareLow
                CompareLow = CompareLow - Mid
                IF CompareLow < 0 THEN EXIT DO
            LOOP
        NEXT
        Mid = Mid \ 2
    LOOP WHILE Mid > 0
   
    FOR A = 0 TO Num.Entries
        Location(Pn(A)) = A
    NEXT
    
    'Rebuild the encoding table- modify the Prefix if it points to any
    'strings.
    FOR A1 = 0 TO Num.Entries
        A = Pn(A1)
     
        P = P(A)
        
        IF P >= StartCode THEN P = StartCode + Location(C(P))
        
        Prefix(A1 + StartCode) = P
        Suffix(A1 + StartCode) = S(A)
       
    NEXT
    
    '# of entries in the hash table now
    New.Entries = Num.Entries + 1

END SUB

