'***********************************************************************
'* LZWFAST.BAS by Rich Geldreich 1992
'*
'* A _much_ quicker version of QBLZW.BAS
'*
'* QuickBASIC users: you must change all of the "SSEG" string to "VARSEG"
'* in this program with search and replace!
'*
'* NOTE: The DIM statements in this program use the constant 
'* "Hash.Table.Size". For this program to work in a multimodule program,
'* these constants must be changed to their actual values(7177).

DEFINT A-Z

DECLARE FUNCTION RG.Decompress (A$, B$, bytes.out)
DECLARE FUNCTION RG.Compress (A$, B$, bytes.out)

CONST Hash.Table.Size = 7177  'must be a prime number!
CONST True = -1, False = 0

CLS
DO UNTIL INKEY$ <> ""
    PRINT "preparing data..."
    RANDOMIZE TIMER
    A$ = "": B$ = "": C$ = ""
    A$ = SPACE$(100 + RND * 5000)
    B$ = SPACE$(10000)
    D$ = CHR$(INT(RND * 256))
    FOR A = 1 TO LEN(A$)
        MID$(A$, A, 1) = D$
        IF RND < .4 THEN D$ = CHR$(INT(RND * 256))
    NEXT
    PRINT "compressing: bytes in:"; LEN(A$)
    IF RG.Compress(A$, B$, bytes.out) THEN
        BEEP
        PRINT "compression failure!"
        END
    END IF
    PRINT "compressed: bytes out:"; bytes.out
    B$ = LEFT$(B$, bytes.out)
    C$ = SPACE$(LEN(A$))
    IF RG.Decompress(B$, C$, bytes.out) THEN
        BEEP
        PRINT "decompress failure!"
        END
    END IF
    C$ = LEFT$(C$, bytes.out)
    IF C$ <> A$ THEN
        BEEP
        PRINT "compression/decompress failure!"
        END
    ELSE
        PRINT "success!"
    END IF
LOOP

'***********************************************************************
'* Purpose:
'*  Takes the input string, A$, and compresses it to the output string,
'*  B$. B$ must not be null; it must have characters in it. Example:
'*
'*  A$="Zeek says to brush your teeth every morning."  'input string
'*  B$=STRING$(80,32)                                  'output string
'*  IF RG.Compress(A$,B$,Bytes.Out) THEN               'compress string
'*      PRINT "It didn't work for some reason..."
'*  ELSE
'*      PRINT "It worked."
'*      B$=LEFT(B$, Bytes.Out)                         'shrink output string
'*  END IF
'*
'*  This function returns -1 (True) if the compression didn't work.
'*  It returns 0 (False) if it did.
'
FUNCTION RG.Compress (A$, B$, bytes.out)
    DIM Shift(14) AS LONG
   
    DIM Prefix(Hash.Table.Size)
    DIM Suffix(Hash.Table.Size)
    DIM Code(Hash.Table.Size)


    FOR A = 0 TO 14: Shift(A) = 2 ^ A: NEXT     'for quick shifts

    In.Length = LEN(A$)                         'length of input string
    Out.Length = LEN(B$)                        'length of output string
   
    IF In.Length = 0 THEN                       'nothing to compress?
        RG.Compress = True                      'error condition
        bytes.out = 0
        EXIT FUNCTION
    END IF
   
    EOF.Code = 256                              'end of compression code
    I.Code = 257                                'code size increment code
    Start.Code = 258                            'first available code
    Next.Code = 258                             'current code
    Max.Code = 512                              'max code in 9 bits
   
    Code.Size = 9                               'current code size
    Current.Bit = 0                             'current output bit
    Char& = 0                                   'current output char


    GOSUB RG.Clear.Table                        'clear compression table

    '***************
    A& = SADD(A$)
    A& = A& - 65536 * (A& < 0)
    In.Seg = SSEG(A$) + (A& \ 16)
    In.Address = (A& MOD 16)
    In.End.Address = In.Address + In.Length

    A& = SADD(B$)
    A& = A& - 65536 * (A& < 0)
    Out.Seg = SSEG(B$) + (A& \ 16)
    Out.Address = (A& MOD 16)
    Out.Start.Address = Out.Address
    Out.End.Address = Out.Address + Out.Length
    '***************

    DEF SEG = In.Seg: Prefix = PEEK(In.Address)
    In.Address = In.Address + 1
    
    DO 'while we have more characters to compress

        DEF SEG = In.Seg

        DO 'until we find a new string
            IF In.Address = In.End.Address THEN  'are we at the end of the string?
                'put prefix of current string, send EOF code, padd out
                'the extra bits left and end with no error
                Code = Prefix: GOSUB RG.Put.Code
                Code = EOF.Code: GOSUB RG.Put.Code
                Code = 0: GOSUB RG.Put.Code

                bytes.out = Out.Address - Out.Start.Address
                RG.Compress = False
                
                EXIT FUNCTION
            ELSE 'we must get another byte and search for the Prefix:Suffix
                 'string
               
                Suffix = PEEK(In.Address)
                In.Address = In.Address + 1
                
                GOSUB RG.Hash 'does the Prefix:Suffix string exist?
                
                IF Found THEN 'yes, replace it with what's already in the table
                    Prefix = Code(Index)
                END IF
            END IF
        LOOP WHILE Found 'LOOP until we find a new string
        
        Code = Prefix: GOSUB RG.Put.Code 'output the prefix of the string
       
        Prefix(Index) = Prefix 'put the string into the hash table
        Suffix(Index) = Suffix
        Code(Index) = Next.Code
        
        Prefix = Suffix 'restart with the last character received
        Next.Code = Next.Code + 1 'prepare for next code
        
        IF Next.Code > Max.Code THEN 'do we have to increase the code size?
            
            Code = I.Code: GOSUB RG.Put.Code 'yes, send increment code size code
                                             '(this does not really have to be
                                             'done, the decompressor could
                                             'increment the code size itself...)
            Max.Code = Max.Code * 2          'new max code
            Code.Size = Code.Size + 1        'increment code size
            

            IF Code.Size > 12 THEN           'more than 12 bits?
                GOSUB RG.Clear.Table         'clear the table: this could be
                                             'changed so we only deleted the
                                             'strings that are used the least
                                             'for better compression
                
                Next.Code = Start.Code      'reset NextCode to top of tree
                Code.Size = 9               'code size of 9 bits
                Max.Code = 512              'maximum codes in 9 bits
            END IF
        END IF
    LOOP


RG.Clear.Table: 'clears the hash table
    FOR A = 0 TO Hash.Table.Size
        Prefix(A) = -1
        Suffix(A) = -1
        Code(A) = -1
    NEXT
RETURN


RG.Put.Code: 'puts one code into the output string

    DEF SEG = Out.Seg

    Char& = Char& + Code * Shift(Current.Bit)  'shift code and put into buffer
    Current.Bit = Current.Bit + Code.Size      'adjust # of bits in buffer
    DO WHILE Current.Bit > 7                   'do we have a full byte?
        
        IF Out.Address = Out.End.Address THEN 'do we have a big enough string?
            RG.Compress = True 'nope
            bytes.out = 0
            EXIT FUNCTION
        END IF

        POKE Out.Address, Char& AND 255
        Out.Address = Out.Address + 1
        
        Char& = Char& \ 256                    'remove the byte now
        Current.Bit = Current.Bit - 8          'adjust # of bits in buffer
    LOOP 'while we still have a complete byte left

RETURN

'The following routine searches the string table for a Prefix:Suffix.
RG.Hash:
    'calculate a key: this formula gives about a 10% retry...
    Index = (Prefix * 256& XOR Suffix) MOD Hash.Table.Size
    'special case for index = 0
    IF Index = 0 THEN
        Offset = 1
    ELSE
        Offset = Hash.Table.Size - Index 'calculate retry length
    END IF
    
    DO 'while we still haven't found either (1) a 'blank' entry or (2)
       'what we're looking for
        IF Code(Index) = -1 THEN  'is there anything in this entry?
            Found = False         'nope: we didn't find the Prefix:Suffix
            RETURN
        'is this what we're looking for?
        ELSEIF Prefix(Index) = Prefix AND Suffix(Index) = Suffix THEN
            Found = True
            RETURN
        ELSE 'the dreaded "retry"! we must go back and try again...
            Index = Index - Offset
            IF Index < 0 THEN Index = Index + Hash.Table.Size 'wrap back if
        END IF                                                'too far
    LOOP
END FUNCTION

'***********************************************************************
'* Purpose:
'*  Takes a compressed string, A$, and decompresses it to the output
'*  string, B$. B$ must not be null; it must have characters in it.
'*  Example:
'*  'A$ must already contain a compressed string!
'*  B$=STRING$(40,32)                                  'output string
'*  IF RG.Decompress(A$,B$,Bytes.Out) THEN             'decompress string
'*      PRINT "It didn't work for some reason..."
'*  ELSE
'*      PRINT "It worked."
'*      B$=LEFT$(B$, Bytes.Out)                        'Shrink output string
'*  END IF
'*
'*  This function returns -1 (True) if the decompression didn't work.
'*  It returns 0 (False) if it did.
'
FUNCTION RG.Decompress (A$, B$, bytes.out)

    DIM Powers(7)
    DIM Long.Powers(12) AS LONG
    DIM Masks(12)

    DIM Prefix(4096)  'contains strings: this is not a hashing table!
    DIM Suffix(4096)
    DIM Out.Code(4096) 'simulates a stack
    
    'for getting multi-bit codes from the input data stream...
    FOR A = 0 TO 7: Powers(A) = 2 ^ A: NEXT
    FOR A = 0 TO 12: Long.Powers(A) = 2 ^ A: NEXT
    FOR A = 1 TO 12: Masks(A) = (2 ^ A) - 1: NEXT

    In.Length = LEN(A$)
    Out.Length = LEN(B$)
   
    IF In.Length = 0 THEN   'nothing to decompress?
        RG.Decompress = True 'return with error
        bytes.out = 0
        EXIT FUNCTION
    END IF

    EOF.Code = 256          'EOF code
    I.Code = 257            'code size increment code
    Free.Code = 258         'current code
    Start.Code = 258        'first free code
    
    Code.Size = 9           'starting code size
    '*****************
    A& = SADD(A$)
    A& = A& - 65536 * (A& < 0)
    In.Seg = SSEG(A$) + (A& \ 16)
    In.Address = (A& MOD 16)
    In.End.Address = In.Address + In.Length

    A& = SADD(B$)
    A& = A& - 65536 * (A& < 0)
    Out.Seg = SSEG(B$) + (A& \ 16)
    Out.Address = (A& MOD 16)
    Out.Start.Address = Out.Address
    Out.End.Address = Out.Address + Out.Length
    '*****************

    GOSUB RG.Get.Code       'get first code: it contains a normal character
    
    Cur.Code = Code
    Old.Code = Code         'remember this code
    Fin.Char = Code
    Byte = Fin.Char: GOSUB RG.Write.Byte  'write code out to output string

DO 'until we receive an EOF code


    GOSUB RG.Get.Code 'get a code
    SELECT CASE Code
   
    CASE EOF.Code    'are we at the end?
        bytes.out = Out.Address - Out.Start.Address
        RG.Decompress = False
        
        EXIT FUNCTION
    CASE I.Code      'time to increase the code size?
        Code.Size = Code.Size + 1

        IF Code.Size > 12 THEN 'code size too big?
            Code.Size = 9      'reset code size
            Free.Code = Start.Code
            GOSUB RG.Get.Code  'get a code: it's a normal character
            Cur.Code = Code    'remember this code
            Old.Code = Code
            Fin.Char = Code
            Byte = Fin.Char: GOSUB RG.Write.Byte  'write it out...
        END IF
    CASE ELSE 'we have a 'normal' code
        
        Cur.Code = Code
       
        In.Code = Code  'remember what code we just got for later

        IF Code >= Free.Code THEN 'do we have this string yet?
            IF Code > Free.Code THEN 'is it asking for a string that we
                RG.Decompress = True 'can't possibly have?
                bytes.out = 0  'yup; the input string is corrupted
                               'decompression not possible
                EXIT FUNCTION
            END IF
            Cur.Code = Old.Code 'trick decompressor into thinking
                                'we got the last code
            Out.Code(Out.Count) = Fin.Char 'put character onto stack
            Out.Count = Out.Count + 1
        END IF
        
        IF Cur.Code >= Start.Code THEN  'does this code represent a string?
            DO 'while there are still more characters left in this string
                'push the character onto the stack
                Out.Code(Out.Count) = Suffix(Cur.Code)
                Out.Count = Out.Count + 1
                Cur.Code = Prefix(Cur.Code)
            LOOP UNTIL Cur.Code <= 255  'LOOP UNTIL we have the last character
        END IF
        
        Fin.Char = Cur.Code
        Out.Code(Out.Count) = Fin.Char

        DEF SEG = Out.Seg
        FOR A = Out.Count TO 0 STEP -1 'pop each character off the stack
            'put the character into the output string
            
            IF Out.Address = Out.End.Address THEN 'are we too far?
                RG.Decompress = True
                bytes.out = 0
                EXIT FUNCTION
            END IF
        
            POKE Out.Address, Out.Code(A)
            Out.Address = Out.Address + 1
        NEXT
        Out.Count = 0 'reset stack
        
        Prefix(Free.Code) = Old.Code 'put the new string into the table
        Suffix(Free.Code) = Fin.Char
        Old.Code = In.Code           'prepare for next code
        Free.Code = Free.Code + 1
    END SELECT
LOOP

RG.Read.Byte:
    DEF SEG = In.Seg
    Temp.Char = PEEK(In.Address)
    In.Address = In.Address + 1
RETURN

RG.Write.Byte:
    IF Out.Address = Out.End.Address THEN 'are we too far?
        RG.Decompress = True
        bytes.out = 0
        EXIT FUNCTION
    END IF
    DEF SEG = Out.Seg
    POKE Out.Address, Byte
    Out.Address = Out.Address + 1
RETURN

RG.Get.Code:
    DEF SEG = In.Seg

    IF Bits.Left = 0 THEN 'do we have at least one bit to work with?
        Temp.Char = PEEK(In.Address)
        In.Address = In.Address + 1
        Bits.Left = 8 'we now have 1 byte
    END IF
    'put whatever we got into the work buffer
    Work.Code& = Temp.Char \ Powers(8 - Bits.Left)
    'DO while we need more bits
    DO WHILE Code.Size > Bits.Left
        'get a byte
        Temp.Char = PEEK(In.Address)
        In.Address = In.Address + 1
        
        'shift byte into place
        Work.Code& = Work.Code& OR Temp.Char * Long.Powers(Bits.Left)
        'we now have 8 more bits
        Bits.Left = Bits.Left + 8
    LOOP
    'adjust the number of bits left
    Bits.Left = Bits.Left - Code.Size
    'AND the work.code with the code mask to get the final code
    Code = Work.Code& AND Masks(Code.Size)
RETURN
END FUNCTION

