// ObjectWindows - (C) Copyright 1992 by Borland International
// File: DIALTEST.CPP
/* 
   This modified OWL example, DIALTEST has been changed to 
   demonstrate a Bordlg dialogbox which uses Borbtn with
   bitmaps to represent three states. No changes were needed to
   the CPP source; all changes were done by modifying the RC
   file in Resource Workshop. Note that the 3 bitmaps are simply
   for demonstration ( different colors ) rather than 3 dimensional
Steps:
    -Make sure that the Windows style for the Dialog is "Bordlg"
    -choose borbtn from Workshop dialog toolbar
    -make sure button type is "bitmap"
     and take note of the control ID ( we will use later this ID
     later when renaming the bitmaps )
    -create Bitmap's for the various states
     ( Resource | New, BITMAP, give a filename, ex. my1.bmp, 
       ( the names btn?000.bmp have no significance in this example ))
    -then, Resource | Rename to identify the bitmap with the correct 
     offset ( button ID plus either 1000, 3000 or 5000 )
  */ 
#include <owl.h>
#include <dialog.h>
#include "dialtest.h"

class TTestDialog : public TDialog
{
public:
  TTestDialog(PTWindowsObject AParent, LPSTR AName)
    : TDialog(AParent, AName) {};
  virtual void HandleButtonMsg(RTMessage Msg)
    = [ID_FIRST + ID_BUTTON];
  virtual void HandleListBoxMsg(RTMessage Msg)
    = [ID_FIRST + ID_LISTBOX];
};

class TTestWindow : public TWindow
{
public:
  TTestWindow(PTWindowsObject AParent, LPSTR ATitle);
  virtual void CMTest(RTMessage Msg)
    = [CM_FIRST + CM_TEST];
};

class TTestApp : public TApplication
{
public:
  TTestApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow) :
    TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};

void TTestDialog::HandleButtonMsg(RTMessage)
{
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 1");
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 2");
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 3");
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 4");
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 5");
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 6");
  SendDlgItemMsg(ID_LISTBOX, LB_ADDSTRING, 0, (LONG)"Item 7");
}

void TTestDialog::HandleListBoxMsg(RTMessage Msg)
{
  DWORD Idx;
  char SelectedText[10];

  if ( Msg.LP.Hi == LBN_SELCHANGE )
  {
    Idx = SendDlgItemMsg(ID_LISTBOX, LB_GETCURSEL, 0, 0L);
    SendDlgItemMsg(ID_LISTBOX, LB_GETTEXT, (WORD)Idx, (DWORD)SelectedText);
    MessageBox(HWindow, SelectedText, "You selected", MB_OK);
  }
}

TTestWindow::TTestWindow(PTWindowsObject AParent, LPSTR ATitle)
  : TWindow(AParent, ATitle)
{
  AssignMenu("COMMANDS");
}

void TTestWindow::CMTest(RTMessage)
{
  GetApplication()->ExecDialog(new TTestDialog(this, "TESTDIALOG"));
}

void TTestApp::InitMainWindow()
{
  MainWindow = new TTestWindow(NULL, Name);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TTestApp TestApp("Dialog Tester", hInstance, hPrevInstance,
    lpCmdLine, nCmdShow);
  TestApp.Run();
  return (TestApp.Status);
}

