#include <owl.h>

#include "acchelpm.h"
#include "acchelpr.h"

#include "acchelp.h"

TOWLHELPApp::TOWLHELPApp( LPSTR lpszNam, HANDLE hInst, HANDLE hPrevInst, LPSTR lpszCmdLn, int nCmdShw )
	: TApplication( lpszNam, hInst, hPrevInst, lpszCmdLn, nCmdShw )
{
}

void TOWLHELPApp::InitInstance()
{
	TApplication::InitInstance();
	HAccTable = LoadAccelerators( hInstance, MAKEINTRESOURCE( OWLHELPAPACCEL ) );
}

void TOWLHELPApp::InitMainWindow()
{
	MainWindow = new TOWLHELPWnd( NULL, "OWL Help Example" );
}

TOWLHELPWnd::TOWLHELPWnd( PTWindowsObject AParent, LPSTR ATitle )
	: TWindow( AParent, ATitle )
{
}

LPSTR lpszClientAreaText = "The accelerator is SHIFT-F1 ";

void TOWLHELPWnd::Paint( HDC hdc, PAINTSTRUCT _FAR &)
{
	RECT rectClient;
	GetClientRect( HWindow , &rectClient );

	int nWidth = rectClient.right;		// rectClient.left is 0
	int nHeight = rectClient.bottom;	// rectClient.top is 0

	rectClient.left += (nWidth / 4);
	rectClient.top  += (nHeight / 4);
	rectClient.right -= (nWidth / 4);

	SetBkMode( hdc, TRANSPARENT );
	DrawText( hdc, lpszClientAreaText, lstrlen( lpszClientAreaText ),
		&rectClient, DT_CENTER | DT_VCENTER | DT_WORDBREAK );
}

void TOWLHELPWnd::GetWindowClass( WNDCLASS &AWndClass )
{
	TWindow::GetWindowClass( AWndClass );
	AWndClass.lpszMenuName = MAKEINTRESOURCE( OWLHELPAPMENU );
}

LPSTR TOWLHELPWnd::GetClassName()
{
	return "TOWLHELPWnd";
}

void TOWLHELPWnd::SetupWindow()
{
}

void TOWLHELPWnd::WMEnterIdle( RTMessage Msg )
{
	if( (Msg.WParam == MSGF_MENU ) && ((GetKeyState( VK_F1 ) & 0x8000) != 0) )
		// if the high bit is set, then the key is pressed
	{
		PostMessage( HWindow, WM_KEYDOWN, VK_RETURN, 0L );
	}
}

void TOWLHELPWnd::CMUMenuItemA( RTMessage )
{
    MessageBox( HWindow, "In Menu Item A command", Title, MB_ICONINFORMATION );
}

void TOWLHELPWnd::CMUMenuItemB( RTMessage )
{
    MessageBox( HWindow, "In Menu Item B Command", Title, MB_ICONINFORMATION );
}

void TOWLHELPWnd::CMExit( RTMessage Msg )
{
    TWindow::CMExit( Msg );
}

void TOWLHELPWnd::CMUHelpHelp( RTMessage )
{
    MessageBox( HWindow, "SHIFT-F1 was pressed!","AccHelp", MB_ICONINFORMATION );
}

void TOWLHELPWnd::CMUHelpAbout( RTMessage )
{
    MessageBox( HWindow, "Written using ObjectWindows\n",
                "About ACCHELP", MB_ICONINFORMATION );
}

int PASCAL WinMain( HANDLE hInst, HANDLE hPrevInst, LPSTR lpszCmdLn, int nCmdShw )
{
	TOWLHELPApp App( "OWLHELPAP", hInst, hPrevInst, lpszCmdLn, nCmdShw );

	App.Run();
	return App.Status;
}

