;  FUNCTION:  cpu_type
;	Determine CPU class.
;
; RETURNS:
;	AX = CPU type
;	0086 if 8088/8086
;	0286 if 80286
;	0386 if 80386
;	0486 if 80486
;
;	All regs preserved except AX.
;
;
; int cpu_type( void ) - returns 86, 186, 286, 386, 486
;
;-----------------------------------------------------------------------------

TITLE cpu_type - returns cpu type (86, 186, 286, 386, 486)

PAGE 66,132

.MODEL large

if (@CodeSize EQ 1)
    x	equ	6
else
    x	equ	4
endif

	sgmnt	equ	0
	offst	equ	2

if (@DataSize EQ 1) OR (@DataSize EQ 2)
    s_off	equ	4
    s_seg	equ	6
    len		equ	8
else
    string	equ	4
    len		equ	6
endif

.386p
.code
	public	_cpu_type
_cpu_type	proc
	push	bp			;Save regs
	mov		bp,sp		;set up our stack addressability
	pushf				;save the real flags register

	pop	ax			;get register off stack
	push	ax			;and save it again

	and	ax,0fffh		;zero out bits 12-15
	push	ax
	popf				;try to put into flags
	pushf
	pop	ax			;let's see what came out
		  			;of flags
	and	ax,0F000h		;mask off bits 12-15
	cmp	ax,0F000h		;were these bits all 1's
	je	short is_86			;if so, it's an 8086

	pop	ax			;get flags register to AX
	push	ax			;and save it again

     	or	ax,0F000h		;now try to set bits 12-15
	push	ax
	popf				;of the flags register
	pushf
	pop	ax			;and see what came out
	and	ax,0F000h		;are high bits set
	je	short is_286			;if so, we have a 386 or 486
;-----------------------------
	mov	edx,esp      ; Save stack pointer
	and	esp,not 3    ; Align stack pointer to prevent a fault
                             ;  when we set the AC flag on a 486
	pushfd               ; Copy the EFLAGS register
	pop	eax          ;   into register eax
	mov	ecx,eax      ; Save the original EFLAGS value
	xor	eax,40000H   ; Flip the AC flag bit
	push	eax         ; Try to put the modified value back
	popfd			;   into the EFLAGS register
	pushfd			; Copy the EFLAGS register again
	pop     eax          ;   into eax
	xor     eax,ecx      ; Compare the old and new AC bits
	shr     eax,18       ; Shift and mask to get the AC comparison bit
     	and     eax,1        ;   in the low order position of eax
	push    ecx
	popfd                ; Restore EFLAGS that were saved on entry
	mov     esp,edx      ; And restore stack pointer to saved value
	;;
	;; at this point ax = 0 on a 386
	;;               ax = 1 on a 486
	cmp	ax,0
	je	short is_386

is_486:	mov	ax,0486
	jmp	short	cpu_exit

;----------------------------------

is_386:	mov	ax,0386
	jmp	short	cpu_exit

is_286:	mov	ax,0286
	jmp	short	cpu_exit

is_86:	mov	ax,86

cpu_exit:
	popf			;restore flags
	pop	bp
	ret
_cpu_type	endp

	end
