/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <bios.h>


/***
 *
 *  Function   :    is_drive_ready
 *
 *  Topics     :    Returns if a floppy drive is ready or not.
 *
 *  Parameters :    in    int drive         0 = A:, 1 = B:
 *
 *  Return code:    0 if not ready (or invalid)
 *                  1 if ready
 ***/

int is_drive_ready( int drive )

{ int result;
  char buffer[512];

  do result = biosdisk( 4, drive, 0, 0, 0, 1, buffer );
  while ( result == 0x06 );

  return (! result);
}
