/*
 *
 * Record manipulation.  Provides Saving/Restoring of C++ structures.
 * This is a superclass that provides structured file I/O for both
 * the DATABASE and INDEX classes.
 *
 * (C) 1990 Vision Software
 *
 * $Id: access.h 1.2001 91/04/25 15:06:47 pcalvin release $
 *
 * Comments:
 *
 * In general, the PUBLIC does not need to use this class directly.  DATABASE
 * provides a much cleaner interface for most applications.  This class may
 * be used if the application wants to bypass indexing.
 *
 * Bugs:
 *
 * Right now, no caching takes place.  This is not technically a bug,
 * but caching would improve the performance of all disk access by
 * a large degree.  It would not be difficult to implement a LRU algorithm
 * for record access.
 *
 */
#if (!defined(__ACCESS__))
#define __ACCESS__

/*
 * Record manipulation(General usage)
 */
typedef UINT REC;
STATIC CONST REC recNil = 0;
STATIC CONST REC recError = -1;

/*
 *
 * Header record for each created file.  Helps find deleted records
 * within a file.
 *
 */
struct FHEADER
	{
	friend class ACCESS;
private:
	REC recFirstActive;					// First active record (Usually 0)
	REC recFirstDeleted;					// First deleted record
	REC recLastDeleted;					// Last deleted record
	CCH cchSizeofRecord;					//	Size of record when created
	};

/*
 *
 * Record Headers
 * Each record that is created & maintained using this system
 * is a subclass of this.
 * Using this approach.  We are able to control deleting and adding
 * of records with minimum effort.  Derived classes have this without
 * needing to code it.
 *
 */
struct INF
	{
	friend class ACCESS;
private:
	REC recNextDeleted;					// Next deleted record in the chain..
	};
typedef INF *PINF;
STATIC CONST PINF pinfNil = 0;

/*
 *
 * Record manipulation.  Superclass for both INDEX/DATABASE file controls
 * Handles deleting/saving or creating records
 * In the future, this class will provide caching of records using a
 * Least-Recently-Used Algorithm.  This is both Quick and Easy to implement
 *
 */
class ACCESS
	{
public:
	ACCESS(PINF pinf,CCH cchRecord,SZ szFileName,SZ szExtension,BOOL fCreateFile = fFalse);
	~ACCESS();
	BOOL FFirst(VOID);
	BOOL FSave(VOID);
	BOOL FDelete(VOID);
	BOOL FMark();
	BOOL FGotoMark();
	BOOL FGotoRec(REC rec);
	REC RecCreate(VOID);
	REC RecQuery(VOID);
	REC RecMaxQuery(VOID);
	PINF PinfQuery(VOID);
protected:
	BOOL FMakeFirstRec(REC rec);
private:
	BOOL FUpdateDatabase(PINF pinf,SZ sz,CCH cchNew,CCH cchOld);
	BOOL FCreateFile(SZ sz);
	SZ SzFullPathFromSzSz(SZ sz,SZ szExtension);
	REC RecFromStmCch(FILE *stmInput,CCH cchInput);
	FHEADER fhd;
	REC recMax;
	REC recCurrent;
	FILE *stmFile;
	CCH cch;
	PINF pinfBase;
	CHAR *rgchStorage;
	REC recMarked;
	STATIC SZ szDataPath;
	};


#endif	/* !defined(__ACCESS__) */
