/*
 *
 * Public Header file for the ADL.LIB toolkit
 *
 * (C) 1990 Vision Software
 *
 * $Id: adl.h 1.2002 91/05/03 14:31:25 pcalvin beta $
 *
 * Comments:
 *
 *	Not much to say
 *
 * Bugs:
 *
 * None documented
 *
 */
#if (!defined(__ADL__))
#define __ADL__

/*
 *	Macro that contains current version in a string..
 */
#define szADLVersion  "1.20"

/*
 * Windows/Text positioning
 */
typedef INT ROW;
STATIC CONST ROW rowNil = 0;

typedef INT COL;
STATIC CONST COL colNil = 0;

/*
 * Keycodes for input.
 * Using CD because a CH can only hold 8 bits
 */
typedef INT CD;

STATIC CONST CD cdNil = 0;
STATIC CONST CD cdEscape = 27;
STATIC CONST CD cdReturn = 13;
STATIC CONST CD cdTab = 9;
STATIC CONST CD cdBackSpace = 8;
STATIC CONST CD cdCursorLeft = 0x4b00;
STATIC CONST CD cdCursorRight = 0x4d00;
STATIC CONST CD cdCursorUp = 0x4800;
STATIC CONST CD cdCursorDown = 0x5000;
STATIC CONST CD cdPageDown = 0x5100;
STATIC CONST CD cdPageUp = 0x4900;
STATIC CONST CD cdHome = 0x4700;
STATIC CONST CD cdEnd = 0x4f00;
STATIC CONST CD cdDelete = 0x5300;
STATIC CONST CD cdInsert = 0x5200;
STATIC CONST CD cdHelp = 0x3b00;

/*
 * Colour constants.EGA mode
 */
typedef INT CO;
STATIC CONST CO coError = -1;
STATIC CONST CO coNil = 0;
STATIC CONST CO coBlack = 0;
STATIC CONST CO coBlue = 1;
STATIC CONST CO coGreen = 2;
STATIC CONST CO coCyan = 3;
STATIC CONST CO coRed = 4;
STATIC CONST CO coMagenta = 5;
STATIC CONST CO coBrown = 6;
STATIC CONST CO coWhite = 7;
STATIC CONST CO coDarkGray = 8;
STATIC CONST CO coLightBlue = 9;
STATIC CONST CO coLightGreen = 10;
STATIC CONST CO coLightCyan = 11;
STATIC CONST CO coLightRed = 12;
STATIC CONST CO coLightMagenta = 13;
STATIC CONST CO coYellow = 14;
STATIC CONST CO coBrightWhite = 15;

/*
 * Colour constants for Mono
 */
STATIC CONST CO coNormal = 7;
STATIC CONST CO coHigh = 15;
STATIC CONST CO coUnderline = 1;
STATIC CONST CO coHighUnder = 9;
STATIC CONST CO coReverse = 112;
STATIC CONST CO coHighReverse = 120;

/*
 * Window border types
 */
enum BD
	{
	bdNone = 0, bdSingle = 1, bdDouble = 2
	};

/*
 *
 * Context-sensitive help system
 *
 */
class HELP
	{
public:
	HELP(SZ sz);
	~HELP();
	VOID Replace(SZ sz);
private:
	VOID ShowCurrent();
	SZ szLast;
	STATIC VOID Start();
	STATIC SZ szCurrent;
	};

/*
 *
 * Cursor visibility control.
 * Using objects of this class will preserve the state of the cursor
 * After exiting the block..
 *
 */
class CURSOR
	{
public:
	CURSOR(BOOL fTurnOnCursor = fTrue);
	~CURSOR();
private:
	VOID Set(BOOL fTurnOn);
	BOOL fFinishState;
	STATIC BOOL fCurrentState;
	};

/*
 * Window subsystem.  Used by Popups (And subsequence classes) as
 * a basis for the screen control
 */
class WINDOW
	{
public:
	WINDOW(ROW row1,COL col1,ROW row2,COL col2,CO coFore,CO coBack,SZ sz=szNil,BOOL fScroll = fFalse);
	WINDOW(VOID);
	~WINDOW(VOID);
	VOID Draw(VOID);
	VOID Open(VOID);
	VOID Close(VOID);
	VOID Move(ROW row,COL col);
	ROW RowQuery(VOID);
	COL ColQuery(VOID);
	VOID Cls(VOID);
	VOID ClearRow(ROW rowClear);
	VOID ClearCol(COL colClear);
	VOID ScrollDrow(ROW drow);
	VOID ScrollDCol(COL dcol);
	VOID SetScrollCol(COL colLeft,COL colRight);
	VOID SetScrollRow(ROW rowTop,ROW rowBottom);
	VOID SetRowCol(ROW row,COL col);
	VOID Say(SZ sz,CO coFore = coError,CO coBack = coError);
	VOID SayAt(ROW row,COL col,SZ sz,CO coFore = coError,CO coBack = coError);
	VOID SayHot(ROW row,COL col,SZ sz,CCH cch,CO coFore = coError,CO coBack = coError);
	VOID SayCentered(ROW row,SZ sz,CO coFore = coError,CO coBack = coError);
	VOID PutCh(CHAR ch,CO coFore = coError,CO coBack = coError);
private:
	CO CoFromCoCo(CO coFore,CO coBack);
	VOID AdvanceCol(VOID);
	VOID AdvanceRow(VOID);
	VOID Restore(PUCH puch);
	VOID Save(PUCH puch);
	BOOL FValidWindow();
	ROW RowAbs(ROW row);
	COL ColAbs(COL col);
	ROW rowTop,rowBottom,rowCurrent,rowScrollTop,rowScrollBottom;
	COL colLeft,colRight,colCurrent,colScrollLeft,colScrollRight;
	PUCH puchBuffer;
	SZ szTitle;
	CO coForeground;
	CO coBackground;
	BOOL fAutomaticScroll;
	BOOL fOpen;
	};

/*
 *
 * Public utility routines.
 *
 */
EXTERN BOOL FAskSz(SZ sz,SZ szHelp = szNil);		// Asking Yes/No
EXTERN VOID SaySz(SZ sz,SZ szHelp = szNil);		// Message to user
EXTERN VOID ErrorSz(SZ sz,SZ szHelp = szNil);	// Error message to user
EXTERN CD CdInput(VOID);								// Generic Input Interface
EXTERN VOID Command(SZ sz = szNil);					// DOS Command

/*
 * Global variables to provide run-time dimensions for the screen..
 */
EXTERN ROW rowGlobalWindowBottom;
EXTERN COL colGlobalWindowRight;

#endif	/* !defined(__ADL__) */
