/*
 *
 * Generic Add/Edit Batch system
 *
 * (C) 1990 Vision Software
 *
 * $Id: batch.h 1.2002 91/05/03 17:39:23 pcalvin beta $
 *
 * Comments:
 *
 * This class provides batch edit services.  The user my edit records
 * in a structure as desired.  In addition, we now provide deleting
 * of records.
 *
 * Bugs:
 *
 *	None documented
 *
 */
#if (!defined(__BATCH__))
#define __BATCH__

#if (!defined(__EDIT__))
#include <edit.h>
#endif

#if (!defined(__DATABASE__))
#include <dbase.h>
#endif

#if (!defined(__MENU__))
#include <menu.h>
#endif

/*
 * Multiple index support.
 */
struct MI
	{
	CID cid;											// Index identifier
	SZ szIndex;										// Edit index here.
	SZ sz;											// Put index here
	CCH cch;											// Sizeof index entry
	ROW row;
	COL col;											// Where to place scroll box
	};
	
typedef struct MI *PMI;
STATIC CONST PMI pmiNil = Nil;

typedef INT CMI;
STATIC CONST CMI cmiNil = Nil;
STATIC CONST CMI cmiOpenMax = cidOpenMax;

/*
 *	Function types for Read/Write of records.
 *
 *	Prototype: VOID pfn(DBASE *)
 */
typedef VOID (*FNPDB)(DBASE *);
 
/*
 * Batch field editing.  Automatically saves/reads new records
 * when given an index field
 */
class BATCH : public EDIT
	{
public:
	BATCH(DBASE *pdb,CCH cch,SZ szFile,SZ szTitle = szNil,FNPDB pfnRead = Nil, FNPDB pfnWrite = Nil);
	BATCH(DATABASE &rdtbOriginal,SZ szTitle = szNil,FNPDB pfnRead = Nil, FNPDB pfnWrite = Nil);
	~BATCH();
	VOID Read();
	VOID Index(ROW row,COL col,SZ szFile,SZ szMsg,SZ sz,CHAR chPic,CCH cch,SZ szHelp = "",SZ szDefault = szNil);
	VOID Index(ROW row,COL col,CID cid,SZ szMsg,CHAR chPic,SZ szHelp = "",SZ szDefault = szNil);
	VOID IndexSelector(ROW row,COL col,SZ szMsg,CENT cent,PENT pent,CENT centDefault = centNil);
private:
	STATIC BOOL FChange(SZ sz,VOID *pvThis);
	STATIC BOOL FSelect(SZ sz,VOID *pvThis);
	BOOL FCreateIndex(SZ szIndex,CID cid,PED ped);
	BOOL FHandleCd(CD cd);
	BOOL FExit();
	BOOL FSelectCmi(CMI cmi);
	INLINE VOID PrepRecForRead();
	INLINE VOID PrepRecForWrite();
	VOID SaveIndexes();
	VOID RestoreIndexes();
	VOID MaybeSaveCurrent();
	BOOL fCreateRecord;
	BOOL fDeleteDatabase;
	DATABASE *pdtb;
	MI rgmiActive[cmiOpenMax];
	PMI pmiCurrent;
	CMI cmiMac;
	CENT centIndex;
	PENT pentIndex;
	PED pedIndex;
	FNPDB pfnRead;
	FNPDB pfnWrite;
	SZTEMP szSelector;
	};

#endif	/* !defined(__BATCH__) */
