/*
 *
 * File management/record access
 *
 * (C) 1990 Vision Softare
 *
 * $Id: dbase.c 1.2002 91/05/06 14:24:00 pcalvin beta $
 *
 * Comments:
 *
 * Much of the work for this is done by others.  ACCESS provides record
 * management and deletion.  INDEX provides use with efficient access
 * to the desired key.  Not much to do but organize and not step
 * on each others toes.
 *
 * Bugs:
 *
 * None documented
 *
 */
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <io.h>

#include <stdhdr.h>

#include <dbase.h>

/*
 *	If no records are active, clear the field
 *	There is no default index file.
 */
DATABASE::DATABASE(DBASE *pdb,CCH cchRecord,SZ szFileName,BOOL fCreate) : ACCESS(pdb,cchRecord,szFileName,".dtb",fCreate)
	{
	pidCurrent = pidNil;
	cidAvailableMac = cidNil;
	memset(pdb,0,cchRecord);
	}

/*
 *	With multiple indexes, we must destroy them ourselves.
 */
DATABASE::~DATABASE()
	{
	for (CID cid = cidNil; cid < cidAvailableMac; cid++)
		delete rgidActive[cid].pinx; 
	}
	
/*
 *	Marks the current record (including indexes)
 */
BOOL DATABASE::FMark()
	{
	PID pid = &rgidActive[0];
	CID cid = cidNil;

	while (cid < cidAvailableMac)
		{
	 	Verify(pid->pinx->FMark());
		
		cid++;
		}

	return (ACCESS::FMark());
	}

/*
 *	Goes to the previously marked record
 */
BOOL DATABASE::FGotoMark()
	{
	PID pid = &rgidActive[0];
	CID cid = cidNil;

	while (cid < cidAvailableMac)
		{
	 	Verify(pid->pinx->FGotoMark());
		
		cid++;
		}

	return (ACCESS::FGotoMark());
	}
	
/*
 *	Create additional indexes..
 */
CID DATABASE::CidIndexOn(SZ szFileName,CHAR *rgchKey,CCH cchKey)
	{
	AssertSz(cidAvailableMac < cidOpenMax,"Too many open index files");

	CID cid = cidAvailableMac++;

	rgidActive[cid].sz = rgchKey;
	rgidActive[cid].cch = cchKey;
	rgidActive[cid].pinx = new INDEX(szFileName,cchKey);

	Verify(FIndexTo(cid));
	
	return (cid);
	}

/*
 *	Select the current index
 */
BOOL DATABASE::FIndexTo(CID cid)
	{
	AssertSz(cid < cidAvailableMac,"Index file does not exist");

	pidCurrent = &rgidActive[cid];

	return (fTrue);
	}

/*
 *	Answers with some properties about the index, may specify
 *	a SPECIFIC index now.
 */
SZ DATABASE::SzIndex(CID cid)
	{
	PID pid = (cid == cidError) ? pidCurrent : &rgidActive[cid];
	
	AssertSz(pid != pidNil,"No default index file");
	
	return (pid->sz);
	}

CCH DATABASE::CchIndex(CID cid)
	{
	PID pid = (cid == cidError) ? pidCurrent : &rgidActive[cid];
	
	AssertSz(pid != pidNil,"No default index file");
	
	return (pid->cch);
	}
	
/*
 * Deletes the current record, using pidCurrent to
 *	find the next record.
 */
BOOL DATABASE::FDelete()
	{
	REC rec = (pidCurrent != pidNil) ? pidCurrent->pinx->RecDelete() : recError;
	PID pid = &rgidActive[0];
	CID cid = cidNil;
	
	/*
	 *	Get rid of this record
	 */
	Verify(ACCESS::FDelete()); 
	
	/*
	 *	Delete all entries in the other index files
	 */
	while (cid < cidAvailableMac)
		{
		if (pid != pidCurrent)
			pid->pinx->RecDelete();
		
		cid++;
		pid++;
		}

	/*
	 *	Goto the next available record.
	 *	Answer if it is available
	 */
	return (ACCESS::FGotoRec(rec));
	}

/*
 * Saves the current record..
 */
BOOL DATABASE::FSave()
	{
	return (ACCESS::FSave());
	}

/*
 * Moves the record pointer to the first record
 */
BOOL DATABASE::FFirst()
	{
	if (pidCurrent == pidNil)
		return (ACCESS::FFirst());
	else
		return (ACCESS::FGotoRec(pidCurrent->pinx->RecFirst()));
	}

/*
 *	Moves record pointer to the last record
 */
BOOL DATABASE::FLast()
	{
	if (pidCurrent == pidNil)
		return (ACCESS::FGotoRec(RecMaxQuery() - 1));
	else
		return (ACCESS::FGotoRec(pidCurrent->pinx->RecLast()));
	}

/*
 * Moves the record pointer forward 1 record
 */
BOOL DATABASE::FNext()
	{
	if (pidCurrent == pidNil)
		return (ACCESS::FGotoRec(RecQuery() + 1));
	else		
		return (ACCESS::FGotoRec(pidCurrent->pinx->RecNext()));
	}

/*
 * Moves the record pointer backwards 1 record
 */
BOOL DATABASE::FPrevious()
	{
	if (pidCurrent == pidNil)
		return (ACCESS::FGotoRec(RecQuery() - 1));
	else
		return (ACCESS::FGotoRec(pidCurrent->pinx->RecPrevious()));
	}

/*
 *	Searches for a specific record.
 *	NOTE: By Physical number, nothing to do with the index file
 */
BOOL DATABASE::FGotoRec(REC rec)
	{
	return (ACCESS::FGotoRec(rec));
	}
	
/*
 * Answers if the key can be found.  Does NOT create the record
 */
BOOL DATABASE::FGotoSz(SZ sz,BOOL fMatchIfClose)
	{
	Assert(sz != szNil);

	return (ACCESS::FGotoRec(pidCurrent->pinx->RecFromSz(sz,pidCurrent->cch,fMatchIfClose)));
	}

/*
 *	Answers if the record may be created.
 *	Updates all the active index files.
 */
BOOL DATABASE::FCreate()
	{
	REC rec = RecCreate();
	PID pid = &rgidActive[0];
	CID cid = cidNil;

	while (cid < cidAvailableMac)
		{
	 	Verify(pid->pinx->RecCreateSz(pid->sz,pid->cch,rec) == rec);
		
		cid++;
		pid++;
		}

	return (fTrue);
	}

/*
 * Answers with pointer to the DBASE structure for reading..
 */
DBASE *DATABASE::PdbQuery(VOID)
	{
	return ((DBASE *)PinfQuery());
	}

